<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Foundation.OutboundCommunicationsInputData StructType
 * @subpackage Structs
 */
class Foundation_OutboundCommunicationsInputData extends AnyEntity
{
    /**
     * The CommunicationsProfileId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CommunicationsProfileId;
    /**
     * The CommunicationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommunicationType;
    /**
     * The CommunicationTypeProcessingComponent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommunicationTypeProcessingComponent;
    /**
     * The SendingProcess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SendingProcess;
    /**
     * The SerializedMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerializedMessage;
    /**
     * Constructor method for Foundation.OutboundCommunicationsInputData
     * @uses Foundation_OutboundCommunicationsInputData::setCommunicationsProfileId()
     * @uses Foundation_OutboundCommunicationsInputData::setCommunicationType()
     * @uses Foundation_OutboundCommunicationsInputData::setCommunicationTypeProcessingComponent()
     * @uses Foundation_OutboundCommunicationsInputData::setSendingProcess()
     * @uses Foundation_OutboundCommunicationsInputData::setSerializedMessage()
     * @param string $communicationsProfileId
     * @param string $communicationType
     * @param string $communicationTypeProcessingComponent
     * @param string $sendingProcess
     * @param string $serializedMessage
     */
    public function __construct($communicationsProfileId = null, $communicationType = null, $communicationTypeProcessingComponent = null, $sendingProcess = null, $serializedMessage = null)
    {
        $this
            ->setCommunicationsProfileId($communicationsProfileId)
            ->setCommunicationType($communicationType)
            ->setCommunicationTypeProcessingComponent($communicationTypeProcessingComponent)
            ->setSendingProcess($sendingProcess)
            ->setSerializedMessage($serializedMessage);
    }
    /**
     * Get CommunicationsProfileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationsProfileId()
    {
        return isset($this->CommunicationsProfileId) ? $this->CommunicationsProfileId : null;
    }
    /**
     * Set CommunicationsProfileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationsProfileId
     * @return \patest\StructType\Foundation_OutboundCommunicationsInputData
     */
    public function setCommunicationsProfileId($communicationsProfileId = null)
    {
        // validation for constraint: string
        if (!is_null($communicationsProfileId) && !is_string($communicationsProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationsProfileId, true), gettype($communicationsProfileId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($communicationsProfileId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $communicationsProfileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($communicationsProfileId, true)), __LINE__);
        }
        if (is_null($communicationsProfileId) || (is_array($communicationsProfileId) && empty($communicationsProfileId))) {
            unset($this->CommunicationsProfileId);
        } else {
            $this->CommunicationsProfileId = $communicationsProfileId;
        }
        return $this;
    }
    /**
     * Get CommunicationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationType()
    {
        return isset($this->CommunicationType) ? $this->CommunicationType : null;
    }
    /**
     * Set CommunicationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationType
     * @return \patest\StructType\Foundation_OutboundCommunicationsInputData
     */
    public function setCommunicationType($communicationType = null)
    {
        // validation for constraint: string
        if (!is_null($communicationType) && !is_string($communicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationType, true), gettype($communicationType)), __LINE__);
        }
        if (is_null($communicationType) || (is_array($communicationType) && empty($communicationType))) {
            unset($this->CommunicationType);
        } else {
            $this->CommunicationType = $communicationType;
        }
        return $this;
    }
    /**
     * Get CommunicationTypeProcessingComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationTypeProcessingComponent()
    {
        return isset($this->CommunicationTypeProcessingComponent) ? $this->CommunicationTypeProcessingComponent : null;
    }
    /**
     * Set CommunicationTypeProcessingComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationTypeProcessingComponent
     * @return \patest\StructType\Foundation_OutboundCommunicationsInputData
     */
    public function setCommunicationTypeProcessingComponent($communicationTypeProcessingComponent = null)
    {
        // validation for constraint: string
        if (!is_null($communicationTypeProcessingComponent) && !is_string($communicationTypeProcessingComponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationTypeProcessingComponent, true), gettype($communicationTypeProcessingComponent)), __LINE__);
        }
        if (is_null($communicationTypeProcessingComponent) || (is_array($communicationTypeProcessingComponent) && empty($communicationTypeProcessingComponent))) {
            unset($this->CommunicationTypeProcessingComponent);
        } else {
            $this->CommunicationTypeProcessingComponent = $communicationTypeProcessingComponent;
        }
        return $this;
    }
    /**
     * Get SendingProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSendingProcess()
    {
        return isset($this->SendingProcess) ? $this->SendingProcess : null;
    }
    /**
     * Set SendingProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sendingProcess
     * @return \patest\StructType\Foundation_OutboundCommunicationsInputData
     */
    public function setSendingProcess($sendingProcess = null)
    {
        // validation for constraint: string
        if (!is_null($sendingProcess) && !is_string($sendingProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendingProcess, true), gettype($sendingProcess)), __LINE__);
        }
        if (is_null($sendingProcess) || (is_array($sendingProcess) && empty($sendingProcess))) {
            unset($this->SendingProcess);
        } else {
            $this->SendingProcess = $sendingProcess;
        }
        return $this;
    }
    /**
     * Get SerializedMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerializedMessage()
    {
        return isset($this->SerializedMessage) ? $this->SerializedMessage : null;
    }
    /**
     * Set SerializedMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serializedMessage
     * @return \patest\StructType\Foundation_OutboundCommunicationsInputData
     */
    public function setSerializedMessage($serializedMessage = null)
    {
        // validation for constraint: string
        if (!is_null($serializedMessage) && !is_string($serializedMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serializedMessage, true), gettype($serializedMessage)), __LINE__);
        }
        if (is_null($serializedMessage) || (is_array($serializedMessage) && empty($serializedMessage))) {
            unset($this->SerializedMessage);
        } else {
            $this->SerializedMessage = $serializedMessage;
        }
        return $this;
    }
}
