<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Foundation.JournalEntry StructType
 * @subpackage Structs
 */
class Foundation_JournalEntry extends VolatileEntity
{
    /**
     * The ApplicationChannelName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannelName;
    /**
     * The ConnectionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConnectionAuditId;
    /**
     * The CorrelationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CorrelationId;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTime;
    /**
     * The ErrorDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorDescription;
    /**
     * The EventDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDescription;
    /**
     * The EventSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventSystemName;
    /**
     * The EventType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventType;
    /**
     * The Importance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Importance;
    /**
     * The JournalSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JournalSystemName;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The SalePointName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalePointName;
    /**
     * The SecurityTokenName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecurityTokenName;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteName;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for Foundation.JournalEntry
     * @uses Foundation_JournalEntry::setApplicationChannelName()
     * @uses Foundation_JournalEntry::setConnectionAuditId()
     * @uses Foundation_JournalEntry::setCorrelationId()
     * @uses Foundation_JournalEntry::setDateTime()
     * @uses Foundation_JournalEntry::setErrorDescription()
     * @uses Foundation_JournalEntry::setEventDescription()
     * @uses Foundation_JournalEntry::setEventSystemName()
     * @uses Foundation_JournalEntry::setEventType()
     * @uses Foundation_JournalEntry::setImportance()
     * @uses Foundation_JournalEntry::setJournalSystemName()
     * @uses Foundation_JournalEntry::setOrganizationUnitId()
     * @uses Foundation_JournalEntry::setSalePointName()
     * @uses Foundation_JournalEntry::setSecurityTokenName()
     * @uses Foundation_JournalEntry::setSiteName()
     * @uses Foundation_JournalEntry::setUserId()
     * @uses Foundation_JournalEntry::setUserName()
     * @param string $applicationChannelName
     * @param int $connectionAuditId
     * @param string $correlationId
     * @param string $dateTime
     * @param string $errorDescription
     * @param string $eventDescription
     * @param string $eventSystemName
     * @param string $eventType
     * @param string $importance
     * @param string $journalSystemName
     * @param string $organizationUnitId
     * @param string $salePointName
     * @param string $securityTokenName
     * @param string $siteName
     * @param string $userId
     * @param string $userName
     */
    public function __construct($applicationChannelName = null, $connectionAuditId = null, $correlationId = null, $dateTime = null, $errorDescription = null, $eventDescription = null, $eventSystemName = null, $eventType = null, $importance = null, $journalSystemName = null, $organizationUnitId = null, $salePointName = null, $securityTokenName = null, $siteName = null, $userId = null, $userName = null)
    {
        $this
            ->setApplicationChannelName($applicationChannelName)
            ->setConnectionAuditId($connectionAuditId)
            ->setCorrelationId($correlationId)
            ->setDateTime($dateTime)
            ->setErrorDescription($errorDescription)
            ->setEventDescription($eventDescription)
            ->setEventSystemName($eventSystemName)
            ->setEventType($eventType)
            ->setImportance($importance)
            ->setJournalSystemName($journalSystemName)
            ->setOrganizationUnitId($organizationUnitId)
            ->setSalePointName($salePointName)
            ->setSecurityTokenName($securityTokenName)
            ->setSiteName($siteName)
            ->setUserId($userId)
            ->setUserName($userName);
    }
    /**
     * Get ApplicationChannelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannelName()
    {
        return isset($this->ApplicationChannelName) ? $this->ApplicationChannelName : null;
    }
    /**
     * Set ApplicationChannelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannelName
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setApplicationChannelName($applicationChannelName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannelName) && !is_string($applicationChannelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannelName, true), gettype($applicationChannelName)), __LINE__);
        }
        if (is_null($applicationChannelName) || (is_array($applicationChannelName) && empty($applicationChannelName))) {
            unset($this->ApplicationChannelName);
        } else {
            $this->ApplicationChannelName = $applicationChannelName;
        }
        return $this;
    }
    /**
     * Get ConnectionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConnectionAuditId()
    {
        return isset($this->ConnectionAuditId) ? $this->ConnectionAuditId : null;
    }
    /**
     * Set ConnectionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $connectionAuditId
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setConnectionAuditId($connectionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($connectionAuditId) && !(is_int($connectionAuditId) || ctype_digit($connectionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectionAuditId, true), gettype($connectionAuditId)), __LINE__);
        }
        if (is_null($connectionAuditId) || (is_array($connectionAuditId) && empty($connectionAuditId))) {
            unset($this->ConnectionAuditId);
        } else {
            $this->ConnectionAuditId = $connectionAuditId;
        }
        return $this;
    }
    /**
     * Get CorrelationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCorrelationId()
    {
        return isset($this->CorrelationId) ? $this->CorrelationId : null;
    }
    /**
     * Set CorrelationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $correlationId
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setCorrelationId($correlationId = null)
    {
        // validation for constraint: string
        if (!is_null($correlationId) && !is_string($correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationId, true), gettype($correlationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($correlationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($correlationId, true)), __LINE__);
        }
        if (is_null($correlationId) || (is_array($correlationId) && empty($correlationId))) {
            unset($this->CorrelationId);
        } else {
            $this->CorrelationId = $correlationId;
        }
        return $this;
    }
    /**
     * Get DateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTime()
    {
        return isset($this->DateTime) ? $this->DateTime : null;
    }
    /**
     * Set DateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTime
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->DateTime);
        } else {
            $this->DateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Get ErrorDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorDescription()
    {
        return isset($this->ErrorDescription) ? $this->ErrorDescription : null;
    }
    /**
     * Set ErrorDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorDescription
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setErrorDescription($errorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($errorDescription) && !is_string($errorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorDescription, true), gettype($errorDescription)), __LINE__);
        }
        if (is_null($errorDescription) || (is_array($errorDescription) && empty($errorDescription))) {
            unset($this->ErrorDescription);
        } else {
            $this->ErrorDescription = $errorDescription;
        }
        return $this;
    }
    /**
     * Get EventDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDescription()
    {
        return isset($this->EventDescription) ? $this->EventDescription : null;
    }
    /**
     * Set EventDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDescription
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDescription, true), gettype($eventDescription)), __LINE__);
        }
        if (is_null($eventDescription) || (is_array($eventDescription) && empty($eventDescription))) {
            unset($this->EventDescription);
        } else {
            $this->EventDescription = $eventDescription;
        }
        return $this;
    }
    /**
     * Get EventSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventSystemName()
    {
        return isset($this->EventSystemName) ? $this->EventSystemName : null;
    }
    /**
     * Set EventSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventSystemName
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setEventSystemName($eventSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($eventSystemName) && !is_string($eventSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventSystemName, true), gettype($eventSystemName)), __LINE__);
        }
        if (is_null($eventSystemName) || (is_array($eventSystemName) && empty($eventSystemName))) {
            unset($this->EventSystemName);
        } else {
            $this->EventSystemName = $eventSystemName;
        }
        return $this;
    }
    /**
     * Get EventType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventType()
    {
        return isset($this->EventType) ? $this->EventType : null;
    }
    /**
     * Set EventType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JournalEventType::valueIsValid()
     * @uses \patest\EnumType\JournalEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventType
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JournalEventType::valueIsValid($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JournalEventType', is_array($eventType) ? implode(', ', $eventType) : var_export($eventType, true), implode(', ', \patest\EnumType\JournalEventType::getValidValues())), __LINE__);
        }
        if (is_null($eventType) || (is_array($eventType) && empty($eventType))) {
            unset($this->EventType);
        } else {
            $this->EventType = $eventType;
        }
        return $this;
    }
    /**
     * Get Importance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportance()
    {
        return isset($this->Importance) ? $this->Importance : null;
    }
    /**
     * Set Importance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JournalEntryImportance::valueIsValid()
     * @uses \patest\EnumType\JournalEntryImportance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importance
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setImportance($importance = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JournalEntryImportance::valueIsValid($importance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JournalEntryImportance', is_array($importance) ? implode(', ', $importance) : var_export($importance, true), implode(', ', \patest\EnumType\JournalEntryImportance::getValidValues())), __LINE__);
        }
        if (is_null($importance) || (is_array($importance) && empty($importance))) {
            unset($this->Importance);
        } else {
            $this->Importance = $importance;
        }
        return $this;
    }
    /**
     * Get JournalSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJournalSystemName()
    {
        return isset($this->JournalSystemName) ? $this->JournalSystemName : null;
    }
    /**
     * Set JournalSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $journalSystemName
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setJournalSystemName($journalSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($journalSystemName) && !is_string($journalSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journalSystemName, true), gettype($journalSystemName)), __LINE__);
        }
        if (is_null($journalSystemName) || (is_array($journalSystemName) && empty($journalSystemName))) {
            unset($this->JournalSystemName);
        } else {
            $this->JournalSystemName = $journalSystemName;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get SalePointName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointName()
    {
        return isset($this->SalePointName) ? $this->SalePointName : null;
    }
    /**
     * Set SalePointName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointName
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setSalePointName($salePointName = null)
    {
        // validation for constraint: string
        if (!is_null($salePointName) && !is_string($salePointName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointName, true), gettype($salePointName)), __LINE__);
        }
        if (is_null($salePointName) || (is_array($salePointName) && empty($salePointName))) {
            unset($this->SalePointName);
        } else {
            $this->SalePointName = $salePointName;
        }
        return $this;
    }
    /**
     * Get SecurityTokenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenName()
    {
        return isset($this->SecurityTokenName) ? $this->SecurityTokenName : null;
    }
    /**
     * Set SecurityTokenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenName
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setSecurityTokenName($securityTokenName = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenName) && !is_string($securityTokenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenName, true), gettype($securityTokenName)), __LINE__);
        }
        if (is_null($securityTokenName) || (is_array($securityTokenName) && empty($securityTokenName))) {
            unset($this->SecurityTokenName);
        } else {
            $this->SecurityTokenName = $securityTokenName;
        }
        return $this;
    }
    /**
     * Get SiteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteName()
    {
        return isset($this->SiteName) ? $this->SiteName : null;
    }
    /**
     * Set SiteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteName
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setSiteName($siteName = null)
    {
        // validation for constraint: string
        if (!is_null($siteName) && !is_string($siteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteName, true), gettype($siteName)), __LINE__);
        }
        if (is_null($siteName) || (is_array($siteName) && empty($siteName))) {
            unset($this->SiteName);
        } else {
            $this->SiteName = $siteName;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Foundation_JournalEntry
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
}
