<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FirstEventDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FirstEventDetails
 * @subpackage Structs
 */
class FirstEventDetails extends AbstractStructBase
{
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The FormattedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedDate;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The OccupancyStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OccupancyStatus;
    /**
     * The IsFutureSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFutureSale;
    /**
     * The IsSoldOut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSoldOut;
    /**
     * The DateFormatOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateFormatOptions;
    /**
     * Constructor method for FirstEventDetails
     * @uses FirstEventDetails::setEventDate()
     * @uses FirstEventDetails::setEventId()
     * @uses FirstEventDetails::setFormattedDate()
     * @uses FirstEventDetails::setHallName()
     * @uses FirstEventDetails::setOccupancyStatus()
     * @uses FirstEventDetails::setIsFutureSale()
     * @uses FirstEventDetails::setIsSoldOut()
     * @uses FirstEventDetails::setDateFormatOptions()
     * @param string $eventDate
     * @param string $eventId
     * @param string $formattedDate
     * @param string $hallName
     * @param string $occupancyStatus
     * @param bool $isFutureSale
     * @param bool $isSoldOut
     * @param string $dateFormatOptions
     */
    public function __construct($eventDate = null, $eventId = null, $formattedDate = null, $hallName = null, $occupancyStatus = null, $isFutureSale = null, $isSoldOut = null, $dateFormatOptions = null)
    {
        $this
            ->setEventDate($eventDate)
            ->setEventId($eventId)
            ->setFormattedDate($formattedDate)
            ->setHallName($hallName)
            ->setOccupancyStatus($occupancyStatus)
            ->setIsFutureSale($isFutureSale)
            ->setIsSoldOut($isSoldOut)
            ->setDateFormatOptions($dateFormatOptions);
    }
    /**
     * Get EventDate value
     * @return string|null
     */
    public function getEventDate()
    {
        return $this->EventDate;
    }
    /**
     * Set EventDate value
     * @param string $eventDate
     * @return \patest\StructType\FirstEventDetails
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        $this->EventDate = $eventDate;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\FirstEventDetails
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get FormattedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedDate()
    {
        return isset($this->FormattedDate) ? $this->FormattedDate : null;
    }
    /**
     * Set FormattedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedDate
     * @return \patest\StructType\FirstEventDetails
     */
    public function setFormattedDate($formattedDate = null)
    {
        // validation for constraint: string
        if (!is_null($formattedDate) && !is_string($formattedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedDate, true), gettype($formattedDate)), __LINE__);
        }
        if (is_null($formattedDate) || (is_array($formattedDate) && empty($formattedDate))) {
            unset($this->FormattedDate);
        } else {
            $this->FormattedDate = $formattedDate;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\FirstEventDetails
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get OccupancyStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOccupancyStatus()
    {
        return isset($this->OccupancyStatus) ? $this->OccupancyStatus : null;
    }
    /**
     * Set OccupancyStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventOccupancyStatus::valueIsValid()
     * @uses \patest\EnumType\EventOccupancyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupancyStatus
     * @return \patest\StructType\FirstEventDetails
     */
    public function setOccupancyStatus($occupancyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventOccupancyStatus::valueIsValid($occupancyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventOccupancyStatus', is_array($occupancyStatus) ? implode(', ', $occupancyStatus) : var_export($occupancyStatus, true), implode(', ', \patest\EnumType\EventOccupancyStatus::getValidValues())), __LINE__);
        }
        if (is_null($occupancyStatus) || (is_array($occupancyStatus) && empty($occupancyStatus))) {
            unset($this->OccupancyStatus);
        } else {
            $this->OccupancyStatus = $occupancyStatus;
        }
        return $this;
    }
    /**
     * Get IsFutureSale value
     * @return bool|null
     */
    public function getIsFutureSale()
    {
        return $this->IsFutureSale;
    }
    /**
     * Set IsFutureSale value
     * @param bool $isFutureSale
     * @return \patest\StructType\FirstEventDetails
     */
    public function setIsFutureSale($isFutureSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFutureSale) && !is_bool($isFutureSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFutureSale, true), gettype($isFutureSale)), __LINE__);
        }
        $this->IsFutureSale = $isFutureSale;
        return $this;
    }
    /**
     * Get IsSoldOut value
     * @return bool|null
     */
    public function getIsSoldOut()
    {
        return $this->IsSoldOut;
    }
    /**
     * Set IsSoldOut value
     * @param bool $isSoldOut
     * @return \patest\StructType\FirstEventDetails
     */
    public function setIsSoldOut($isSoldOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSoldOut) && !is_bool($isSoldOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSoldOut, true), gettype($isSoldOut)), __LINE__);
        }
        $this->IsSoldOut = $isSoldOut;
        return $this;
    }
    /**
     * Get DateFormatOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFormatOptions()
    {
        return isset($this->DateFormatOptions) ? $this->DateFormatOptions : null;
    }
    /**
     * Set DateFormatOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventDateFormatOptions::valueIsValid()
     * @uses \patest\EnumType\EventDateFormatOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateFormatOptions
     * @return \patest\StructType\FirstEventDetails
     */
    public function setDateFormatOptions($dateFormatOptions = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventDateFormatOptions::valueIsValid($dateFormatOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventDateFormatOptions', is_array($dateFormatOptions) ? implode(', ', $dateFormatOptions) : var_export($dateFormatOptions, true), implode(', ', \patest\EnumType\EventDateFormatOptions::getValidValues())), __LINE__);
        }
        if (is_null($dateFormatOptions) || (is_array($dateFormatOptions) && empty($dateFormatOptions))) {
            unset($this->DateFormatOptions);
        } else {
            $this->DateFormatOptions = $dateFormatOptions;
        }
        return $this;
    }
}
