<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindShows-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FindShows-Request
 * @subpackage Structs
 */
class FindShows_Request extends ExtensibleDataContract
{
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityName;
    /**
     * The FreeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FreeText;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The GenreName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GenreName;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The SearchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SearchType;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowName;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The AssociatedDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDateFrom;
    /**
     * The AssociatedDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDateTo;
    /**
     * The VenueName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VenueName;
    /**
     * The IsGroupTour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupTour;
    /**
     * The IsTour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTour;
    /**
     * Constructor method for FindShows-Request
     * @uses FindShows_Request::setCityName()
     * @uses FindShows_Request::setFreeText()
     * @uses FindShows_Request::setFromDate()
     * @uses FindShows_Request::setGenreName()
     * @uses FindShows_Request::setHallName()
     * @uses FindShows_Request::setSearchType()
     * @uses FindShows_Request::setShowName()
     * @uses FindShows_Request::setToDate()
     * @uses FindShows_Request::setAssociatedDateFrom()
     * @uses FindShows_Request::setAssociatedDateTo()
     * @uses FindShows_Request::setVenueName()
     * @uses FindShows_Request::setIsGroupTour()
     * @uses FindShows_Request::setIsTour()
     * @param string $cityName
     * @param string $freeText
     * @param string $fromDate
     * @param string $genreName
     * @param string $hallName
     * @param string $searchType
     * @param string $showName
     * @param string $toDate
     * @param string $associatedDateFrom
     * @param string $associatedDateTo
     * @param string $venueName
     * @param bool $isGroupTour
     * @param bool $isTour
     */
    public function __construct($cityName = null, $freeText = null, $fromDate = null, $genreName = null, $hallName = null, $searchType = null, $showName = null, $toDate = null, $associatedDateFrom = null, $associatedDateTo = null, $venueName = null, $isGroupTour = null, $isTour = null)
    {
        $this
            ->setCityName($cityName)
            ->setFreeText($freeText)
            ->setFromDate($fromDate)
            ->setGenreName($genreName)
            ->setHallName($hallName)
            ->setSearchType($searchType)
            ->setShowName($showName)
            ->setToDate($toDate)
            ->setAssociatedDateFrom($associatedDateFrom)
            ->setAssociatedDateTo($associatedDateTo)
            ->setVenueName($venueName)
            ->setIsGroupTour($isGroupTour)
            ->setIsTour($isTour);
    }
    /**
     * Get CityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityName()
    {
        return isset($this->CityName) ? $this->CityName : null;
    }
    /**
     * Set CityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityName
     * @return \patest\StructType\FindShows_Request
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        if (is_null($cityName) || (is_array($cityName) && empty($cityName))) {
            unset($this->CityName);
        } else {
            $this->CityName = $cityName;
        }
        return $this;
    }
    /**
     * Get FreeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFreeText()
    {
        return isset($this->FreeText) ? $this->FreeText : null;
    }
    /**
     * Set FreeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $freeText
     * @return \patest\StructType\FindShows_Request
     */
    public function setFreeText($freeText = null)
    {
        // validation for constraint: string
        if (!is_null($freeText) && !is_string($freeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($freeText, true), gettype($freeText)), __LINE__);
        }
        if (is_null($freeText) || (is_array($freeText) && empty($freeText))) {
            unset($this->FreeText);
        } else {
            $this->FreeText = $freeText;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\FindShows_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get GenreName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenreName()
    {
        return isset($this->GenreName) ? $this->GenreName : null;
    }
    /**
     * Set GenreName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $genreName
     * @return \patest\StructType\FindShows_Request
     */
    public function setGenreName($genreName = null)
    {
        // validation for constraint: string
        if (!is_null($genreName) && !is_string($genreName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genreName, true), gettype($genreName)), __LINE__);
        }
        if (is_null($genreName) || (is_array($genreName) && empty($genreName))) {
            unset($this->GenreName);
        } else {
            $this->GenreName = $genreName;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\FindShows_Request
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get SearchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->SearchType;
    }
    /**
     * Set SearchType value
     * @uses \patest\EnumType\ShowSearchType::valueIsValid()
     * @uses \patest\EnumType\ShowSearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \patest\StructType\FindShows_Request
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ShowSearchType::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ShowSearchType', is_array($searchType) ? implode(', ', $searchType) : var_export($searchType, true), implode(', ', \patest\EnumType\ShowSearchType::getValidValues())), __LINE__);
        }
        $this->SearchType = $searchType;
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showName
     * @return \patest\StructType\FindShows_Request
     */
    public function setShowName($showName = null)
    {
        // validation for constraint: string
        if (!is_null($showName) && !is_string($showName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showName, true), gettype($showName)), __LINE__);
        }
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\FindShows_Request
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get AssociatedDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDateFrom()
    {
        return isset($this->AssociatedDateFrom) ? $this->AssociatedDateFrom : null;
    }
    /**
     * Set AssociatedDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDateFrom
     * @return \patest\StructType\FindShows_Request
     */
    public function setAssociatedDateFrom($associatedDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDateFrom) && !is_string($associatedDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDateFrom, true), gettype($associatedDateFrom)), __LINE__);
        }
        if (is_null($associatedDateFrom) || (is_array($associatedDateFrom) && empty($associatedDateFrom))) {
            unset($this->AssociatedDateFrom);
        } else {
            $this->AssociatedDateFrom = $associatedDateFrom;
        }
        return $this;
    }
    /**
     * Get AssociatedDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDateTo()
    {
        return isset($this->AssociatedDateTo) ? $this->AssociatedDateTo : null;
    }
    /**
     * Set AssociatedDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDateTo
     * @return \patest\StructType\FindShows_Request
     */
    public function setAssociatedDateTo($associatedDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDateTo) && !is_string($associatedDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDateTo, true), gettype($associatedDateTo)), __LINE__);
        }
        if (is_null($associatedDateTo) || (is_array($associatedDateTo) && empty($associatedDateTo))) {
            unset($this->AssociatedDateTo);
        } else {
            $this->AssociatedDateTo = $associatedDateTo;
        }
        return $this;
    }
    /**
     * Get VenueName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueName()
    {
        return isset($this->VenueName) ? $this->VenueName : null;
    }
    /**
     * Set VenueName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueName
     * @return \patest\StructType\FindShows_Request
     */
    public function setVenueName($venueName = null)
    {
        // validation for constraint: string
        if (!is_null($venueName) && !is_string($venueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueName, true), gettype($venueName)), __LINE__);
        }
        if (is_null($venueName) || (is_array($venueName) && empty($venueName))) {
            unset($this->VenueName);
        } else {
            $this->VenueName = $venueName;
        }
        return $this;
    }
    /**
     * Get IsGroupTour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupTour()
    {
        return isset($this->IsGroupTour) ? $this->IsGroupTour : null;
    }
    /**
     * Set IsGroupTour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupTour
     * @return \patest\StructType\FindShows_Request
     */
    public function setIsGroupTour($isGroupTour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupTour) && !is_bool($isGroupTour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupTour, true), gettype($isGroupTour)), __LINE__);
        }
        if (is_null($isGroupTour) || (is_array($isGroupTour) && empty($isGroupTour))) {
            unset($this->IsGroupTour);
        } else {
            $this->IsGroupTour = $isGroupTour;
        }
        return $this;
    }
    /**
     * Get IsTour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTour()
    {
        return isset($this->IsTour) ? $this->IsTour : null;
    }
    /**
     * Set IsTour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTour
     * @return \patest\StructType\FindShows_Request
     */
    public function setIsTour($isTour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTour) && !is_bool($isTour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTour, true), gettype($isTour)), __LINE__);
        }
        if (is_null($isTour) || (is_array($isTour) && empty($isTour))) {
            unset($this->IsTour);
        } else {
            $this->IsTour = $isTour;
        }
        return $this;
    }
}
