<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FailureInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FailureInformation
 * @subpackage Structs
 */
class FailureInformation extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The LocalizedText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalizedText;
    /**
     * The SystemText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemText;
    /**
     * Constructor method for FailureInformation
     * @uses FailureInformation::setCode()
     * @uses FailureInformation::setLocalizedText()
     * @uses FailureInformation::setSystemText()
     * @param string $code
     * @param string $localizedText
     * @param string $systemText
     */
    public function __construct($code = null, $localizedText = null, $systemText = null)
    {
        $this
            ->setCode($code)
            ->setLocalizedText($localizedText)
            ->setSystemText($systemText);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \patest\StructType\FailureInformation
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get LocalizedText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalizedText()
    {
        return isset($this->LocalizedText) ? $this->LocalizedText : null;
    }
    /**
     * Set LocalizedText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localizedText
     * @return \patest\StructType\FailureInformation
     */
    public function setLocalizedText($localizedText = null)
    {
        // validation for constraint: string
        if (!is_null($localizedText) && !is_string($localizedText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localizedText, true), gettype($localizedText)), __LINE__);
        }
        if (is_null($localizedText) || (is_array($localizedText) && empty($localizedText))) {
            unset($this->LocalizedText);
        } else {
            $this->LocalizedText = $localizedText;
        }
        return $this;
    }
    /**
     * Get SystemText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemText()
    {
        return isset($this->SystemText) ? $this->SystemText : null;
    }
    /**
     * Set SystemText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemText
     * @return \patest\StructType\FailureInformation
     */
    public function setSystemText($systemText = null)
    {
        // validation for constraint: string
        if (!is_null($systemText) && !is_string($systemText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemText, true), gettype($systemText)), __LINE__);
        }
        if (is_null($systemText) || (is_array($systemText) && empty($systemText))) {
            unset($this->SystemText);
        } else {
            $this->SystemText = $systemText;
        }
        return $this;
    }
}
