<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Facade.ProductEntryBatch StructType
 * @subpackage Structs
 */
class Facade_ProductEntryBatch extends PersistableEntity
{
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Comments;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $Duration;
    /**
     * The ExecuteBy
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExecuteBy;
    /**
     * The FailedRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedRecords;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The ImportDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportDate;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProcessedRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProcessedRecords;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SuccessfulRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SuccessfulRecords;
    /**
     * The TotalRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalRecords;
    /**
     * Constructor method for Facade.ProductEntryBatch
     * @uses Facade_ProductEntryBatch::setComments()
     * @uses Facade_ProductEntryBatch::setDuration()
     * @uses Facade_ProductEntryBatch::setExecuteBy()
     * @uses Facade_ProductEntryBatch::setFailedRecords()
     * @uses Facade_ProductEntryBatch::setFileName()
     * @uses Facade_ProductEntryBatch::setImportDate()
     * @uses Facade_ProductEntryBatch::setOrganizationUnitId()
     * @uses Facade_ProductEntryBatch::setProcessedRecords()
     * @uses Facade_ProductEntryBatch::setStatus()
     * @uses Facade_ProductEntryBatch::setSuccessfulRecords()
     * @uses Facade_ProductEntryBatch::setTotalRecords()
     * @param \patest\StructType\GlobalString $comments
     * @param string $duration
     * @param string $executeBy
     * @param int $failedRecords
     * @param string $fileName
     * @param string $importDate
     * @param string $organizationUnitId
     * @param int $processedRecords
     * @param string $status
     * @param int $successfulRecords
     * @param int $totalRecords
     */
    public function __construct(\patest\StructType\GlobalString $comments = null, $duration = null, $executeBy = null, $failedRecords = null, $fileName = null, $importDate = null, $organizationUnitId = null, $processedRecords = null, $status = null, $successfulRecords = null, $totalRecords = null)
    {
        $this
            ->setComments($comments)
            ->setDuration($duration)
            ->setExecuteBy($executeBy)
            ->setFailedRecords($failedRecords)
            ->setFileName($fileName)
            ->setImportDate($importDate)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProcessedRecords($processedRecords)
            ->setStatus($status)
            ->setSuccessfulRecords($successfulRecords)
            ->setTotalRecords($totalRecords);
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $comments
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setComments(\patest\StructType\GlobalString $comments = null)
    {
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $duration
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($duration) && false === mb_strpos($duration, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $duration)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($duration, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($duration) && false !== mb_strpos($duration, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $duration)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($duration, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($duration) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($duration, true)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get ExecuteBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecuteBy()
    {
        return isset($this->ExecuteBy) ? $this->ExecuteBy : null;
    }
    /**
     * Set ExecuteBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executeBy
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setExecuteBy($executeBy = null)
    {
        // validation for constraint: string
        if (!is_null($executeBy) && !is_string($executeBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executeBy, true), gettype($executeBy)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($executeBy) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $executeBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($executeBy, true)), __LINE__);
        }
        if (is_null($executeBy) || (is_array($executeBy) && empty($executeBy))) {
            unset($this->ExecuteBy);
        } else {
            $this->ExecuteBy = $executeBy;
        }
        return $this;
    }
    /**
     * Get FailedRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedRecords()
    {
        return isset($this->FailedRecords) ? $this->FailedRecords : null;
    }
    /**
     * Set FailedRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedRecords
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setFailedRecords($failedRecords = null)
    {
        // validation for constraint: int
        if (!is_null($failedRecords) && !(is_int($failedRecords) || ctype_digit($failedRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedRecords, true), gettype($failedRecords)), __LINE__);
        }
        if (is_null($failedRecords) || (is_array($failedRecords) && empty($failedRecords))) {
            unset($this->FailedRecords);
        } else {
            $this->FailedRecords = $failedRecords;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get ImportDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportDate()
    {
        return isset($this->ImportDate) ? $this->ImportDate : null;
    }
    /**
     * Set ImportDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importDate
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setImportDate($importDate = null)
    {
        // validation for constraint: string
        if (!is_null($importDate) && !is_string($importDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importDate, true), gettype($importDate)), __LINE__);
        }
        if (is_null($importDate) || (is_array($importDate) && empty($importDate))) {
            unset($this->ImportDate);
        } else {
            $this->ImportDate = $importDate;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProcessedRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessedRecords()
    {
        return isset($this->ProcessedRecords) ? $this->ProcessedRecords : null;
    }
    /**
     * Set ProcessedRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processedRecords
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setProcessedRecords($processedRecords = null)
    {
        // validation for constraint: int
        if (!is_null($processedRecords) && !(is_int($processedRecords) || ctype_digit($processedRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processedRecords, true), gettype($processedRecords)), __LINE__);
        }
        if (is_null($processedRecords) || (is_array($processedRecords) && empty($processedRecords))) {
            unset($this->ProcessedRecords);
        } else {
            $this->ProcessedRecords = $processedRecords;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchEntryProcessStatus::valueIsValid()
     * @uses \patest\EnumType\BatchEntryProcessStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchEntryProcessStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchEntryProcessStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\BatchEntryProcessStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SuccessfulRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSuccessfulRecords()
    {
        return isset($this->SuccessfulRecords) ? $this->SuccessfulRecords : null;
    }
    /**
     * Set SuccessfulRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $successfulRecords
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setSuccessfulRecords($successfulRecords = null)
    {
        // validation for constraint: int
        if (!is_null($successfulRecords) && !(is_int($successfulRecords) || ctype_digit($successfulRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($successfulRecords, true), gettype($successfulRecords)), __LINE__);
        }
        if (is_null($successfulRecords) || (is_array($successfulRecords) && empty($successfulRecords))) {
            unset($this->SuccessfulRecords);
        } else {
            $this->SuccessfulRecords = $successfulRecords;
        }
        return $this;
    }
    /**
     * Get TotalRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalRecords()
    {
        return isset($this->TotalRecords) ? $this->TotalRecords : null;
    }
    /**
     * Set TotalRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalRecords
     * @return \patest\StructType\Facade_ProductEntryBatch
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        if (is_null($totalRecords) || (is_array($totalRecords) && empty($totalRecords))) {
            unset($this->TotalRecords);
        } else {
            $this->TotalRecords = $totalRecords;
        }
        return $this;
    }
}
