<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportAccessCodes-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExportAccessCodes-Request
 * @subpackage Structs
 */
class ExportAccessCodes_Request extends ExtensibleDataContract
{
    /**
     * The IncludeCounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeCounts;
    /**
     * The IncludeInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeInactive;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * Constructor method for ExportAccessCodes-Request
     * @uses ExportAccessCodes_Request::setIncludeCounts()
     * @uses ExportAccessCodes_Request::setIncludeInactive()
     * @uses ExportAccessCodes_Request::setPresaleId()
     * @param bool $includeCounts
     * @param bool $includeInactive
     * @param string $presaleId
     */
    public function __construct($includeCounts = null, $includeInactive = null, $presaleId = null)
    {
        $this
            ->setIncludeCounts($includeCounts)
            ->setIncludeInactive($includeInactive)
            ->setPresaleId($presaleId);
    }
    /**
     * Get IncludeCounts value
     * @return bool|null
     */
    public function getIncludeCounts()
    {
        return $this->IncludeCounts;
    }
    /**
     * Set IncludeCounts value
     * @param bool $includeCounts
     * @return \patest\StructType\ExportAccessCodes_Request
     */
    public function setIncludeCounts($includeCounts = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCounts) && !is_bool($includeCounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCounts, true), gettype($includeCounts)), __LINE__);
        }
        $this->IncludeCounts = $includeCounts;
        return $this;
    }
    /**
     * Get IncludeInactive value
     * @return bool|null
     */
    public function getIncludeInactive()
    {
        return $this->IncludeInactive;
    }
    /**
     * Set IncludeInactive value
     * @param bool $includeInactive
     * @return \patest\StructType\ExportAccessCodes_Request
     */
    public function setIncludeInactive($includeInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInactive) && !is_bool($includeInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeInactive, true), gettype($includeInactive)), __LINE__);
        }
        $this->IncludeInactive = $includeInactive;
        return $this;
    }
    /**
     * Get PresaleId value
     * @return string|null
     */
    public function getPresaleId()
    {
        return $this->PresaleId;
    }
    /**
     * Set PresaleId value
     * @param string $presaleId
     * @return \patest\StructType\ExportAccessCodes_Request
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        $this->PresaleId = $presaleId;
        return $this;
    }
}
