<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecuteScheduledInstallmentRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExecuteScheduledInstallmentRequest
 * @subpackage Structs
 */
class ExecuteScheduledInstallmentRequest extends AbstractStructBase
{
    /**
     * The InstallmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentId;
    /**
     * Constructor method for ExecuteScheduledInstallmentRequest
     * @uses ExecuteScheduledInstallmentRequest::setInstallmentId()
     * @param string $installmentId
     */
    public function __construct($installmentId = null)
    {
        $this
            ->setInstallmentId($installmentId);
    }
    /**
     * Get InstallmentId value
     * @return string|null
     */
    public function getInstallmentId()
    {
        return $this->InstallmentId;
    }
    /**
     * Set InstallmentId value
     * @param string $installmentId
     * @return \patest\StructType\ExecuteScheduledInstallmentRequest
     */
    public function setInstallmentId($installmentId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentId) && !is_string($installmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentId, true), gettype($installmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentId, true)), __LINE__);
        }
        $this->InstallmentId = $installmentId;
        return $this;
    }
}
