<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeOutEventData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ExchangeOutEventData
 * @subpackage Structs
 */
class ExchangeOutEventData extends AbstractStructBase
{
    /**
     * The ClientTicketsToEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketWithVersionsAndExchangeOutEligibilityState
     */
    public $ClientTicketsToEvent;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Event
     */
    public $Event;
    /**
     * The ExchangePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_EventExchangePolicy
     */
    public $ExchangePolicy;
    /**
     * Constructor method for ExchangeOutEventData
     * @uses ExchangeOutEventData::setClientTicketsToEvent()
     * @uses ExchangeOutEventData::setEvent()
     * @uses ExchangeOutEventData::setExchangePolicy()
     * @param \patest\ArrayType\ArrayOfTicketWithVersionsAndExchangeOutEligibilityState $clientTicketsToEvent
     * @param \patest\StructType\Ticketing_Event $event
     * @param \patest\StructType\Ticketing_EventExchangePolicy $exchangePolicy
     */
    public function __construct(\patest\ArrayType\ArrayOfTicketWithVersionsAndExchangeOutEligibilityState $clientTicketsToEvent = null, \patest\StructType\Ticketing_Event $event = null, \patest\StructType\Ticketing_EventExchangePolicy $exchangePolicy = null)
    {
        $this
            ->setClientTicketsToEvent($clientTicketsToEvent)
            ->setEvent($event)
            ->setExchangePolicy($exchangePolicy);
    }
    /**
     * Get ClientTicketsToEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketWithVersionsAndExchangeOutEligibilityState|null
     */
    public function getClientTicketsToEvent()
    {
        return isset($this->ClientTicketsToEvent) ? $this->ClientTicketsToEvent : null;
    }
    /**
     * Set ClientTicketsToEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketWithVersionsAndExchangeOutEligibilityState $clientTicketsToEvent
     * @return \patest\StructType\ExchangeOutEventData
     */
    public function setClientTicketsToEvent(\patest\ArrayType\ArrayOfTicketWithVersionsAndExchangeOutEligibilityState $clientTicketsToEvent = null)
    {
        if (is_null($clientTicketsToEvent) || (is_array($clientTicketsToEvent) && empty($clientTicketsToEvent))) {
            unset($this->ClientTicketsToEvent);
        } else {
            $this->ClientTicketsToEvent = $clientTicketsToEvent;
        }
        return $this;
    }
    /**
     * Get Event value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Event|null
     */
    public function getEvent()
    {
        return isset($this->Event) ? $this->Event : null;
    }
    /**
     * Set Event value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Event $event
     * @return \patest\StructType\ExchangeOutEventData
     */
    public function setEvent(\patest\StructType\Ticketing_Event $event = null)
    {
        if (is_null($event) || (is_array($event) && empty($event))) {
            unset($this->Event);
        } else {
            $this->Event = $event;
        }
        return $this;
    }
    /**
     * Get ExchangePolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_EventExchangePolicy|null
     */
    public function getExchangePolicy()
    {
        return isset($this->ExchangePolicy) ? $this->ExchangePolicy : null;
    }
    /**
     * Set ExchangePolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_EventExchangePolicy $exchangePolicy
     * @return \patest\StructType\ExchangeOutEventData
     */
    public function setExchangePolicy(\patest\StructType\Ticketing_EventExchangePolicy $exchangePolicy = null)
    {
        if (is_null($exchangePolicy) || (is_array($exchangePolicy) && empty($exchangePolicy))) {
            unset($this->ExchangePolicy);
        } else {
            $this->ExchangePolicy = $exchangePolicy;
        }
        return $this;
    }
}
