<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventTicketsSeatInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventTicketsSeatInfo
 * @subpackage Structs
 */
class EventTicketsSeatInfo extends AbstractStructBase
{
    /**
     * The ClubAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClubAccess;
    /**
     * The CustomProperty1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomProperty1;
    /**
     * The CustomProperty2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomProperty2;
    /**
     * The CustomProperty3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomProperty3;
    /**
     * The CustomProperty4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomProperty4;
    /**
     * The EntryGate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntryGate;
    /**
     * The GateIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GateIds;
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Level;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The RowOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowOrdinal;
    /**
     * The SeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatId;
    /**
     * The SeatOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatOrdinal;
    /**
     * The SeatType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventTicketsSeatType
     */
    public $SeatType;
    /**
     * The SeatTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatTypeId;
    /**
     * The SecondaryClubAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondaryClubAccess;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The SectorOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SectorOrdinal;
    /**
     * The TurnstileIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TurnstileIds;
    /**
     * Constructor method for EventTicketsSeatInfo
     * @uses EventTicketsSeatInfo::setClubAccess()
     * @uses EventTicketsSeatInfo::setCustomProperty1()
     * @uses EventTicketsSeatInfo::setCustomProperty2()
     * @uses EventTicketsSeatInfo::setCustomProperty3()
     * @uses EventTicketsSeatInfo::setCustomProperty4()
     * @uses EventTicketsSeatInfo::setEntryGate()
     * @uses EventTicketsSeatInfo::setGateIds()
     * @uses EventTicketsSeatInfo::setLevel()
     * @uses EventTicketsSeatInfo::setName()
     * @uses EventTicketsSeatInfo::setNotes()
     * @uses EventTicketsSeatInfo::setRowName()
     * @uses EventTicketsSeatInfo::setRowOrdinal()
     * @uses EventTicketsSeatInfo::setSeatId()
     * @uses EventTicketsSeatInfo::setSeatOrdinal()
     * @uses EventTicketsSeatInfo::setSeatType()
     * @uses EventTicketsSeatInfo::setSeatTypeId()
     * @uses EventTicketsSeatInfo::setSecondaryClubAccess()
     * @uses EventTicketsSeatInfo::setSectorId()
     * @uses EventTicketsSeatInfo::setSectorName()
     * @uses EventTicketsSeatInfo::setSectorOrdinal()
     * @uses EventTicketsSeatInfo::setTurnstileIds()
     * @param string $clubAccess
     * @param string $customProperty1
     * @param string $customProperty2
     * @param string $customProperty3
     * @param string $customProperty4
     * @param string $entryGate
     * @param string $gateIds
     * @param string $level
     * @param string $name
     * @param string $notes
     * @param string $rowName
     * @param int $rowOrdinal
     * @param int $seatId
     * @param int $seatOrdinal
     * @param \patest\StructType\EventTicketsSeatType $seatType
     * @param string $seatTypeId
     * @param string $secondaryClubAccess
     * @param string $sectorId
     * @param string $sectorName
     * @param int $sectorOrdinal
     * @param string $turnstileIds
     */
    public function __construct($clubAccess = null, $customProperty1 = null, $customProperty2 = null, $customProperty3 = null, $customProperty4 = null, $entryGate = null, $gateIds = null, $level = null, $name = null, $notes = null, $rowName = null, $rowOrdinal = null, $seatId = null, $seatOrdinal = null, \patest\StructType\EventTicketsSeatType $seatType = null, $seatTypeId = null, $secondaryClubAccess = null, $sectorId = null, $sectorName = null, $sectorOrdinal = null, $turnstileIds = null)
    {
        $this
            ->setClubAccess($clubAccess)
            ->setCustomProperty1($customProperty1)
            ->setCustomProperty2($customProperty2)
            ->setCustomProperty3($customProperty3)
            ->setCustomProperty4($customProperty4)
            ->setEntryGate($entryGate)
            ->setGateIds($gateIds)
            ->setLevel($level)
            ->setName($name)
            ->setNotes($notes)
            ->setRowName($rowName)
            ->setRowOrdinal($rowOrdinal)
            ->setSeatId($seatId)
            ->setSeatOrdinal($seatOrdinal)
            ->setSeatType($seatType)
            ->setSeatTypeId($seatTypeId)
            ->setSecondaryClubAccess($secondaryClubAccess)
            ->setSectorId($sectorId)
            ->setSectorName($sectorName)
            ->setSectorOrdinal($sectorOrdinal)
            ->setTurnstileIds($turnstileIds);
    }
    /**
     * Get ClubAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClubAccess()
    {
        return isset($this->ClubAccess) ? $this->ClubAccess : null;
    }
    /**
     * Set ClubAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clubAccess
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setClubAccess($clubAccess = null)
    {
        // validation for constraint: string
        if (!is_null($clubAccess) && !is_string($clubAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clubAccess, true), gettype($clubAccess)), __LINE__);
        }
        if (is_null($clubAccess) || (is_array($clubAccess) && empty($clubAccess))) {
            unset($this->ClubAccess);
        } else {
            $this->ClubAccess = $clubAccess;
        }
        return $this;
    }
    /**
     * Get CustomProperty1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomProperty1()
    {
        return isset($this->CustomProperty1) ? $this->CustomProperty1 : null;
    }
    /**
     * Set CustomProperty1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customProperty1
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setCustomProperty1($customProperty1 = null)
    {
        // validation for constraint: string
        if (!is_null($customProperty1) && !is_string($customProperty1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customProperty1, true), gettype($customProperty1)), __LINE__);
        }
        if (is_null($customProperty1) || (is_array($customProperty1) && empty($customProperty1))) {
            unset($this->CustomProperty1);
        } else {
            $this->CustomProperty1 = $customProperty1;
        }
        return $this;
    }
    /**
     * Get CustomProperty2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomProperty2()
    {
        return isset($this->CustomProperty2) ? $this->CustomProperty2 : null;
    }
    /**
     * Set CustomProperty2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customProperty2
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setCustomProperty2($customProperty2 = null)
    {
        // validation for constraint: string
        if (!is_null($customProperty2) && !is_string($customProperty2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customProperty2, true), gettype($customProperty2)), __LINE__);
        }
        if (is_null($customProperty2) || (is_array($customProperty2) && empty($customProperty2))) {
            unset($this->CustomProperty2);
        } else {
            $this->CustomProperty2 = $customProperty2;
        }
        return $this;
    }
    /**
     * Get CustomProperty3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomProperty3()
    {
        return isset($this->CustomProperty3) ? $this->CustomProperty3 : null;
    }
    /**
     * Set CustomProperty3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customProperty3
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setCustomProperty3($customProperty3 = null)
    {
        // validation for constraint: string
        if (!is_null($customProperty3) && !is_string($customProperty3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customProperty3, true), gettype($customProperty3)), __LINE__);
        }
        if (is_null($customProperty3) || (is_array($customProperty3) && empty($customProperty3))) {
            unset($this->CustomProperty3);
        } else {
            $this->CustomProperty3 = $customProperty3;
        }
        return $this;
    }
    /**
     * Get CustomProperty4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomProperty4()
    {
        return isset($this->CustomProperty4) ? $this->CustomProperty4 : null;
    }
    /**
     * Set CustomProperty4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customProperty4
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setCustomProperty4($customProperty4 = null)
    {
        // validation for constraint: string
        if (!is_null($customProperty4) && !is_string($customProperty4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customProperty4, true), gettype($customProperty4)), __LINE__);
        }
        if (is_null($customProperty4) || (is_array($customProperty4) && empty($customProperty4))) {
            unset($this->CustomProperty4);
        } else {
            $this->CustomProperty4 = $customProperty4;
        }
        return $this;
    }
    /**
     * Get EntryGate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntryGate()
    {
        return isset($this->EntryGate) ? $this->EntryGate : null;
    }
    /**
     * Set EntryGate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entryGate
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setEntryGate($entryGate = null)
    {
        // validation for constraint: string
        if (!is_null($entryGate) && !is_string($entryGate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryGate, true), gettype($entryGate)), __LINE__);
        }
        if (is_null($entryGate) || (is_array($entryGate) && empty($entryGate))) {
            unset($this->EntryGate);
        } else {
            $this->EntryGate = $entryGate;
        }
        return $this;
    }
    /**
     * Get GateIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGateIds()
    {
        return isset($this->GateIds) ? $this->GateIds : null;
    }
    /**
     * Set GateIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gateIds
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setGateIds($gateIds = null)
    {
        // validation for constraint: string
        if (!is_null($gateIds) && !is_string($gateIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gateIds, true), gettype($gateIds)), __LINE__);
        }
        if (is_null($gateIds) || (is_array($gateIds) && empty($gateIds))) {
            unset($this->GateIds);
        } else {
            $this->GateIds = $gateIds;
        }
        return $this;
    }
    /**
     * Get Level value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLevel()
    {
        return isset($this->Level) ? $this->Level : null;
    }
    /**
     * Set Level value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $level
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setLevel($level = null)
    {
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        if (is_null($level) || (is_array($level) && empty($level))) {
            unset($this->Level);
        } else {
            $this->Level = $level;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get RowOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowOrdinal()
    {
        return isset($this->RowOrdinal) ? $this->RowOrdinal : null;
    }
    /**
     * Set RowOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowOrdinal
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setRowOrdinal($rowOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($rowOrdinal) && !(is_int($rowOrdinal) || ctype_digit($rowOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowOrdinal, true), gettype($rowOrdinal)), __LINE__);
        }
        if (is_null($rowOrdinal) || (is_array($rowOrdinal) && empty($rowOrdinal))) {
            unset($this->RowOrdinal);
        } else {
            $this->RowOrdinal = $rowOrdinal;
        }
        return $this;
    }
    /**
     * Get SeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatId()
    {
        return isset($this->SeatId) ? $this->SeatId : null;
    }
    /**
     * Set SeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatId
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setSeatId($seatId = null)
    {
        // validation for constraint: int
        if (!is_null($seatId) && !(is_int($seatId) || ctype_digit($seatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatId, true), gettype($seatId)), __LINE__);
        }
        if (is_null($seatId) || (is_array($seatId) && empty($seatId))) {
            unset($this->SeatId);
        } else {
            $this->SeatId = $seatId;
        }
        return $this;
    }
    /**
     * Get SeatOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatOrdinal()
    {
        return isset($this->SeatOrdinal) ? $this->SeatOrdinal : null;
    }
    /**
     * Set SeatOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatOrdinal
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setSeatOrdinal($seatOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($seatOrdinal) && !(is_int($seatOrdinal) || ctype_digit($seatOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatOrdinal, true), gettype($seatOrdinal)), __LINE__);
        }
        if (is_null($seatOrdinal) || (is_array($seatOrdinal) && empty($seatOrdinal))) {
            unset($this->SeatOrdinal);
        } else {
            $this->SeatOrdinal = $seatOrdinal;
        }
        return $this;
    }
    /**
     * Get SeatType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventTicketsSeatType|null
     */
    public function getSeatType()
    {
        return isset($this->SeatType) ? $this->SeatType : null;
    }
    /**
     * Set SeatType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventTicketsSeatType $seatType
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setSeatType(\patest\StructType\EventTicketsSeatType $seatType = null)
    {
        if (is_null($seatType) || (is_array($seatType) && empty($seatType))) {
            unset($this->SeatType);
        } else {
            $this->SeatType = $seatType;
        }
        return $this;
    }
    /**
     * Get SeatTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeId()
    {
        return isset($this->SeatTypeId) ? $this->SeatTypeId : null;
    }
    /**
     * Set SeatTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeId
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setSeatTypeId($seatTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeId) && !is_string($seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeId, true), gettype($seatTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatTypeId, true)), __LINE__);
        }
        if (is_null($seatTypeId) || (is_array($seatTypeId) && empty($seatTypeId))) {
            unset($this->SeatTypeId);
        } else {
            $this->SeatTypeId = $seatTypeId;
        }
        return $this;
    }
    /**
     * Get SecondaryClubAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondaryClubAccess()
    {
        return isset($this->SecondaryClubAccess) ? $this->SecondaryClubAccess : null;
    }
    /**
     * Set SecondaryClubAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondaryClubAccess
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setSecondaryClubAccess($secondaryClubAccess = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryClubAccess) && !is_string($secondaryClubAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryClubAccess, true), gettype($secondaryClubAccess)), __LINE__);
        }
        if (is_null($secondaryClubAccess) || (is_array($secondaryClubAccess) && empty($secondaryClubAccess))) {
            unset($this->SecondaryClubAccess);
        } else {
            $this->SecondaryClubAccess = $secondaryClubAccess;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SectorOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSectorOrdinal()
    {
        return isset($this->SectorOrdinal) ? $this->SectorOrdinal : null;
    }
    /**
     * Set SectorOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sectorOrdinal
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setSectorOrdinal($sectorOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($sectorOrdinal) && !(is_int($sectorOrdinal) || ctype_digit($sectorOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sectorOrdinal, true), gettype($sectorOrdinal)), __LINE__);
        }
        if (is_null($sectorOrdinal) || (is_array($sectorOrdinal) && empty($sectorOrdinal))) {
            unset($this->SectorOrdinal);
        } else {
            $this->SectorOrdinal = $sectorOrdinal;
        }
        return $this;
    }
    /**
     * Get TurnstileIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstileIds()
    {
        return isset($this->TurnstileIds) ? $this->TurnstileIds : null;
    }
    /**
     * Set TurnstileIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstileIds
     * @return \patest\StructType\EventTicketsSeatInfo
     */
    public function setTurnstileIds($turnstileIds = null)
    {
        // validation for constraint: string
        if (!is_null($turnstileIds) && !is_string($turnstileIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstileIds, true), gettype($turnstileIds)), __LINE__);
        }
        if (is_null($turnstileIds) || (is_array($turnstileIds) && empty($turnstileIds))) {
            unset($this->TurnstileIds);
        } else {
            $this->TurnstileIds = $turnstileIds;
        }
        return $this;
    }
}
