<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventHeaderOverrideRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventHeaderOverrideRequest
 * @subpackage Structs
 */
class EventHeaderOverrideRequest extends AbstractStructBase
{
    /**
     * The AllLabelsOpaque
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllLabelsOpaque;
    /**
     * The CompactImageGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CompactImageGuid;
    /**
     * The EventHeaderTitleOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventHeaderTitleOverride;
    /**
     * The EventListTitleOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventListTitleOverride;
    /**
     * The FlattenedImageGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FlattenedImageGuid;
    /**
     * Constructor method for EventHeaderOverrideRequest
     * @uses EventHeaderOverrideRequest::setAllLabelsOpaque()
     * @uses EventHeaderOverrideRequest::setCompactImageGuid()
     * @uses EventHeaderOverrideRequest::setEventHeaderTitleOverride()
     * @uses EventHeaderOverrideRequest::setEventListTitleOverride()
     * @uses EventHeaderOverrideRequest::setFlattenedImageGuid()
     * @param bool $allLabelsOpaque
     * @param string $compactImageGuid
     * @param string $eventHeaderTitleOverride
     * @param string $eventListTitleOverride
     * @param string $flattenedImageGuid
     */
    public function __construct($allLabelsOpaque = null, $compactImageGuid = null, $eventHeaderTitleOverride = null, $eventListTitleOverride = null, $flattenedImageGuid = null)
    {
        $this
            ->setAllLabelsOpaque($allLabelsOpaque)
            ->setCompactImageGuid($compactImageGuid)
            ->setEventHeaderTitleOverride($eventHeaderTitleOverride)
            ->setEventListTitleOverride($eventListTitleOverride)
            ->setFlattenedImageGuid($flattenedImageGuid);
    }
    /**
     * Get AllLabelsOpaque value
     * @return bool|null
     */
    public function getAllLabelsOpaque()
    {
        return $this->AllLabelsOpaque;
    }
    /**
     * Set AllLabelsOpaque value
     * @param bool $allLabelsOpaque
     * @return \patest\StructType\EventHeaderOverrideRequest
     */
    public function setAllLabelsOpaque($allLabelsOpaque = null)
    {
        // validation for constraint: boolean
        if (!is_null($allLabelsOpaque) && !is_bool($allLabelsOpaque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allLabelsOpaque, true), gettype($allLabelsOpaque)), __LINE__);
        }
        $this->AllLabelsOpaque = $allLabelsOpaque;
        return $this;
    }
    /**
     * Get CompactImageGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompactImageGuid()
    {
        return isset($this->CompactImageGuid) ? $this->CompactImageGuid : null;
    }
    /**
     * Set CompactImageGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $compactImageGuid
     * @return \patest\StructType\EventHeaderOverrideRequest
     */
    public function setCompactImageGuid($compactImageGuid = null)
    {
        // validation for constraint: string
        if (!is_null($compactImageGuid) && !is_string($compactImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compactImageGuid, true), gettype($compactImageGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($compactImageGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $compactImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($compactImageGuid, true)), __LINE__);
        }
        if (is_null($compactImageGuid) || (is_array($compactImageGuid) && empty($compactImageGuid))) {
            unset($this->CompactImageGuid);
        } else {
            $this->CompactImageGuid = $compactImageGuid;
        }
        return $this;
    }
    /**
     * Get EventHeaderTitleOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventHeaderTitleOverride()
    {
        return isset($this->EventHeaderTitleOverride) ? $this->EventHeaderTitleOverride : null;
    }
    /**
     * Set EventHeaderTitleOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventHeaderTitleOverride
     * @return \patest\StructType\EventHeaderOverrideRequest
     */
    public function setEventHeaderTitleOverride($eventHeaderTitleOverride = null)
    {
        // validation for constraint: string
        if (!is_null($eventHeaderTitleOverride) && !is_string($eventHeaderTitleOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventHeaderTitleOverride, true), gettype($eventHeaderTitleOverride)), __LINE__);
        }
        if (is_null($eventHeaderTitleOverride) || (is_array($eventHeaderTitleOverride) && empty($eventHeaderTitleOverride))) {
            unset($this->EventHeaderTitleOverride);
        } else {
            $this->EventHeaderTitleOverride = $eventHeaderTitleOverride;
        }
        return $this;
    }
    /**
     * Get EventListTitleOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventListTitleOverride()
    {
        return isset($this->EventListTitleOverride) ? $this->EventListTitleOverride : null;
    }
    /**
     * Set EventListTitleOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventListTitleOverride
     * @return \patest\StructType\EventHeaderOverrideRequest
     */
    public function setEventListTitleOverride($eventListTitleOverride = null)
    {
        // validation for constraint: string
        if (!is_null($eventListTitleOverride) && !is_string($eventListTitleOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventListTitleOverride, true), gettype($eventListTitleOverride)), __LINE__);
        }
        if (is_null($eventListTitleOverride) || (is_array($eventListTitleOverride) && empty($eventListTitleOverride))) {
            unset($this->EventListTitleOverride);
        } else {
            $this->EventListTitleOverride = $eventListTitleOverride;
        }
        return $this;
    }
    /**
     * Get FlattenedImageGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlattenedImageGuid()
    {
        return isset($this->FlattenedImageGuid) ? $this->FlattenedImageGuid : null;
    }
    /**
     * Set FlattenedImageGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flattenedImageGuid
     * @return \patest\StructType\EventHeaderOverrideRequest
     */
    public function setFlattenedImageGuid($flattenedImageGuid = null)
    {
        // validation for constraint: string
        if (!is_null($flattenedImageGuid) && !is_string($flattenedImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flattenedImageGuid, true), gettype($flattenedImageGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($flattenedImageGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $flattenedImageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($flattenedImageGuid, true)), __LINE__);
        }
        if (is_null($flattenedImageGuid) || (is_array($flattenedImageGuid) && empty($flattenedImageGuid))) {
            unset($this->FlattenedImageGuid);
        } else {
            $this->FlattenedImageGuid = $flattenedImageGuid;
        }
        return $this;
    }
}
