<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventDescription
 * @subpackage Structs
 */
class EventDescription extends AbstractStructBase
{
    /**
     * The DescriptionLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DescriptionLevel;
    /**
     * The DescriptionText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DescriptionText;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EventLocalId;
    /**
     * The ExtraProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ExtraProperties;
    /**
     * The Hall
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\HallVersionDesign
     */
    public $Hall;
    /**
     * The IssuerCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IssuerCompanyId;
    /**
     * The OnlineDateFormatAdditionalText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OnlineDateFormatAdditionalText;
    /**
     * The Pricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventPricingDescription
     */
    public $Pricing;
    /**
     * The SaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $SaleStatus;
    /**
     * The Show
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowDescription
     */
    public $Show;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The SoldOut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SoldOut;
    /**
     * The VenueName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VenueName;
    /**
     * The TimeZoneId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZoneId;
    /**
     * The AvailableForDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableForDisplay;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The IsFutureSaleForDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFutureSaleForDisplay;
    /**
     * The IsAvailableForSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvailableForSale;
    /**
     * The StartSaleFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartSaleFrom;
    /**
     * The EndSaleAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndSaleAt;
    /**
     * The EventSaleFlowMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventSaleFlowMode;
    /**
     * The LastUpdate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdate;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ShowTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowTypeId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SmallImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SmallImageUrl;
    /**
     * The LargeImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LargeImageUrl;
    /**
     * The ReviewUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReviewUrl;
    /**
     * The BriefText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BriefText;
    /**
     * The DetailedText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DetailedText;
    /**
     * The ShowMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShowMinutes;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The FormattedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedDate;
    /**
     * The AvailableSeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AvailableSeatCount;
    /**
     * The IsAvailableAsBonusForSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableAsBonusForSeries;
    /**
     * The IsAvailableAsRegularForSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAvailableAsRegularForSeries;
    /**
     * The RequestType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestType;
    /**
     * The AllowedBookingRequestTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AllowedBookingRequestTypes;
    /**
     * The MediumImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MediumImageUrl;
    /**
     * The EventTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfEventTagDescription
     */
    public $EventTags;
    /**
     * The OccupancyStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OccupancyStatus;
    /**
     * The SocialNetworkImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SocialNetworkImageUrl;
    /**
     * The AvailableHospitalityCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailableHospitalityCapacity;
    /**
     * The HospitalityOccupancyStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HospitalityOccupancyStatus;
    /**
     * The IsHospitalityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsHospitalityAvailable;
    /**
     * The TotalHospitalityCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalHospitalityCapacity;
    /**
     * The MasterHospitalityEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MasterHospitalityEventId;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The PerformerIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PerformerIds;
    /**
     * The TaxonomyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TaxonomyId;
    /**
     * The Performers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfEventPerformerDescription
     */
    public $Performers;
    /**
     * The TaxonomyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxonomyName;
    /**
     * The OnlineTicketsLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OnlineTicketsLimit;
    /**
     * The DateFormatOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateFormatOptions;
    /**
     * The PotentialPriceList
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PotentialPriceList;
    /**
     * The EventAddOnType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventAddOnType;
    /**
     * The EventUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventUrl;
    /**
     * The OnlineThumbnailImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineThumbnailImageUrl;
    /**
     * The LimitationRuleInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfRuleDescription
     */
    public $LimitationRuleInfo;
    /**
     * The OnlineHeroImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineHeroImageUrl;
    /**
     * Constructor method for EventDescription
     * @uses EventDescription::setDescriptionLevel()
     * @uses EventDescription::setDescriptionText()
     * @uses EventDescription::setEventDate()
     * @uses EventDescription::setEventId()
     * @uses EventDescription::setEventLocalId()
     * @uses EventDescription::setExtraProperties()
     * @uses EventDescription::setHall()
     * @uses EventDescription::setIssuerCompanyId()
     * @uses EventDescription::setOnlineDateFormatAdditionalText()
     * @uses EventDescription::setPricing()
     * @uses EventDescription::setSaleStatus()
     * @uses EventDescription::setShow()
     * @uses EventDescription::setHallName()
     * @uses EventDescription::setSoldOut()
     * @uses EventDescription::setVenueName()
     * @uses EventDescription::setTimeZoneId()
     * @uses EventDescription::setAvailableForDisplay()
     * @uses EventDescription::setOwnerId()
     * @uses EventDescription::setIsFutureSaleForDisplay()
     * @uses EventDescription::setIsAvailableForSale()
     * @uses EventDescription::setStartSaleFrom()
     * @uses EventDescription::setEndSaleAt()
     * @uses EventDescription::setEventSaleFlowMode()
     * @uses EventDescription::setLastUpdate()
     * @uses EventDescription::setShowId()
     * @uses EventDescription::setShowTypeId()
     * @uses EventDescription::setName()
     * @uses EventDescription::setSmallImageUrl()
     * @uses EventDescription::setLargeImageUrl()
     * @uses EventDescription::setReviewUrl()
     * @uses EventDescription::setBriefText()
     * @uses EventDescription::setDetailedText()
     * @uses EventDescription::setShowMinutes()
     * @uses EventDescription::setExternalReference()
     * @uses EventDescription::setOwnerName()
     * @uses EventDescription::setMessage()
     * @uses EventDescription::setNotes()
     * @uses EventDescription::setFormattedDate()
     * @uses EventDescription::setAvailableSeatCount()
     * @uses EventDescription::setIsAvailableAsBonusForSeries()
     * @uses EventDescription::setIsAvailableAsRegularForSeries()
     * @uses EventDescription::setRequestType()
     * @uses EventDescription::setAllowedBookingRequestTypes()
     * @uses EventDescription::setMediumImageUrl()
     * @uses EventDescription::setEventTags()
     * @uses EventDescription::setOccupancyStatus()
     * @uses EventDescription::setSocialNetworkImageUrl()
     * @uses EventDescription::setAvailableHospitalityCapacity()
     * @uses EventDescription::setHospitalityOccupancyStatus()
     * @uses EventDescription::setIsHospitalityAvailable()
     * @uses EventDescription::setTotalHospitalityCapacity()
     * @uses EventDescription::setMasterHospitalityEventId()
     * @uses EventDescription::setAreaId()
     * @uses EventDescription::setDisplayName()
     * @uses EventDescription::setPerformerIds()
     * @uses EventDescription::setTaxonomyId()
     * @uses EventDescription::setPerformers()
     * @uses EventDescription::setTaxonomyName()
     * @uses EventDescription::setOnlineTicketsLimit()
     * @uses EventDescription::setDateFormatOptions()
     * @uses EventDescription::setPotentialPriceList()
     * @uses EventDescription::setEventAddOnType()
     * @uses EventDescription::setEventUrl()
     * @uses EventDescription::setOnlineThumbnailImageUrl()
     * @uses EventDescription::setLimitationRuleInfo()
     * @uses EventDescription::setOnlineHeroImageUrl()
     * @param string $descriptionLevel
     * @param string $descriptionText
     * @param string $eventDate
     * @param string $eventId
     * @param int $eventLocalId
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraProperties
     * @param \patest\StructType\HallVersionDesign $hall
     * @param int $issuerCompanyId
     * @param \patest\StructType\GlobalString $onlineDateFormatAdditionalText
     * @param \patest\StructType\EventPricingDescription $pricing
     * @param string[] $saleStatus
     * @param \patest\StructType\ShowDescription $show
     * @param string $hallName
     * @param bool $soldOut
     * @param string $venueName
     * @param string $timeZoneId
     * @param bool $availableForDisplay
     * @param string $ownerId
     * @param bool $isFutureSaleForDisplay
     * @param bool $isAvailableForSale
     * @param string $startSaleFrom
     * @param string $endSaleAt
     * @param string $eventSaleFlowMode
     * @param string $lastUpdate
     * @param string $showId
     * @param string $showTypeId
     * @param string $name
     * @param string $smallImageUrl
     * @param string $largeImageUrl
     * @param string $reviewUrl
     * @param string $briefText
     * @param string $detailedText
     * @param int $showMinutes
     * @param string $externalReference
     * @param string $ownerName
     * @param string $message
     * @param string $notes
     * @param string $formattedDate
     * @param int $availableSeatCount
     * @param bool $isAvailableAsBonusForSeries
     * @param bool $isAvailableAsRegularForSeries
     * @param string $requestType
     * @param \patest\ArrayType\ArrayOfguid $allowedBookingRequestTypes
     * @param string $mediumImageUrl
     * @param \patest\ArrayType\ArrayOfEventTagDescription $eventTags
     * @param string $occupancyStatus
     * @param string $socialNetworkImageUrl
     * @param int $availableHospitalityCapacity
     * @param string $hospitalityOccupancyStatus
     * @param bool $isHospitalityAvailable
     * @param int $totalHospitalityCapacity
     * @param string $masterHospitalityEventId
     * @param string $areaId
     * @param string $displayName
     * @param string $performerIds
     * @param int $taxonomyId
     * @param \patest\ArrayType\ArrayOfEventPerformerDescription $performers
     * @param string $taxonomyName
     * @param int $onlineTicketsLimit
     * @param string $dateFormatOptions
     * @param string $potentialPriceList
     * @param string $eventAddOnType
     * @param string $eventUrl
     * @param string $onlineThumbnailImageUrl
     * @param \patest\ArrayType\ArrayOfRuleDescription $limitationRuleInfo
     * @param string $onlineHeroImageUrl
     */
    public function __construct($descriptionLevel = null, $descriptionText = null, $eventDate = null, $eventId = null, $eventLocalId = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraProperties = null, \patest\StructType\HallVersionDesign $hall = null, $issuerCompanyId = null, \patest\StructType\GlobalString $onlineDateFormatAdditionalText = null, \patest\StructType\EventPricingDescription $pricing = null, array $saleStatus = array(), \patest\StructType\ShowDescription $show = null, $hallName = null, $soldOut = null, $venueName = null, $timeZoneId = null, $availableForDisplay = null, $ownerId = null, $isFutureSaleForDisplay = null, $isAvailableForSale = null, $startSaleFrom = null, $endSaleAt = null, $eventSaleFlowMode = null, $lastUpdate = null, $showId = null, $showTypeId = null, $name = null, $smallImageUrl = null, $largeImageUrl = null, $reviewUrl = null, $briefText = null, $detailedText = null, $showMinutes = null, $externalReference = null, $ownerName = null, $message = null, $notes = null, $formattedDate = null, $availableSeatCount = null, $isAvailableAsBonusForSeries = null, $isAvailableAsRegularForSeries = null, $requestType = null, \patest\ArrayType\ArrayOfguid $allowedBookingRequestTypes = null, $mediumImageUrl = null, \patest\ArrayType\ArrayOfEventTagDescription $eventTags = null, $occupancyStatus = null, $socialNetworkImageUrl = null, $availableHospitalityCapacity = null, $hospitalityOccupancyStatus = null, $isHospitalityAvailable = null, $totalHospitalityCapacity = null, $masterHospitalityEventId = null, $areaId = null, $displayName = null, $performerIds = null, $taxonomyId = null, \patest\ArrayType\ArrayOfEventPerformerDescription $performers = null, $taxonomyName = null, $onlineTicketsLimit = null, $dateFormatOptions = null, $potentialPriceList = null, $eventAddOnType = null, $eventUrl = null, $onlineThumbnailImageUrl = null, \patest\ArrayType\ArrayOfRuleDescription $limitationRuleInfo = null, $onlineHeroImageUrl = null)
    {
        $this
            ->setDescriptionLevel($descriptionLevel)
            ->setDescriptionText($descriptionText)
            ->setEventDate($eventDate)
            ->setEventId($eventId)
            ->setEventLocalId($eventLocalId)
            ->setExtraProperties($extraProperties)
            ->setHall($hall)
            ->setIssuerCompanyId($issuerCompanyId)
            ->setOnlineDateFormatAdditionalText($onlineDateFormatAdditionalText)
            ->setPricing($pricing)
            ->setSaleStatus($saleStatus)
            ->setShow($show)
            ->setHallName($hallName)
            ->setSoldOut($soldOut)
            ->setVenueName($venueName)
            ->setTimeZoneId($timeZoneId)
            ->setAvailableForDisplay($availableForDisplay)
            ->setOwnerId($ownerId)
            ->setIsFutureSaleForDisplay($isFutureSaleForDisplay)
            ->setIsAvailableForSale($isAvailableForSale)
            ->setStartSaleFrom($startSaleFrom)
            ->setEndSaleAt($endSaleAt)
            ->setEventSaleFlowMode($eventSaleFlowMode)
            ->setLastUpdate($lastUpdate)
            ->setShowId($showId)
            ->setShowTypeId($showTypeId)
            ->setName($name)
            ->setSmallImageUrl($smallImageUrl)
            ->setLargeImageUrl($largeImageUrl)
            ->setReviewUrl($reviewUrl)
            ->setBriefText($briefText)
            ->setDetailedText($detailedText)
            ->setShowMinutes($showMinutes)
            ->setExternalReference($externalReference)
            ->setOwnerName($ownerName)
            ->setMessage($message)
            ->setNotes($notes)
            ->setFormattedDate($formattedDate)
            ->setAvailableSeatCount($availableSeatCount)
            ->setIsAvailableAsBonusForSeries($isAvailableAsBonusForSeries)
            ->setIsAvailableAsRegularForSeries($isAvailableAsRegularForSeries)
            ->setRequestType($requestType)
            ->setAllowedBookingRequestTypes($allowedBookingRequestTypes)
            ->setMediumImageUrl($mediumImageUrl)
            ->setEventTags($eventTags)
            ->setOccupancyStatus($occupancyStatus)
            ->setSocialNetworkImageUrl($socialNetworkImageUrl)
            ->setAvailableHospitalityCapacity($availableHospitalityCapacity)
            ->setHospitalityOccupancyStatus($hospitalityOccupancyStatus)
            ->setIsHospitalityAvailable($isHospitalityAvailable)
            ->setTotalHospitalityCapacity($totalHospitalityCapacity)
            ->setMasterHospitalityEventId($masterHospitalityEventId)
            ->setAreaId($areaId)
            ->setDisplayName($displayName)
            ->setPerformerIds($performerIds)
            ->setTaxonomyId($taxonomyId)
            ->setPerformers($performers)
            ->setTaxonomyName($taxonomyName)
            ->setOnlineTicketsLimit($onlineTicketsLimit)
            ->setDateFormatOptions($dateFormatOptions)
            ->setPotentialPriceList($potentialPriceList)
            ->setEventAddOnType($eventAddOnType)
            ->setEventUrl($eventUrl)
            ->setOnlineThumbnailImageUrl($onlineThumbnailImageUrl)
            ->setLimitationRuleInfo($limitationRuleInfo)
            ->setOnlineHeroImageUrl($onlineHeroImageUrl);
    }
    /**
     * Get DescriptionLevel value
     * @return string|null
     */
    public function getDescriptionLevel()
    {
        return $this->DescriptionLevel;
    }
    /**
     * Set DescriptionLevel value
     * @uses \patest\EnumType\DescriptionLevel::valueIsValid()
     * @uses \patest\EnumType\DescriptionLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $descriptionLevel
     * @return \patest\StructType\EventDescription
     */
    public function setDescriptionLevel($descriptionLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DescriptionLevel::valueIsValid($descriptionLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DescriptionLevel', is_array($descriptionLevel) ? implode(', ', $descriptionLevel) : var_export($descriptionLevel, true), implode(', ', \patest\EnumType\DescriptionLevel::getValidValues())), __LINE__);
        }
        $this->DescriptionLevel = $descriptionLevel;
        return $this;
    }
    /**
     * Get DescriptionText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescriptionText()
    {
        return isset($this->DescriptionText) ? $this->DescriptionText : null;
    }
    /**
     * Set DescriptionText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descriptionText
     * @return \patest\StructType\EventDescription
     */
    public function setDescriptionText($descriptionText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionText) && !is_string($descriptionText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionText, true), gettype($descriptionText)), __LINE__);
        }
        if (is_null($descriptionText) || (is_array($descriptionText) && empty($descriptionText))) {
            unset($this->DescriptionText);
        } else {
            $this->DescriptionText = $descriptionText;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * @return string|null
     */
    public function getEventDate()
    {
        return $this->EventDate;
    }
    /**
     * Set EventDate value
     * @param string $eventDate
     * @return \patest\StructType\EventDescription
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        $this->EventDate = $eventDate;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\EventDescription
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventLocalId value
     * @return int|null
     */
    public function getEventLocalId()
    {
        return $this->EventLocalId;
    }
    /**
     * Set EventLocalId value
     * @param int $eventLocalId
     * @return \patest\StructType\EventDescription
     */
    public function setEventLocalId($eventLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($eventLocalId) && !(is_int($eventLocalId) || ctype_digit($eventLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventLocalId, true), gettype($eventLocalId)), __LINE__);
        }
        $this->EventLocalId = $eventLocalId;
        return $this;
    }
    /**
     * Get ExtraProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getExtraProperties()
    {
        return isset($this->ExtraProperties) ? $this->ExtraProperties : null;
    }
    /**
     * Set ExtraProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraProperties
     * @return \patest\StructType\EventDescription
     */
    public function setExtraProperties(\patest\ArrayType\ArrayOfKeyValueOfstringstring $extraProperties = null)
    {
        if (is_null($extraProperties) || (is_array($extraProperties) && empty($extraProperties))) {
            unset($this->ExtraProperties);
        } else {
            $this->ExtraProperties = $extraProperties;
        }
        return $this;
    }
    /**
     * Get Hall value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\HallVersionDesign|null
     */
    public function getHall()
    {
        return isset($this->Hall) ? $this->Hall : null;
    }
    /**
     * Set Hall value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\HallVersionDesign $hall
     * @return \patest\StructType\EventDescription
     */
    public function setHall(\patest\StructType\HallVersionDesign $hall = null)
    {
        if (is_null($hall) || (is_array($hall) && empty($hall))) {
            unset($this->Hall);
        } else {
            $this->Hall = $hall;
        }
        return $this;
    }
    /**
     * Get IssuerCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIssuerCompanyId()
    {
        return isset($this->IssuerCompanyId) ? $this->IssuerCompanyId : null;
    }
    /**
     * Set IssuerCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $issuerCompanyId
     * @return \patest\StructType\EventDescription
     */
    public function setIssuerCompanyId($issuerCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($issuerCompanyId) && !(is_int($issuerCompanyId) || ctype_digit($issuerCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($issuerCompanyId, true), gettype($issuerCompanyId)), __LINE__);
        }
        if (is_null($issuerCompanyId) || (is_array($issuerCompanyId) && empty($issuerCompanyId))) {
            unset($this->IssuerCompanyId);
        } else {
            $this->IssuerCompanyId = $issuerCompanyId;
        }
        return $this;
    }
    /**
     * Get OnlineDateFormatAdditionalText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOnlineDateFormatAdditionalText()
    {
        return isset($this->OnlineDateFormatAdditionalText) ? $this->OnlineDateFormatAdditionalText : null;
    }
    /**
     * Set OnlineDateFormatAdditionalText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $onlineDateFormatAdditionalText
     * @return \patest\StructType\EventDescription
     */
    public function setOnlineDateFormatAdditionalText(\patest\StructType\GlobalString $onlineDateFormatAdditionalText = null)
    {
        if (is_null($onlineDateFormatAdditionalText) || (is_array($onlineDateFormatAdditionalText) && empty($onlineDateFormatAdditionalText))) {
            unset($this->OnlineDateFormatAdditionalText);
        } else {
            $this->OnlineDateFormatAdditionalText = $onlineDateFormatAdditionalText;
        }
        return $this;
    }
    /**
     * Get Pricing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventPricingDescription|null
     */
    public function getPricing()
    {
        return isset($this->Pricing) ? $this->Pricing : null;
    }
    /**
     * Set Pricing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventPricingDescription $pricing
     * @return \patest\StructType\EventDescription
     */
    public function setPricing(\patest\StructType\EventPricingDescription $pricing = null)
    {
        if (is_null($pricing) || (is_array($pricing) && empty($pricing))) {
            unset($this->Pricing);
        } else {
            $this->Pricing = $pricing;
        }
        return $this;
    }
    /**
     * Get SaleStatus value
     * @return string[]|null
     */
    public function getSaleStatus()
    {
        return $this->SaleStatus;
    }
    /**
     * This method is responsible for validating the values passed to the setSaleStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaleStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaleStatusForArrayConstraintsFromSetSaleStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventDescriptionSaleStatusItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EventSaleStatus::valueIsValid($eventDescriptionSaleStatusItem)) {
                $invalidValues[] = is_object($eventDescriptionSaleStatusItem) ? get_class($eventDescriptionSaleStatusItem) : sprintf('%s(%s)', gettype($eventDescriptionSaleStatusItem), var_export($eventDescriptionSaleStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EventSaleStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SaleStatus value
     * @uses \patest\EnumType\EventSaleStatus::valueIsValid()
     * @uses \patest\EnumType\EventSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $saleStatus
     * @return \patest\StructType\EventDescription
     */
    public function setSaleStatus(array $saleStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($saleStatusArrayErrorMessage = self::validateSaleStatusForArrayConstraintsFromSetSaleStatus($saleStatus))) {
            throw new \InvalidArgumentException($saleStatusArrayErrorMessage, __LINE__);
        }
        $this->SaleStatus = is_array($saleStatus) ? implode(' ', $saleStatus) : null;
        return $this;
    }
    /**
     * Get Show value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowDescription|null
     */
    public function getShow()
    {
        return isset($this->Show) ? $this->Show : null;
    }
    /**
     * Set Show value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ShowDescription $show
     * @return \patest\StructType\EventDescription
     */
    public function setShow(\patest\StructType\ShowDescription $show = null)
    {
        if (is_null($show) || (is_array($show) && empty($show))) {
            unset($this->Show);
        } else {
            $this->Show = $show;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\EventDescription
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get SoldOut value
     * @return bool|null
     */
    public function getSoldOut()
    {
        return $this->SoldOut;
    }
    /**
     * Set SoldOut value
     * @param bool $soldOut
     * @return \patest\StructType\EventDescription
     */
    public function setSoldOut($soldOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($soldOut) && !is_bool($soldOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($soldOut, true), gettype($soldOut)), __LINE__);
        }
        $this->SoldOut = $soldOut;
        return $this;
    }
    /**
     * Get VenueName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueName()
    {
        return isset($this->VenueName) ? $this->VenueName : null;
    }
    /**
     * Set VenueName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueName
     * @return \patest\StructType\EventDescription
     */
    public function setVenueName($venueName = null)
    {
        // validation for constraint: string
        if (!is_null($venueName) && !is_string($venueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueName, true), gettype($venueName)), __LINE__);
        }
        if (is_null($venueName) || (is_array($venueName) && empty($venueName))) {
            unset($this->VenueName);
        } else {
            $this->VenueName = $venueName;
        }
        return $this;
    }
    /**
     * Get TimeZoneId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZoneId()
    {
        return isset($this->TimeZoneId) ? $this->TimeZoneId : null;
    }
    /**
     * Set TimeZoneId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZoneId
     * @return \patest\StructType\EventDescription
     */
    public function setTimeZoneId($timeZoneId = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneId) && !is_string($timeZoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneId, true), gettype($timeZoneId)), __LINE__);
        }
        if (is_null($timeZoneId) || (is_array($timeZoneId) && empty($timeZoneId))) {
            unset($this->TimeZoneId);
        } else {
            $this->TimeZoneId = $timeZoneId;
        }
        return $this;
    }
    /**
     * Get AvailableForDisplay value
     * @return bool|null
     */
    public function getAvailableForDisplay()
    {
        return $this->AvailableForDisplay;
    }
    /**
     * Set AvailableForDisplay value
     * @param bool $availableForDisplay
     * @return \patest\StructType\EventDescription
     */
    public function setAvailableForDisplay($availableForDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableForDisplay) && !is_bool($availableForDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableForDisplay, true), gettype($availableForDisplay)), __LINE__);
        }
        $this->AvailableForDisplay = $availableForDisplay;
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\EventDescription
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get IsFutureSaleForDisplay value
     * @return bool|null
     */
    public function getIsFutureSaleForDisplay()
    {
        return $this->IsFutureSaleForDisplay;
    }
    /**
     * Set IsFutureSaleForDisplay value
     * @param bool $isFutureSaleForDisplay
     * @return \patest\StructType\EventDescription
     */
    public function setIsFutureSaleForDisplay($isFutureSaleForDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFutureSaleForDisplay) && !is_bool($isFutureSaleForDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFutureSaleForDisplay, true), gettype($isFutureSaleForDisplay)), __LINE__);
        }
        $this->IsFutureSaleForDisplay = $isFutureSaleForDisplay;
        return $this;
    }
    /**
     * Get IsAvailableForSale value
     * @return bool|null
     */
    public function getIsAvailableForSale()
    {
        return $this->IsAvailableForSale;
    }
    /**
     * Set IsAvailableForSale value
     * @param bool $isAvailableForSale
     * @return \patest\StructType\EventDescription
     */
    public function setIsAvailableForSale($isAvailableForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForSale) && !is_bool($isAvailableForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForSale, true), gettype($isAvailableForSale)), __LINE__);
        }
        $this->IsAvailableForSale = $isAvailableForSale;
        return $this;
    }
    /**
     * Get StartSaleFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartSaleFrom()
    {
        return isset($this->StartSaleFrom) ? $this->StartSaleFrom : null;
    }
    /**
     * Set StartSaleFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startSaleFrom
     * @return \patest\StructType\EventDescription
     */
    public function setStartSaleFrom($startSaleFrom = null)
    {
        // validation for constraint: string
        if (!is_null($startSaleFrom) && !is_string($startSaleFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startSaleFrom, true), gettype($startSaleFrom)), __LINE__);
        }
        if (is_null($startSaleFrom) || (is_array($startSaleFrom) && empty($startSaleFrom))) {
            unset($this->StartSaleFrom);
        } else {
            $this->StartSaleFrom = $startSaleFrom;
        }
        return $this;
    }
    /**
     * Get EndSaleAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndSaleAt()
    {
        return isset($this->EndSaleAt) ? $this->EndSaleAt : null;
    }
    /**
     * Set EndSaleAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endSaleAt
     * @return \patest\StructType\EventDescription
     */
    public function setEndSaleAt($endSaleAt = null)
    {
        // validation for constraint: string
        if (!is_null($endSaleAt) && !is_string($endSaleAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endSaleAt, true), gettype($endSaleAt)), __LINE__);
        }
        if (is_null($endSaleAt) || (is_array($endSaleAt) && empty($endSaleAt))) {
            unset($this->EndSaleAt);
        } else {
            $this->EndSaleAt = $endSaleAt;
        }
        return $this;
    }
    /**
     * Get EventSaleFlowMode value
     * @return string|null
     */
    public function getEventSaleFlowMode()
    {
        return $this->EventSaleFlowMode;
    }
    /**
     * Set EventSaleFlowMode value
     * @uses \patest\EnumType\EventSaleFlowMode::valueIsValid()
     * @uses \patest\EnumType\EventSaleFlowMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventSaleFlowMode
     * @return \patest\StructType\EventDescription
     */
    public function setEventSaleFlowMode($eventSaleFlowMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventSaleFlowMode::valueIsValid($eventSaleFlowMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleFlowMode', is_array($eventSaleFlowMode) ? implode(', ', $eventSaleFlowMode) : var_export($eventSaleFlowMode, true), implode(', ', \patest\EnumType\EventSaleFlowMode::getValidValues())), __LINE__);
        }
        $this->EventSaleFlowMode = $eventSaleFlowMode;
        return $this;
    }
    /**
     * Get LastUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdate()
    {
        return isset($this->LastUpdate) ? $this->LastUpdate : null;
    }
    /**
     * Set LastUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdate
     * @return \patest\StructType\EventDescription
     */
    public function setLastUpdate($lastUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdate) && !is_string($lastUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdate, true), gettype($lastUpdate)), __LINE__);
        }
        if (is_null($lastUpdate) || (is_array($lastUpdate) && empty($lastUpdate))) {
            unset($this->LastUpdate);
        } else {
            $this->LastUpdate = $lastUpdate;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * @return string|null
     */
    public function getShowId()
    {
        return $this->ShowId;
    }
    /**
     * Set ShowId value
     * @param string $showId
     * @return \patest\StructType\EventDescription
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        $this->ShowId = $showId;
        return $this;
    }
    /**
     * Get ShowTypeId value
     * @return string|null
     */
    public function getShowTypeId()
    {
        return $this->ShowTypeId;
    }
    /**
     * Set ShowTypeId value
     * @param string $showTypeId
     * @return \patest\StructType\EventDescription
     */
    public function setShowTypeId($showTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($showTypeId) && !is_string($showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTypeId, true), gettype($showTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showTypeId, true)), __LINE__);
        }
        $this->ShowTypeId = $showTypeId;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\EventDescription
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SmallImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSmallImageUrl()
    {
        return isset($this->SmallImageUrl) ? $this->SmallImageUrl : null;
    }
    /**
     * Set SmallImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $smallImageUrl
     * @return \patest\StructType\EventDescription
     */
    public function setSmallImageUrl($smallImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($smallImageUrl) && !is_string($smallImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smallImageUrl, true), gettype($smallImageUrl)), __LINE__);
        }
        if (is_null($smallImageUrl) || (is_array($smallImageUrl) && empty($smallImageUrl))) {
            unset($this->SmallImageUrl);
        } else {
            $this->SmallImageUrl = $smallImageUrl;
        }
        return $this;
    }
    /**
     * Get LargeImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLargeImageUrl()
    {
        return isset($this->LargeImageUrl) ? $this->LargeImageUrl : null;
    }
    /**
     * Set LargeImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $largeImageUrl
     * @return \patest\StructType\EventDescription
     */
    public function setLargeImageUrl($largeImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($largeImageUrl) && !is_string($largeImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($largeImageUrl, true), gettype($largeImageUrl)), __LINE__);
        }
        if (is_null($largeImageUrl) || (is_array($largeImageUrl) && empty($largeImageUrl))) {
            unset($this->LargeImageUrl);
        } else {
            $this->LargeImageUrl = $largeImageUrl;
        }
        return $this;
    }
    /**
     * Get ReviewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReviewUrl()
    {
        return isset($this->ReviewUrl) ? $this->ReviewUrl : null;
    }
    /**
     * Set ReviewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reviewUrl
     * @return \patest\StructType\EventDescription
     */
    public function setReviewUrl($reviewUrl = null)
    {
        // validation for constraint: string
        if (!is_null($reviewUrl) && !is_string($reviewUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reviewUrl, true), gettype($reviewUrl)), __LINE__);
        }
        if (is_null($reviewUrl) || (is_array($reviewUrl) && empty($reviewUrl))) {
            unset($this->ReviewUrl);
        } else {
            $this->ReviewUrl = $reviewUrl;
        }
        return $this;
    }
    /**
     * Get BriefText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBriefText()
    {
        return isset($this->BriefText) ? $this->BriefText : null;
    }
    /**
     * Set BriefText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $briefText
     * @return \patest\StructType\EventDescription
     */
    public function setBriefText($briefText = null)
    {
        // validation for constraint: string
        if (!is_null($briefText) && !is_string($briefText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($briefText, true), gettype($briefText)), __LINE__);
        }
        if (is_null($briefText) || (is_array($briefText) && empty($briefText))) {
            unset($this->BriefText);
        } else {
            $this->BriefText = $briefText;
        }
        return $this;
    }
    /**
     * Get DetailedText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetailedText()
    {
        return isset($this->DetailedText) ? $this->DetailedText : null;
    }
    /**
     * Set DetailedText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detailedText
     * @return \patest\StructType\EventDescription
     */
    public function setDetailedText($detailedText = null)
    {
        // validation for constraint: string
        if (!is_null($detailedText) && !is_string($detailedText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailedText, true), gettype($detailedText)), __LINE__);
        }
        if (is_null($detailedText) || (is_array($detailedText) && empty($detailedText))) {
            unset($this->DetailedText);
        } else {
            $this->DetailedText = $detailedText;
        }
        return $this;
    }
    /**
     * Get ShowMinutes value
     * @return int|null
     */
    public function getShowMinutes()
    {
        return $this->ShowMinutes;
    }
    /**
     * Set ShowMinutes value
     * @param int $showMinutes
     * @return \patest\StructType\EventDescription
     */
    public function setShowMinutes($showMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($showMinutes) && !(is_int($showMinutes) || ctype_digit($showMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showMinutes, true), gettype($showMinutes)), __LINE__);
        }
        $this->ShowMinutes = $showMinutes;
        return $this;
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \patest\StructType\EventDescription
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\EventDescription
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\EventDescription
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\EventDescription
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get FormattedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedDate()
    {
        return isset($this->FormattedDate) ? $this->FormattedDate : null;
    }
    /**
     * Set FormattedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedDate
     * @return \patest\StructType\EventDescription
     */
    public function setFormattedDate($formattedDate = null)
    {
        // validation for constraint: string
        if (!is_null($formattedDate) && !is_string($formattedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedDate, true), gettype($formattedDate)), __LINE__);
        }
        if (is_null($formattedDate) || (is_array($formattedDate) && empty($formattedDate))) {
            unset($this->FormattedDate);
        } else {
            $this->FormattedDate = $formattedDate;
        }
        return $this;
    }
    /**
     * Get AvailableSeatCount value
     * @return int|null
     */
    public function getAvailableSeatCount()
    {
        return $this->AvailableSeatCount;
    }
    /**
     * Set AvailableSeatCount value
     * @param int $availableSeatCount
     * @return \patest\StructType\EventDescription
     */
    public function setAvailableSeatCount($availableSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeatCount) && !(is_int($availableSeatCount) || ctype_digit($availableSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableSeatCount, true), gettype($availableSeatCount)), __LINE__);
        }
        $this->AvailableSeatCount = $availableSeatCount;
        return $this;
    }
    /**
     * Get IsAvailableAsBonusForSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableAsBonusForSeries()
    {
        return isset($this->IsAvailableAsBonusForSeries) ? $this->IsAvailableAsBonusForSeries : null;
    }
    /**
     * Set IsAvailableAsBonusForSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableAsBonusForSeries
     * @return \patest\StructType\EventDescription
     */
    public function setIsAvailableAsBonusForSeries($isAvailableAsBonusForSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableAsBonusForSeries) && !is_bool($isAvailableAsBonusForSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableAsBonusForSeries, true), gettype($isAvailableAsBonusForSeries)), __LINE__);
        }
        if (is_null($isAvailableAsBonusForSeries) || (is_array($isAvailableAsBonusForSeries) && empty($isAvailableAsBonusForSeries))) {
            unset($this->IsAvailableAsBonusForSeries);
        } else {
            $this->IsAvailableAsBonusForSeries = $isAvailableAsBonusForSeries;
        }
        return $this;
    }
    /**
     * Get IsAvailableAsRegularForSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAvailableAsRegularForSeries()
    {
        return isset($this->IsAvailableAsRegularForSeries) ? $this->IsAvailableAsRegularForSeries : null;
    }
    /**
     * Set IsAvailableAsRegularForSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAvailableAsRegularForSeries
     * @return \patest\StructType\EventDescription
     */
    public function setIsAvailableAsRegularForSeries($isAvailableAsRegularForSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableAsRegularForSeries) && !is_bool($isAvailableAsRegularForSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableAsRegularForSeries, true), gettype($isAvailableAsRegularForSeries)), __LINE__);
        }
        if (is_null($isAvailableAsRegularForSeries) || (is_array($isAvailableAsRegularForSeries) && empty($isAvailableAsRegularForSeries))) {
            unset($this->IsAvailableAsRegularForSeries);
        } else {
            $this->IsAvailableAsRegularForSeries = $isAvailableAsRegularForSeries;
        }
        return $this;
    }
    /**
     * Get RequestType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestType()
    {
        return isset($this->RequestType) ? $this->RequestType : null;
    }
    /**
     * Set RequestType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestType
     * @return \patest\StructType\EventDescription
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestType, true), gettype($requestType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestType, true)), __LINE__);
        }
        if (is_null($requestType) || (is_array($requestType) && empty($requestType))) {
            unset($this->RequestType);
        } else {
            $this->RequestType = $requestType;
        }
        return $this;
    }
    /**
     * Get AllowedBookingRequestTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAllowedBookingRequestTypes()
    {
        return isset($this->AllowedBookingRequestTypes) ? $this->AllowedBookingRequestTypes : null;
    }
    /**
     * Set AllowedBookingRequestTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $allowedBookingRequestTypes
     * @return \patest\StructType\EventDescription
     */
    public function setAllowedBookingRequestTypes(\patest\ArrayType\ArrayOfguid $allowedBookingRequestTypes = null)
    {
        if (is_null($allowedBookingRequestTypes) || (is_array($allowedBookingRequestTypes) && empty($allowedBookingRequestTypes))) {
            unset($this->AllowedBookingRequestTypes);
        } else {
            $this->AllowedBookingRequestTypes = $allowedBookingRequestTypes;
        }
        return $this;
    }
    /**
     * Get MediumImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMediumImageUrl()
    {
        return isset($this->MediumImageUrl) ? $this->MediumImageUrl : null;
    }
    /**
     * Set MediumImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mediumImageUrl
     * @return \patest\StructType\EventDescription
     */
    public function setMediumImageUrl($mediumImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($mediumImageUrl) && !is_string($mediumImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediumImageUrl, true), gettype($mediumImageUrl)), __LINE__);
        }
        if (is_null($mediumImageUrl) || (is_array($mediumImageUrl) && empty($mediumImageUrl))) {
            unset($this->MediumImageUrl);
        } else {
            $this->MediumImageUrl = $mediumImageUrl;
        }
        return $this;
    }
    /**
     * Get EventTags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfEventTagDescription|null
     */
    public function getEventTags()
    {
        return isset($this->EventTags) ? $this->EventTags : null;
    }
    /**
     * Set EventTags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfEventTagDescription $eventTags
     * @return \patest\StructType\EventDescription
     */
    public function setEventTags(\patest\ArrayType\ArrayOfEventTagDescription $eventTags = null)
    {
        if (is_null($eventTags) || (is_array($eventTags) && empty($eventTags))) {
            unset($this->EventTags);
        } else {
            $this->EventTags = $eventTags;
        }
        return $this;
    }
    /**
     * Get OccupancyStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOccupancyStatus()
    {
        return isset($this->OccupancyStatus) ? $this->OccupancyStatus : null;
    }
    /**
     * Set OccupancyStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventOccupancyStatus::valueIsValid()
     * @uses \patest\EnumType\EventOccupancyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $occupancyStatus
     * @return \patest\StructType\EventDescription
     */
    public function setOccupancyStatus($occupancyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventOccupancyStatus::valueIsValid($occupancyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventOccupancyStatus', is_array($occupancyStatus) ? implode(', ', $occupancyStatus) : var_export($occupancyStatus, true), implode(', ', \patest\EnumType\EventOccupancyStatus::getValidValues())), __LINE__);
        }
        if (is_null($occupancyStatus) || (is_array($occupancyStatus) && empty($occupancyStatus))) {
            unset($this->OccupancyStatus);
        } else {
            $this->OccupancyStatus = $occupancyStatus;
        }
        return $this;
    }
    /**
     * Get SocialNetworkImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSocialNetworkImageUrl()
    {
        return isset($this->SocialNetworkImageUrl) ? $this->SocialNetworkImageUrl : null;
    }
    /**
     * Set SocialNetworkImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $socialNetworkImageUrl
     * @return \patest\StructType\EventDescription
     */
    public function setSocialNetworkImageUrl($socialNetworkImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($socialNetworkImageUrl) && !is_string($socialNetworkImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialNetworkImageUrl, true), gettype($socialNetworkImageUrl)), __LINE__);
        }
        if (is_null($socialNetworkImageUrl) || (is_array($socialNetworkImageUrl) && empty($socialNetworkImageUrl))) {
            unset($this->SocialNetworkImageUrl);
        } else {
            $this->SocialNetworkImageUrl = $socialNetworkImageUrl;
        }
        return $this;
    }
    /**
     * Get AvailableHospitalityCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailableHospitalityCapacity()
    {
        return isset($this->AvailableHospitalityCapacity) ? $this->AvailableHospitalityCapacity : null;
    }
    /**
     * Set AvailableHospitalityCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availableHospitalityCapacity
     * @return \patest\StructType\EventDescription
     */
    public function setAvailableHospitalityCapacity($availableHospitalityCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($availableHospitalityCapacity) && !(is_int($availableHospitalityCapacity) || ctype_digit($availableHospitalityCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableHospitalityCapacity, true), gettype($availableHospitalityCapacity)), __LINE__);
        }
        if (is_null($availableHospitalityCapacity) || (is_array($availableHospitalityCapacity) && empty($availableHospitalityCapacity))) {
            unset($this->AvailableHospitalityCapacity);
        } else {
            $this->AvailableHospitalityCapacity = $availableHospitalityCapacity;
        }
        return $this;
    }
    /**
     * Get HospitalityOccupancyStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHospitalityOccupancyStatus()
    {
        return isset($this->HospitalityOccupancyStatus) ? $this->HospitalityOccupancyStatus : null;
    }
    /**
     * Set HospitalityOccupancyStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventOccupancyStatus::valueIsValid()
     * @uses \patest\EnumType\EventOccupancyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hospitalityOccupancyStatus
     * @return \patest\StructType\EventDescription
     */
    public function setHospitalityOccupancyStatus($hospitalityOccupancyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventOccupancyStatus::valueIsValid($hospitalityOccupancyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventOccupancyStatus', is_array($hospitalityOccupancyStatus) ? implode(', ', $hospitalityOccupancyStatus) : var_export($hospitalityOccupancyStatus, true), implode(', ', \patest\EnumType\EventOccupancyStatus::getValidValues())), __LINE__);
        }
        if (is_null($hospitalityOccupancyStatus) || (is_array($hospitalityOccupancyStatus) && empty($hospitalityOccupancyStatus))) {
            unset($this->HospitalityOccupancyStatus);
        } else {
            $this->HospitalityOccupancyStatus = $hospitalityOccupancyStatus;
        }
        return $this;
    }
    /**
     * Get IsHospitalityAvailable value
     * @return bool|null
     */
    public function getIsHospitalityAvailable()
    {
        return $this->IsHospitalityAvailable;
    }
    /**
     * Set IsHospitalityAvailable value
     * @param bool $isHospitalityAvailable
     * @return \patest\StructType\EventDescription
     */
    public function setIsHospitalityAvailable($isHospitalityAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHospitalityAvailable) && !is_bool($isHospitalityAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHospitalityAvailable, true), gettype($isHospitalityAvailable)), __LINE__);
        }
        $this->IsHospitalityAvailable = $isHospitalityAvailable;
        return $this;
    }
    /**
     * Get TotalHospitalityCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalHospitalityCapacity()
    {
        return isset($this->TotalHospitalityCapacity) ? $this->TotalHospitalityCapacity : null;
    }
    /**
     * Set TotalHospitalityCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalHospitalityCapacity
     * @return \patest\StructType\EventDescription
     */
    public function setTotalHospitalityCapacity($totalHospitalityCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($totalHospitalityCapacity) && !(is_int($totalHospitalityCapacity) || ctype_digit($totalHospitalityCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalHospitalityCapacity, true), gettype($totalHospitalityCapacity)), __LINE__);
        }
        if (is_null($totalHospitalityCapacity) || (is_array($totalHospitalityCapacity) && empty($totalHospitalityCapacity))) {
            unset($this->TotalHospitalityCapacity);
        } else {
            $this->TotalHospitalityCapacity = $totalHospitalityCapacity;
        }
        return $this;
    }
    /**
     * Get MasterHospitalityEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterHospitalityEventId()
    {
        return isset($this->MasterHospitalityEventId) ? $this->MasterHospitalityEventId : null;
    }
    /**
     * Set MasterHospitalityEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterHospitalityEventId
     * @return \patest\StructType\EventDescription
     */
    public function setMasterHospitalityEventId($masterHospitalityEventId = null)
    {
        // validation for constraint: string
        if (!is_null($masterHospitalityEventId) && !is_string($masterHospitalityEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterHospitalityEventId, true), gettype($masterHospitalityEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($masterHospitalityEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $masterHospitalityEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($masterHospitalityEventId, true)), __LINE__);
        }
        if (is_null($masterHospitalityEventId) || (is_array($masterHospitalityEventId) && empty($masterHospitalityEventId))) {
            unset($this->MasterHospitalityEventId);
        } else {
            $this->MasterHospitalityEventId = $masterHospitalityEventId;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\EventDescription
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\EventDescription
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get PerformerIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPerformerIds()
    {
        return isset($this->PerformerIds) ? $this->PerformerIds : null;
    }
    /**
     * Set PerformerIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $performerIds
     * @return \patest\StructType\EventDescription
     */
    public function setPerformerIds($performerIds = null)
    {
        // validation for constraint: string
        if (!is_null($performerIds) && !is_string($performerIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($performerIds, true), gettype($performerIds)), __LINE__);
        }
        if (is_null($performerIds) || (is_array($performerIds) && empty($performerIds))) {
            unset($this->PerformerIds);
        } else {
            $this->PerformerIds = $performerIds;
        }
        return $this;
    }
    /**
     * Get TaxonomyId value
     * @return int|null
     */
    public function getTaxonomyId()
    {
        return $this->TaxonomyId;
    }
    /**
     * Set TaxonomyId value
     * @param int $taxonomyId
     * @return \patest\StructType\EventDescription
     */
    public function setTaxonomyId($taxonomyId = null)
    {
        // validation for constraint: int
        if (!is_null($taxonomyId) && !(is_int($taxonomyId) || ctype_digit($taxonomyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxonomyId, true), gettype($taxonomyId)), __LINE__);
        }
        $this->TaxonomyId = $taxonomyId;
        return $this;
    }
    /**
     * Get Performers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfEventPerformerDescription|null
     */
    public function getPerformers()
    {
        return isset($this->Performers) ? $this->Performers : null;
    }
    /**
     * Set Performers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfEventPerformerDescription $performers
     * @return \patest\StructType\EventDescription
     */
    public function setPerformers(\patest\ArrayType\ArrayOfEventPerformerDescription $performers = null)
    {
        if (is_null($performers) || (is_array($performers) && empty($performers))) {
            unset($this->Performers);
        } else {
            $this->Performers = $performers;
        }
        return $this;
    }
    /**
     * Get TaxonomyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxonomyName()
    {
        return isset($this->TaxonomyName) ? $this->TaxonomyName : null;
    }
    /**
     * Set TaxonomyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxonomyName
     * @return \patest\StructType\EventDescription
     */
    public function setTaxonomyName($taxonomyName = null)
    {
        // validation for constraint: string
        if (!is_null($taxonomyName) && !is_string($taxonomyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxonomyName, true), gettype($taxonomyName)), __LINE__);
        }
        if (is_null($taxonomyName) || (is_array($taxonomyName) && empty($taxonomyName))) {
            unset($this->TaxonomyName);
        } else {
            $this->TaxonomyName = $taxonomyName;
        }
        return $this;
    }
    /**
     * Get OnlineTicketsLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOnlineTicketsLimit()
    {
        return isset($this->OnlineTicketsLimit) ? $this->OnlineTicketsLimit : null;
    }
    /**
     * Set OnlineTicketsLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $onlineTicketsLimit
     * @return \patest\StructType\EventDescription
     */
    public function setOnlineTicketsLimit($onlineTicketsLimit = null)
    {
        // validation for constraint: int
        if (!is_null($onlineTicketsLimit) && !(is_int($onlineTicketsLimit) || ctype_digit($onlineTicketsLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlineTicketsLimit, true), gettype($onlineTicketsLimit)), __LINE__);
        }
        if (is_null($onlineTicketsLimit) || (is_array($onlineTicketsLimit) && empty($onlineTicketsLimit))) {
            unset($this->OnlineTicketsLimit);
        } else {
            $this->OnlineTicketsLimit = $onlineTicketsLimit;
        }
        return $this;
    }
    /**
     * Get DateFormatOptions value
     * @return string|null
     */
    public function getDateFormatOptions()
    {
        return $this->DateFormatOptions;
    }
    /**
     * Set DateFormatOptions value
     * @uses \patest\EnumType\EventDateFormatOptions::valueIsValid()
     * @uses \patest\EnumType\EventDateFormatOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateFormatOptions
     * @return \patest\StructType\EventDescription
     */
    public function setDateFormatOptions($dateFormatOptions = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventDateFormatOptions::valueIsValid($dateFormatOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventDateFormatOptions', is_array($dateFormatOptions) ? implode(', ', $dateFormatOptions) : var_export($dateFormatOptions, true), implode(', ', \patest\EnumType\EventDateFormatOptions::getValidValues())), __LINE__);
        }
        $this->DateFormatOptions = $dateFormatOptions;
        return $this;
    }
    /**
     * Get PotentialPriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPotentialPriceList()
    {
        return isset($this->PotentialPriceList) ? $this->PotentialPriceList : null;
    }
    /**
     * Set PotentialPriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $potentialPriceList
     * @return \patest\StructType\EventDescription
     */
    public function setPotentialPriceList($potentialPriceList = null)
    {
        // validation for constraint: string
        if (!is_null($potentialPriceList) && !is_string($potentialPriceList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($potentialPriceList, true), gettype($potentialPriceList)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($potentialPriceList) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $potentialPriceList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($potentialPriceList, true)), __LINE__);
        }
        if (is_null($potentialPriceList) || (is_array($potentialPriceList) && empty($potentialPriceList))) {
            unset($this->PotentialPriceList);
        } else {
            $this->PotentialPriceList = $potentialPriceList;
        }
        return $this;
    }
    /**
     * Get EventAddOnType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventAddOnType()
    {
        return isset($this->EventAddOnType) ? $this->EventAddOnType : null;
    }
    /**
     * Set EventAddOnType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventAddOnClassification::valueIsValid()
     * @uses \patest\EnumType\EventAddOnClassification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventAddOnType
     * @return \patest\StructType\EventDescription
     */
    public function setEventAddOnType($eventAddOnType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventAddOnClassification::valueIsValid($eventAddOnType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventAddOnClassification', is_array($eventAddOnType) ? implode(', ', $eventAddOnType) : var_export($eventAddOnType, true), implode(', ', \patest\EnumType\EventAddOnClassification::getValidValues())), __LINE__);
        }
        if (is_null($eventAddOnType) || (is_array($eventAddOnType) && empty($eventAddOnType))) {
            unset($this->EventAddOnType);
        } else {
            $this->EventAddOnType = $eventAddOnType;
        }
        return $this;
    }
    /**
     * Get EventUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventUrl()
    {
        return isset($this->EventUrl) ? $this->EventUrl : null;
    }
    /**
     * Set EventUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventUrl
     * @return \patest\StructType\EventDescription
     */
    public function setEventUrl($eventUrl = null)
    {
        // validation for constraint: string
        if (!is_null($eventUrl) && !is_string($eventUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventUrl, true), gettype($eventUrl)), __LINE__);
        }
        if (is_null($eventUrl) || (is_array($eventUrl) && empty($eventUrl))) {
            unset($this->EventUrl);
        } else {
            $this->EventUrl = $eventUrl;
        }
        return $this;
    }
    /**
     * Get OnlineThumbnailImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineThumbnailImageUrl()
    {
        return isset($this->OnlineThumbnailImageUrl) ? $this->OnlineThumbnailImageUrl : null;
    }
    /**
     * Set OnlineThumbnailImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineThumbnailImageUrl
     * @return \patest\StructType\EventDescription
     */
    public function setOnlineThumbnailImageUrl($onlineThumbnailImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($onlineThumbnailImageUrl) && !is_string($onlineThumbnailImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineThumbnailImageUrl, true), gettype($onlineThumbnailImageUrl)), __LINE__);
        }
        if (is_null($onlineThumbnailImageUrl) || (is_array($onlineThumbnailImageUrl) && empty($onlineThumbnailImageUrl))) {
            unset($this->OnlineThumbnailImageUrl);
        } else {
            $this->OnlineThumbnailImageUrl = $onlineThumbnailImageUrl;
        }
        return $this;
    }
    /**
     * Get LimitationRuleInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfRuleDescription|null
     */
    public function getLimitationRuleInfo()
    {
        return isset($this->LimitationRuleInfo) ? $this->LimitationRuleInfo : null;
    }
    /**
     * Set LimitationRuleInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfRuleDescription $limitationRuleInfo
     * @return \patest\StructType\EventDescription
     */
    public function setLimitationRuleInfo(\patest\ArrayType\ArrayOfRuleDescription $limitationRuleInfo = null)
    {
        if (is_null($limitationRuleInfo) || (is_array($limitationRuleInfo) && empty($limitationRuleInfo))) {
            unset($this->LimitationRuleInfo);
        } else {
            $this->LimitationRuleInfo = $limitationRuleInfo;
        }
        return $this;
    }
    /**
     * Get OnlineHeroImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineHeroImageUrl()
    {
        return isset($this->OnlineHeroImageUrl) ? $this->OnlineHeroImageUrl : null;
    }
    /**
     * Set OnlineHeroImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineHeroImageUrl
     * @return \patest\StructType\EventDescription
     */
    public function setOnlineHeroImageUrl($onlineHeroImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($onlineHeroImageUrl) && !is_string($onlineHeroImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineHeroImageUrl, true), gettype($onlineHeroImageUrl)), __LINE__);
        }
        if (is_null($onlineHeroImageUrl) || (is_array($onlineHeroImageUrl) && empty($onlineHeroImageUrl))) {
            unset($this->OnlineHeroImageUrl);
        } else {
            $this->OnlineHeroImageUrl = $onlineHeroImageUrl;
        }
        return $this;
    }
}
