<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EsroPubSubEventArgs StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EsroPubSubEventArgs
 * @subpackage Structs
 */
class EsroPubSubEventArgs extends PubSubEventArgs
{
    /**
     * The EventData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringanyType
     */
    public $EventData;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventName;
    /**
     * The InstanceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstanceId;
    /**
     * The SiteId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteId;
    /**
     * Constructor method for EsroPubSubEventArgs
     * @uses EsroPubSubEventArgs::setEventData()
     * @uses EsroPubSubEventArgs::setEventName()
     * @uses EsroPubSubEventArgs::setInstanceId()
     * @uses EsroPubSubEventArgs::setSiteId()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringanyType $eventData
     * @param string $eventName
     * @param string $instanceId
     * @param string $siteId
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfstringanyType $eventData = null, $eventName = null, $instanceId = null, $siteId = null)
    {
        $this
            ->setEventData($eventData)
            ->setEventName($eventName)
            ->setInstanceId($instanceId)
            ->setSiteId($siteId);
    }
    /**
     * Get EventData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringanyType|null
     */
    public function getEventData()
    {
        return isset($this->EventData) ? $this->EventData : null;
    }
    /**
     * Set EventData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringanyType $eventData
     * @return \patest\StructType\EsroPubSubEventArgs
     */
    public function setEventData(\patest\ArrayType\ArrayOfKeyValueOfstringanyType $eventData = null)
    {
        if (is_null($eventData) || (is_array($eventData) && empty($eventData))) {
            unset($this->EventData);
        } else {
            $this->EventData = $eventData;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventName
     * @return \patest\StructType\EsroPubSubEventArgs
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventName, true), gettype($eventName)), __LINE__);
        }
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get InstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstanceId()
    {
        return isset($this->InstanceId) ? $this->InstanceId : null;
    }
    /**
     * Set InstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instanceId
     * @return \patest\StructType\EsroPubSubEventArgs
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceId, true), gettype($instanceId)), __LINE__);
        }
        if (is_null($instanceId) || (is_array($instanceId) && empty($instanceId))) {
            unset($this->InstanceId);
        } else {
            $this->InstanceId = $instanceId;
        }
        return $this;
    }
    /**
     * Get SiteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteId()
    {
        return isset($this->SiteId) ? $this->SiteId : null;
    }
    /**
     * Set SiteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteId
     * @return \patest\StructType\EsroPubSubEventArgs
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: string
        if (!is_null($siteId) && !is_string($siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteId, true), gettype($siteId)), __LINE__);
        }
        if (is_null($siteId) || (is_array($siteId) && empty($siteId))) {
            unset($this->SiteId);
        } else {
            $this->SiteId = $siteId;
        }
        return $this;
    }
}
