<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityProcessingResults StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntityProcessingResults
 * @subpackage Structs
 */
class EntityProcessingResults extends AbstractStructBase
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityId;
    /**
     * The ErrorsText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorsText;
    /**
     * The IsSucceded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSucceded;
    /**
     * Constructor method for EntityProcessingResults
     * @uses EntityProcessingResults::setEntityId()
     * @uses EntityProcessingResults::setErrorsText()
     * @uses EntityProcessingResults::setIsSucceded()
     * @param string $entityId
     * @param string $errorsText
     * @param bool $isSucceded
     */
    public function __construct($entityId = null, $errorsText = null, $isSucceded = null)
    {
        $this
            ->setEntityId($entityId)
            ->setErrorsText($errorsText)
            ->setIsSucceded($isSucceded);
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\EntityProcessingResults
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get ErrorsText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorsText()
    {
        return isset($this->ErrorsText) ? $this->ErrorsText : null;
    }
    /**
     * Set ErrorsText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorsText
     * @return \patest\StructType\EntityProcessingResults
     */
    public function setErrorsText($errorsText = null)
    {
        // validation for constraint: string
        if (!is_null($errorsText) && !is_string($errorsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorsText, true), gettype($errorsText)), __LINE__);
        }
        if (is_null($errorsText) || (is_array($errorsText) && empty($errorsText))) {
            unset($this->ErrorsText);
        } else {
            $this->ErrorsText = $errorsText;
        }
        return $this;
    }
    /**
     * Get IsSucceded value
     * @return bool|null
     */
    public function getIsSucceded()
    {
        return $this->IsSucceded;
    }
    /**
     * Set IsSucceded value
     * @param bool $isSucceded
     * @return \patest\StructType\EntityProcessingResults
     */
    public function setIsSucceded($isSucceded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSucceded) && !is_bool($isSucceded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSucceded, true), gettype($isSucceded)), __LINE__);
        }
        $this->IsSucceded = $isSucceded;
        return $this;
    }
}
