<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntityIdentity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntityIdentity
 * @subpackage Structs
 */
class EntityIdentity extends AbstractStructBase
{
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EntityId;
    /**
     * Constructor method for EntityIdentity
     * @uses EntityIdentity::setEntityName()
     * @uses EntityIdentity::setEntityId()
     * @param string $entityName
     * @param string $entityId
     */
    public function __construct($entityName = null, $entityId = null)
    {
        $this
            ->setEntityName($entityName)
            ->setEntityId($entityId);
    }
    /**
     * Get EntityName value
     * @return string|null
     */
    public function getEntityName()
    {
        return $this->EntityName;
    }
    /**
     * Set EntityName value
     * @param string $entityName
     * @return \patest\StructType\EntityIdentity
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        $this->EntityName = $entityName;
        return $this;
    }
    /**
     * Get EntityId value
     * @return string|null
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }
    /**
     * Set EntityId value
     * @param string $entityId
     * @return \patest\StructType\EntityIdentity
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }
}
