<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntitiesQueryRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntitiesQueryRequest
 * @subpackage Structs
 */
class EntitiesQueryRequest extends AbstractStructBase
{
    /**
     * The EntityIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $EntityIds;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AnyEntity
     */
    public $EntityType;
    /**
     * The Esql
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Esql;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $From;
    /**
     * The Includes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $Includes;
    /**
     * The IsVerifyIdsRetrieved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsVerifyIdsRetrieved;
    /**
     * The OrderBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderBy;
    /**
     * The Products
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $Products;
    /**
     * The Top
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Top;
    /**
     * The Where
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Where;
    /**
     * The ClientSupportChunks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ClientSupportChunks;
    /**
     * The HintValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $HintValues;
    /**
     * The InitialChunkSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InitialChunkSize;
    /**
     * The MaxMatchingRowsToCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxMatchingRowsToCount;
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceName;
    /**
     * The ShouldIncludeCountTotalMatchingRows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldIncludeCountTotalMatchingRows;
    /**
     * Constructor method for EntitiesQueryRequest
     * @uses EntitiesQueryRequest::setEntityIds()
     * @uses EntitiesQueryRequest::setEntityType()
     * @uses EntitiesQueryRequest::setEsql()
     * @uses EntitiesQueryRequest::setFrom()
     * @uses EntitiesQueryRequest::setIncludes()
     * @uses EntitiesQueryRequest::setIsVerifyIdsRetrieved()
     * @uses EntitiesQueryRequest::setOrderBy()
     * @uses EntitiesQueryRequest::setProducts()
     * @uses EntitiesQueryRequest::setTop()
     * @uses EntitiesQueryRequest::setWhere()
     * @uses EntitiesQueryRequest::setClientSupportChunks()
     * @uses EntitiesQueryRequest::setHintValues()
     * @uses EntitiesQueryRequest::setInitialChunkSize()
     * @uses EntitiesQueryRequest::setMaxMatchingRowsToCount()
     * @uses EntitiesQueryRequest::setServiceName()
     * @uses EntitiesQueryRequest::setShouldIncludeCountTotalMatchingRows()
     * @param \patest\ArrayType\ArrayOfstring $entityIds
     * @param \patest\StructType\AnyEntity $entityType
     * @param string $esql
     * @param string $from
     * @param \patest\ArrayType\ArrayOfstring $includes
     * @param bool $isVerifyIdsRetrieved
     * @param string $orderBy
     * @param \patest\ArrayType\ArrayOfstring $products
     * @param int $top
     * @param string $where
     * @param bool $clientSupportChunks
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $hintValues
     * @param int $initialChunkSize
     * @param int $maxMatchingRowsToCount
     * @param string $serviceName
     * @param bool $shouldIncludeCountTotalMatchingRows
     */
    public function __construct(\patest\ArrayType\ArrayOfstring $entityIds = null, \patest\StructType\AnyEntity $entityType = null, $esql = null, $from = null, \patest\ArrayType\ArrayOfstring $includes = null, $isVerifyIdsRetrieved = null, $orderBy = null, \patest\ArrayType\ArrayOfstring $products = null, $top = null, $where = null, $clientSupportChunks = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $hintValues = null, $initialChunkSize = null, $maxMatchingRowsToCount = null, $serviceName = null, $shouldIncludeCountTotalMatchingRows = null)
    {
        $this
            ->setEntityIds($entityIds)
            ->setEntityType($entityType)
            ->setEsql($esql)
            ->setFrom($from)
            ->setIncludes($includes)
            ->setIsVerifyIdsRetrieved($isVerifyIdsRetrieved)
            ->setOrderBy($orderBy)
            ->setProducts($products)
            ->setTop($top)
            ->setWhere($where)
            ->setClientSupportChunks($clientSupportChunks)
            ->setHintValues($hintValues)
            ->setInitialChunkSize($initialChunkSize)
            ->setMaxMatchingRowsToCount($maxMatchingRowsToCount)
            ->setServiceName($serviceName)
            ->setShouldIncludeCountTotalMatchingRows($shouldIncludeCountTotalMatchingRows);
    }
    /**
     * Get EntityIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getEntityIds()
    {
        return isset($this->EntityIds) ? $this->EntityIds : null;
    }
    /**
     * Set EntityIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $entityIds
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setEntityIds(\patest\ArrayType\ArrayOfstring $entityIds = null)
    {
        if (is_null($entityIds) || (is_array($entityIds) && empty($entityIds))) {
            unset($this->EntityIds);
        } else {
            $this->EntityIds = $entityIds;
        }
        return $this;
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AnyEntity|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AnyEntity $entityType
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setEntityType(\patest\StructType\AnyEntity $entityType = null)
    {
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get Esql value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEsql()
    {
        return isset($this->Esql) ? $this->Esql : null;
    }
    /**
     * Set Esql value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $esql
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setEsql($esql = null)
    {
        // validation for constraint: string
        if (!is_null($esql) && !is_string($esql)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($esql, true), gettype($esql)), __LINE__);
        }
        if (is_null($esql) || (is_array($esql) && empty($esql))) {
            unset($this->Esql);
        } else {
            $this->Esql = $esql;
        }
        return $this;
    }
    /**
     * Get From value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrom()
    {
        return isset($this->From) ? $this->From : null;
    }
    /**
     * Set From value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $from
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        if (is_null($from) || (is_array($from) && empty($from))) {
            unset($this->From);
        } else {
            $this->From = $from;
        }
        return $this;
    }
    /**
     * Get Includes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getIncludes()
    {
        return isset($this->Includes) ? $this->Includes : null;
    }
    /**
     * Set Includes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $includes
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setIncludes(\patest\ArrayType\ArrayOfstring $includes = null)
    {
        if (is_null($includes) || (is_array($includes) && empty($includes))) {
            unset($this->Includes);
        } else {
            $this->Includes = $includes;
        }
        return $this;
    }
    /**
     * Get IsVerifyIdsRetrieved value
     * @return bool|null
     */
    public function getIsVerifyIdsRetrieved()
    {
        return $this->IsVerifyIdsRetrieved;
    }
    /**
     * Set IsVerifyIdsRetrieved value
     * @param bool $isVerifyIdsRetrieved
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setIsVerifyIdsRetrieved($isVerifyIdsRetrieved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerifyIdsRetrieved) && !is_bool($isVerifyIdsRetrieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerifyIdsRetrieved, true), gettype($isVerifyIdsRetrieved)), __LINE__);
        }
        $this->IsVerifyIdsRetrieved = $isVerifyIdsRetrieved;
        return $this;
    }
    /**
     * Get OrderBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderBy()
    {
        return isset($this->OrderBy) ? $this->OrderBy : null;
    }
    /**
     * Set OrderBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderBy
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderBy, true), gettype($orderBy)), __LINE__);
        }
        if (is_null($orderBy) || (is_array($orderBy) && empty($orderBy))) {
            unset($this->OrderBy);
        } else {
            $this->OrderBy = $orderBy;
        }
        return $this;
    }
    /**
     * Get Products value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getProducts()
    {
        return isset($this->Products) ? $this->Products : null;
    }
    /**
     * Set Products value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $products
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setProducts(\patest\ArrayType\ArrayOfstring $products = null)
    {
        if (is_null($products) || (is_array($products) && empty($products))) {
            unset($this->Products);
        } else {
            $this->Products = $products;
        }
        return $this;
    }
    /**
     * Get Top value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTop()
    {
        return isset($this->Top) ? $this->Top : null;
    }
    /**
     * Set Top value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $top
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setTop($top = null)
    {
        // validation for constraint: int
        if (!is_null($top) && !(is_int($top) || ctype_digit($top))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($top, true), gettype($top)), __LINE__);
        }
        if (is_null($top) || (is_array($top) && empty($top))) {
            unset($this->Top);
        } else {
            $this->Top = $top;
        }
        return $this;
    }
    /**
     * Get Where value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhere()
    {
        return isset($this->Where) ? $this->Where : null;
    }
    /**
     * Set Where value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $where
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setWhere($where = null)
    {
        // validation for constraint: string
        if (!is_null($where) && !is_string($where)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($where, true), gettype($where)), __LINE__);
        }
        if (is_null($where) || (is_array($where) && empty($where))) {
            unset($this->Where);
        } else {
            $this->Where = $where;
        }
        return $this;
    }
    /**
     * Get ClientSupportChunks value
     * @return bool|null
     */
    public function getClientSupportChunks()
    {
        return $this->ClientSupportChunks;
    }
    /**
     * Set ClientSupportChunks value
     * @param bool $clientSupportChunks
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setClientSupportChunks($clientSupportChunks = null)
    {
        // validation for constraint: boolean
        if (!is_null($clientSupportChunks) && !is_bool($clientSupportChunks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($clientSupportChunks, true), gettype($clientSupportChunks)), __LINE__);
        }
        $this->ClientSupportChunks = $clientSupportChunks;
        return $this;
    }
    /**
     * Get HintValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getHintValues()
    {
        return isset($this->HintValues) ? $this->HintValues : null;
    }
    /**
     * Set HintValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $hintValues
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setHintValues(\patest\ArrayType\ArrayOfKeyValueOfstringstring $hintValues = null)
    {
        if (is_null($hintValues) || (is_array($hintValues) && empty($hintValues))) {
            unset($this->HintValues);
        } else {
            $this->HintValues = $hintValues;
        }
        return $this;
    }
    /**
     * Get InitialChunkSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInitialChunkSize()
    {
        return isset($this->InitialChunkSize) ? $this->InitialChunkSize : null;
    }
    /**
     * Set InitialChunkSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $initialChunkSize
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setInitialChunkSize($initialChunkSize = null)
    {
        // validation for constraint: int
        if (!is_null($initialChunkSize) && !(is_int($initialChunkSize) || ctype_digit($initialChunkSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($initialChunkSize, true), gettype($initialChunkSize)), __LINE__);
        }
        if (is_null($initialChunkSize) || (is_array($initialChunkSize) && empty($initialChunkSize))) {
            unset($this->InitialChunkSize);
        } else {
            $this->InitialChunkSize = $initialChunkSize;
        }
        return $this;
    }
    /**
     * Get MaxMatchingRowsToCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxMatchingRowsToCount()
    {
        return isset($this->MaxMatchingRowsToCount) ? $this->MaxMatchingRowsToCount : null;
    }
    /**
     * Set MaxMatchingRowsToCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxMatchingRowsToCount
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setMaxMatchingRowsToCount($maxMatchingRowsToCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxMatchingRowsToCount) && !(is_int($maxMatchingRowsToCount) || ctype_digit($maxMatchingRowsToCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxMatchingRowsToCount, true), gettype($maxMatchingRowsToCount)), __LINE__);
        }
        if (is_null($maxMatchingRowsToCount) || (is_array($maxMatchingRowsToCount) && empty($maxMatchingRowsToCount))) {
            unset($this->MaxMatchingRowsToCount);
        } else {
            $this->MaxMatchingRowsToCount = $maxMatchingRowsToCount;
        }
        return $this;
    }
    /**
     * Get ServiceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceName()
    {
        return isset($this->ServiceName) ? $this->ServiceName : null;
    }
    /**
     * Set ServiceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceName
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->ServiceName);
        } else {
            $this->ServiceName = $serviceName;
        }
        return $this;
    }
    /**
     * Get ShouldIncludeCountTotalMatchingRows value
     * @return bool|null
     */
    public function getShouldIncludeCountTotalMatchingRows()
    {
        return $this->ShouldIncludeCountTotalMatchingRows;
    }
    /**
     * Set ShouldIncludeCountTotalMatchingRows value
     * @param bool $shouldIncludeCountTotalMatchingRows
     * @return \patest\StructType\EntitiesQueryRequest
     */
    public function setShouldIncludeCountTotalMatchingRows($shouldIncludeCountTotalMatchingRows = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldIncludeCountTotalMatchingRows) && !is_bool($shouldIncludeCountTotalMatchingRows)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldIncludeCountTotalMatchingRows, true), gettype($shouldIncludeCountTotalMatchingRows)), __LINE__);
        }
        $this->ShouldIncludeCountTotalMatchingRows = $shouldIncludeCountTotalMatchingRows;
        return $this;
    }
}
