<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EntitiesCreateOrUpdateRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntitiesCreateOrUpdateRequest
 * @subpackage Structs
 */
class EntitiesCreateOrUpdateRequest extends AbstractStructBase
{
    /**
     * The DoNotReturnEntityData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DoNotReturnEntityData;
    /**
     * The Entities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAnyEntity
     */
    public $Entities;
    /**
     * The HintValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $HintValues;
    /**
     * The IsNonAtomic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsNonAtomic;
    /**
     * Constructor method for EntitiesCreateOrUpdateRequest
     * @uses EntitiesCreateOrUpdateRequest::setDoNotReturnEntityData()
     * @uses EntitiesCreateOrUpdateRequest::setEntities()
     * @uses EntitiesCreateOrUpdateRequest::setHintValues()
     * @uses EntitiesCreateOrUpdateRequest::setIsNonAtomic()
     * @param bool $doNotReturnEntityData
     * @param \patest\ArrayType\ArrayOfAnyEntity $entities
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $hintValues
     * @param bool $isNonAtomic
     */
    public function __construct($doNotReturnEntityData = null, \patest\ArrayType\ArrayOfAnyEntity $entities = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $hintValues = null, $isNonAtomic = null)
    {
        $this
            ->setDoNotReturnEntityData($doNotReturnEntityData)
            ->setEntities($entities)
            ->setHintValues($hintValues)
            ->setIsNonAtomic($isNonAtomic);
    }
    /**
     * Get DoNotReturnEntityData value
     * @return bool|null
     */
    public function getDoNotReturnEntityData()
    {
        return $this->DoNotReturnEntityData;
    }
    /**
     * Set DoNotReturnEntityData value
     * @param bool $doNotReturnEntityData
     * @return \patest\StructType\EntitiesCreateOrUpdateRequest
     */
    public function setDoNotReturnEntityData($doNotReturnEntityData = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotReturnEntityData) && !is_bool($doNotReturnEntityData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotReturnEntityData, true), gettype($doNotReturnEntityData)), __LINE__);
        }
        $this->DoNotReturnEntityData = $doNotReturnEntityData;
        return $this;
    }
    /**
     * Get Entities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAnyEntity|null
     */
    public function getEntities()
    {
        return isset($this->Entities) ? $this->Entities : null;
    }
    /**
     * Set Entities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAnyEntity $entities
     * @return \patest\StructType\EntitiesCreateOrUpdateRequest
     */
    public function setEntities(\patest\ArrayType\ArrayOfAnyEntity $entities = null)
    {
        if (is_null($entities) || (is_array($entities) && empty($entities))) {
            unset($this->Entities);
        } else {
            $this->Entities = $entities;
        }
        return $this;
    }
    /**
     * Get HintValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getHintValues()
    {
        return isset($this->HintValues) ? $this->HintValues : null;
    }
    /**
     * Set HintValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $hintValues
     * @return \patest\StructType\EntitiesCreateOrUpdateRequest
     */
    public function setHintValues(\patest\ArrayType\ArrayOfKeyValueOfstringstring $hintValues = null)
    {
        if (is_null($hintValues) || (is_array($hintValues) && empty($hintValues))) {
            unset($this->HintValues);
        } else {
            $this->HintValues = $hintValues;
        }
        return $this;
    }
    /**
     * Get IsNonAtomic value
     * @return bool|null
     */
    public function getIsNonAtomic()
    {
        return $this->IsNonAtomic;
    }
    /**
     * Set IsNonAtomic value
     * @param bool $isNonAtomic
     * @return \patest\StructType\EntitiesCreateOrUpdateRequest
     */
    public function setIsNonAtomic($isNonAtomic = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNonAtomic) && !is_bool($isNonAtomic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNonAtomic, true), gettype($isNonAtomic)), __LINE__);
        }
        $this->IsNonAtomic = $isNonAtomic;
        return $this;
    }
}
