<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnrollmentAndTicketsData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EnrollmentAndTicketsData
 * @subpackage Structs
 */
class EnrollmentAndTicketsData extends ExtensibleDataContract
{
    /**
     * The Enrollment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_TicketSchemeClientEnrollment
     */
    public $Enrollment;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketing_TicketOfEnrollment
     */
    public $Tickets;
    /**
     * Constructor method for EnrollmentAndTicketsData
     * @uses EnrollmentAndTicketsData::setEnrollment()
     * @uses EnrollmentAndTicketsData::setTickets()
     * @param \patest\StructType\Crm_TicketSchemeClientEnrollment $enrollment
     * @param \patest\ArrayType\ArrayOfTicketing_TicketOfEnrollment $tickets
     */
    public function __construct(\patest\StructType\Crm_TicketSchemeClientEnrollment $enrollment = null, \patest\ArrayType\ArrayOfTicketing_TicketOfEnrollment $tickets = null)
    {
        $this
            ->setEnrollment($enrollment)
            ->setTickets($tickets);
    }
    /**
     * Get Enrollment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollment|null
     */
    public function getEnrollment()
    {
        return isset($this->Enrollment) ? $this->Enrollment : null;
    }
    /**
     * Set Enrollment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_TicketSchemeClientEnrollment $enrollment
     * @return \patest\StructType\EnrollmentAndTicketsData
     */
    public function setEnrollment(\patest\StructType\Crm_TicketSchemeClientEnrollment $enrollment = null)
    {
        if (is_null($enrollment) || (is_array($enrollment) && empty($enrollment))) {
            unset($this->Enrollment);
        } else {
            $this->Enrollment = $enrollment;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketing_TicketOfEnrollment|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketing_TicketOfEnrollment $tickets
     * @return \patest\StructType\EnrollmentAndTicketsData
     */
    public function setTickets(\patest\ArrayType\ArrayOfTicketing_TicketOfEnrollment $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
}
