<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EffectiveAvailabilityFilterIdentification StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EffectiveAvailabilityFilterIdentification
 * @subpackage Structs
 */
class EffectiveAvailabilityFilterIdentification extends AbstractStructBase
{
    /**
     * The ExplicitFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilter
     */
    public $ExplicitFilter;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Token;
    /**
     * Constructor method for EffectiveAvailabilityFilterIdentification
     * @uses EffectiveAvailabilityFilterIdentification::setExplicitFilter()
     * @uses EffectiveAvailabilityFilterIdentification::setToken()
     * @param \patest\StructType\EffectiveAvailabilityFilter $explicitFilter
     * @param string $token
     */
    public function __construct(\patest\StructType\EffectiveAvailabilityFilter $explicitFilter = null, $token = null)
    {
        $this
            ->setExplicitFilter($explicitFilter)
            ->setToken($token);
    }
    /**
     * Get ExplicitFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilter|null
     */
    public function getExplicitFilter()
    {
        return isset($this->ExplicitFilter) ? $this->ExplicitFilter : null;
    }
    /**
     * Set ExplicitFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilter $explicitFilter
     * @return \patest\StructType\EffectiveAvailabilityFilterIdentification
     */
    public function setExplicitFilter(\patest\StructType\EffectiveAvailabilityFilter $explicitFilter = null)
    {
        if (is_null($explicitFilter) || (is_array($explicitFilter) && empty($explicitFilter))) {
            unset($this->ExplicitFilter);
        } else {
            $this->ExplicitFilter = $explicitFilter;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \patest\StructType\EffectiveAvailabilityFilterIdentification
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($token) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($token, true)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
