<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EffectiveAvailabilityFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EffectiveAvailabilityFilter
 * @subpackage Structs
 */
class EffectiveAvailabilityFilter extends AbstractStructBase
{
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * The PriceLevelsFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterList
     */
    public $PriceLevelsFilter;
    /**
     * The RestrictionsFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterList
     */
    public $RestrictionsFilter;
    /**
     * The AreasFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterList
     */
    public $AreasFilter;
    /**
     * The SeatTypesFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterList
     */
    public $SeatTypesFilter;
    /**
     * The SeatTypesKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTypesKind;
    /**
     * Constructor method for EffectiveAvailabilityFilter
     * @uses EffectiveAvailabilityFilter::setCouponIdentity()
     * @uses EffectiveAvailabilityFilter::setPresaleId()
     * @uses EffectiveAvailabilityFilter::setPriceLevelsFilter()
     * @uses EffectiveAvailabilityFilter::setRestrictionsFilter()
     * @uses EffectiveAvailabilityFilter::setAreasFilter()
     * @uses EffectiveAvailabilityFilter::setSeatTypesFilter()
     * @uses EffectiveAvailabilityFilter::setSeatTypesKind()
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param string $presaleId
     * @param \patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter
     * @param \patest\StructType\EffectiveAvailabilityFilterList $restrictionsFilter
     * @param \patest\StructType\EffectiveAvailabilityFilterList $areasFilter
     * @param \patest\StructType\EffectiveAvailabilityFilterList $seatTypesFilter
     * @param string $seatTypesKind
     */
    public function __construct(\patest\StructType\CouponIdentity $couponIdentity = null, $presaleId = null, \patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter = null, \patest\StructType\EffectiveAvailabilityFilterList $restrictionsFilter = null, \patest\StructType\EffectiveAvailabilityFilterList $areasFilter = null, \patest\StructType\EffectiveAvailabilityFilterList $seatTypesFilter = null, $seatTypesKind = null)
    {
        $this
            ->setCouponIdentity($couponIdentity)
            ->setPresaleId($presaleId)
            ->setPriceLevelsFilter($priceLevelsFilter)
            ->setRestrictionsFilter($restrictionsFilter)
            ->setAreasFilter($areasFilter)
            ->setSeatTypesFilter($seatTypesFilter)
            ->setSeatTypesKind($seatTypesKind);
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\EffectiveAvailabilityFilter
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get PresaleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPresaleId()
    {
        return isset($this->PresaleId) ? $this->PresaleId : null;
    }
    /**
     * Set PresaleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $presaleId
     * @return \patest\StructType\EffectiveAvailabilityFilter
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        if (is_null($presaleId) || (is_array($presaleId) && empty($presaleId))) {
            unset($this->PresaleId);
        } else {
            $this->PresaleId = $presaleId;
        }
        return $this;
    }
    /**
     * Get PriceLevelsFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterList|null
     */
    public function getPriceLevelsFilter()
    {
        return isset($this->PriceLevelsFilter) ? $this->PriceLevelsFilter : null;
    }
    /**
     * Set PriceLevelsFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter
     * @return \patest\StructType\EffectiveAvailabilityFilter
     */
    public function setPriceLevelsFilter(\patest\StructType\EffectiveAvailabilityFilterList $priceLevelsFilter = null)
    {
        if (is_null($priceLevelsFilter) || (is_array($priceLevelsFilter) && empty($priceLevelsFilter))) {
            unset($this->PriceLevelsFilter);
        } else {
            $this->PriceLevelsFilter = $priceLevelsFilter;
        }
        return $this;
    }
    /**
     * Get RestrictionsFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterList|null
     */
    public function getRestrictionsFilter()
    {
        return isset($this->RestrictionsFilter) ? $this->RestrictionsFilter : null;
    }
    /**
     * Set RestrictionsFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterList $restrictionsFilter
     * @return \patest\StructType\EffectiveAvailabilityFilter
     */
    public function setRestrictionsFilter(\patest\StructType\EffectiveAvailabilityFilterList $restrictionsFilter = null)
    {
        if (is_null($restrictionsFilter) || (is_array($restrictionsFilter) && empty($restrictionsFilter))) {
            unset($this->RestrictionsFilter);
        } else {
            $this->RestrictionsFilter = $restrictionsFilter;
        }
        return $this;
    }
    /**
     * Get AreasFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterList|null
     */
    public function getAreasFilter()
    {
        return isset($this->AreasFilter) ? $this->AreasFilter : null;
    }
    /**
     * Set AreasFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterList $areasFilter
     * @return \patest\StructType\EffectiveAvailabilityFilter
     */
    public function setAreasFilter(\patest\StructType\EffectiveAvailabilityFilterList $areasFilter = null)
    {
        if (is_null($areasFilter) || (is_array($areasFilter) && empty($areasFilter))) {
            unset($this->AreasFilter);
        } else {
            $this->AreasFilter = $areasFilter;
        }
        return $this;
    }
    /**
     * Get SeatTypesFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterList|null
     */
    public function getSeatTypesFilter()
    {
        return isset($this->SeatTypesFilter) ? $this->SeatTypesFilter : null;
    }
    /**
     * Set SeatTypesFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterList $seatTypesFilter
     * @return \patest\StructType\EffectiveAvailabilityFilter
     */
    public function setSeatTypesFilter(\patest\StructType\EffectiveAvailabilityFilterList $seatTypesFilter = null)
    {
        if (is_null($seatTypesFilter) || (is_array($seatTypesFilter) && empty($seatTypesFilter))) {
            unset($this->SeatTypesFilter);
        } else {
            $this->SeatTypesFilter = $seatTypesFilter;
        }
        return $this;
    }
    /**
     * Get SeatTypesKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypesKind()
    {
        return isset($this->SeatTypesKind) ? $this->SeatTypesKind : null;
    }
    /**
     * Set SeatTypesKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatTypesKind::valueIsValid()
     * @uses \patest\EnumType\SeatTypesKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatTypesKind
     * @return \patest\StructType\EffectiveAvailabilityFilter
     */
    public function setSeatTypesKind($seatTypesKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatTypesKind::valueIsValid($seatTypesKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatTypesKind', is_array($seatTypesKind) ? implode(', ', $seatTypesKind) : var_export($seatTypesKind, true), implode(', ', \patest\EnumType\SeatTypesKind::getValidValues())), __LINE__);
        }
        if (is_null($seatTypesKind) || (is_array($seatTypesKind) && empty($seatTypesKind))) {
            unset($this->SeatTypesKind);
        } else {
            $this->SeatTypesKind = $seatTypesKind;
        }
        return $this;
    }
}
