<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eSRO.Basket.AbstractProductItem StructType
 * @subpackage Structs
 */
class ESRO_Basket_AbstractProductItem extends ESRO_Basket_AbstractItem
{
    /**
     * The PriceToPay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PriceToPay;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The TotalCommissions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCommissions;
    /**
     * The TotalDiscounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalDiscounts;
    /**
     * The TotalInsideCommissions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalInsideCommissions;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * The TotalTaxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTaxes;
    /**
     * The TotalVat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalVat;
    /**
     * Constructor method for eSRO.Basket.AbstractProductItem
     * @uses ESRO_Basket_AbstractProductItem::setPriceToPay()
     * @uses ESRO_Basket_AbstractProductItem::setPriceTypeName()
     * @uses ESRO_Basket_AbstractProductItem::setProductId()
     * @uses ESRO_Basket_AbstractProductItem::setTotalCommissions()
     * @uses ESRO_Basket_AbstractProductItem::setTotalDiscounts()
     * @uses ESRO_Basket_AbstractProductItem::setTotalInsideCommissions()
     * @uses ESRO_Basket_AbstractProductItem::setTotalPrice()
     * @uses ESRO_Basket_AbstractProductItem::setTotalTaxes()
     * @uses ESRO_Basket_AbstractProductItem::setTotalVat()
     * @param \patest\StructType\Money $priceToPay
     * @param string $priceTypeName
     * @param string $productId
     * @param \patest\StructType\Money $totalCommissions
     * @param \patest\StructType\Money $totalDiscounts
     * @param \patest\StructType\Money $totalInsideCommissions
     * @param \patest\StructType\Money $totalPrice
     * @param \patest\StructType\Money $totalTaxes
     * @param \patest\StructType\Money $totalVat
     */
    public function __construct(\patest\StructType\Money $priceToPay = null, $priceTypeName = null, $productId = null, \patest\StructType\Money $totalCommissions = null, \patest\StructType\Money $totalDiscounts = null, \patest\StructType\Money $totalInsideCommissions = null, \patest\StructType\Money $totalPrice = null, \patest\StructType\Money $totalTaxes = null, \patest\StructType\Money $totalVat = null)
    {
        $this
            ->setPriceToPay($priceToPay)
            ->setPriceTypeName($priceTypeName)
            ->setProductId($productId)
            ->setTotalCommissions($totalCommissions)
            ->setTotalDiscounts($totalDiscounts)
            ->setTotalInsideCommissions($totalInsideCommissions)
            ->setTotalPrice($totalPrice)
            ->setTotalTaxes($totalTaxes)
            ->setTotalVat($totalVat);
    }
    /**
     * Get PriceToPay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPriceToPay()
    {
        return isset($this->PriceToPay) ? $this->PriceToPay : null;
    }
    /**
     * Set PriceToPay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $priceToPay
     * @return \patest\StructType\ESRO_Basket_AbstractProductItem
     */
    public function setPriceToPay(\patest\StructType\Money $priceToPay = null)
    {
        if (is_null($priceToPay) || (is_array($priceToPay) && empty($priceToPay))) {
            unset($this->PriceToPay);
        } else {
            $this->PriceToPay = $priceToPay;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\ESRO_Basket_AbstractProductItem
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\ESRO_Basket_AbstractProductItem
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get TotalCommissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCommissions()
    {
        return isset($this->TotalCommissions) ? $this->TotalCommissions : null;
    }
    /**
     * Set TotalCommissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCommissions
     * @return \patest\StructType\ESRO_Basket_AbstractProductItem
     */
    public function setTotalCommissions(\patest\StructType\Money $totalCommissions = null)
    {
        if (is_null($totalCommissions) || (is_array($totalCommissions) && empty($totalCommissions))) {
            unset($this->TotalCommissions);
        } else {
            $this->TotalCommissions = $totalCommissions;
        }
        return $this;
    }
    /**
     * Get TotalDiscounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalDiscounts()
    {
        return isset($this->TotalDiscounts) ? $this->TotalDiscounts : null;
    }
    /**
     * Set TotalDiscounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalDiscounts
     * @return \patest\StructType\ESRO_Basket_AbstractProductItem
     */
    public function setTotalDiscounts(\patest\StructType\Money $totalDiscounts = null)
    {
        if (is_null($totalDiscounts) || (is_array($totalDiscounts) && empty($totalDiscounts))) {
            unset($this->TotalDiscounts);
        } else {
            $this->TotalDiscounts = $totalDiscounts;
        }
        return $this;
    }
    /**
     * Get TotalInsideCommissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalInsideCommissions()
    {
        return isset($this->TotalInsideCommissions) ? $this->TotalInsideCommissions : null;
    }
    /**
     * Set TotalInsideCommissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalInsideCommissions
     * @return \patest\StructType\ESRO_Basket_AbstractProductItem
     */
    public function setTotalInsideCommissions(\patest\StructType\Money $totalInsideCommissions = null)
    {
        if (is_null($totalInsideCommissions) || (is_array($totalInsideCommissions) && empty($totalInsideCommissions))) {
            unset($this->TotalInsideCommissions);
        } else {
            $this->TotalInsideCommissions = $totalInsideCommissions;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\ESRO_Basket_AbstractProductItem
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
    /**
     * Get TotalTaxes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTaxes()
    {
        return isset($this->TotalTaxes) ? $this->TotalTaxes : null;
    }
    /**
     * Set TotalTaxes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTaxes
     * @return \patest\StructType\ESRO_Basket_AbstractProductItem
     */
    public function setTotalTaxes(\patest\StructType\Money $totalTaxes = null)
    {
        if (is_null($totalTaxes) || (is_array($totalTaxes) && empty($totalTaxes))) {
            unset($this->TotalTaxes);
        } else {
            $this->TotalTaxes = $totalTaxes;
        }
        return $this;
    }
    /**
     * Get TotalVat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalVat()
    {
        return isset($this->TotalVat) ? $this->TotalVat : null;
    }
    /**
     * Set TotalVat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalVat
     * @return \patest\StructType\ESRO_Basket_AbstractProductItem
     */
    public function setTotalVat(\patest\StructType\Money $totalVat = null)
    {
        if (is_null($totalVat) || (is_array($totalVat) && empty($totalVat))) {
            unset($this->TotalVat);
        } else {
            $this->TotalVat = $totalVat;
        }
        return $this;
    }
}
