<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DynamicDataProtectionQuestionLink StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DynamicDataProtectionQuestionLink
 * @subpackage Structs
 */
class DynamicDataProtectionQuestionLink extends AbstractStructBase
{
    /**
     * The PromoterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromoterId;
    /**
     * The PromoterName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromoterName;
    /**
     * The QuestionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QuestionId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * Constructor method for DynamicDataProtectionQuestionLink
     * @uses DynamicDataProtectionQuestionLink::setPromoterId()
     * @uses DynamicDataProtectionQuestionLink::setPromoterName()
     * @uses DynamicDataProtectionQuestionLink::setQuestionId()
     * @uses DynamicDataProtectionQuestionLink::setShowId()
     * @param string $promoterId
     * @param string $promoterName
     * @param string $questionId
     * @param string $showId
     */
    public function __construct($promoterId = null, $promoterName = null, $questionId = null, $showId = null)
    {
        $this
            ->setPromoterId($promoterId)
            ->setPromoterName($promoterName)
            ->setQuestionId($questionId)
            ->setShowId($showId);
    }
    /**
     * Get PromoterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoterId()
    {
        return isset($this->PromoterId) ? $this->PromoterId : null;
    }
    /**
     * Set PromoterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoterId
     * @return \patest\StructType\DynamicDataProtectionQuestionLink
     */
    public function setPromoterId($promoterId = null)
    {
        // validation for constraint: string
        if (!is_null($promoterId) && !is_string($promoterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoterId, true), gettype($promoterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promoterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promoterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promoterId, true)), __LINE__);
        }
        if (is_null($promoterId) || (is_array($promoterId) && empty($promoterId))) {
            unset($this->PromoterId);
        } else {
            $this->PromoterId = $promoterId;
        }
        return $this;
    }
    /**
     * Get PromoterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromoterName()
    {
        return isset($this->PromoterName) ? $this->PromoterName : null;
    }
    /**
     * Set PromoterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promoterName
     * @return \patest\StructType\DynamicDataProtectionQuestionLink
     */
    public function setPromoterName($promoterName = null)
    {
        // validation for constraint: string
        if (!is_null($promoterName) && !is_string($promoterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promoterName, true), gettype($promoterName)), __LINE__);
        }
        if (is_null($promoterName) || (is_array($promoterName) && empty($promoterName))) {
            unset($this->PromoterName);
        } else {
            $this->PromoterName = $promoterName;
        }
        return $this;
    }
    /**
     * Get QuestionId value
     * @return string|null
     */
    public function getQuestionId()
    {
        return $this->QuestionId;
    }
    /**
     * Set QuestionId value
     * @param string $questionId
     * @return \patest\StructType\DynamicDataProtectionQuestionLink
     */
    public function setQuestionId($questionId = null)
    {
        // validation for constraint: string
        if (!is_null($questionId) && !is_string($questionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($questionId, true), gettype($questionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($questionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $questionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($questionId, true)), __LINE__);
        }
        $this->QuestionId = $questionId;
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\DynamicDataProtectionQuestionLink
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
}
