<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.PledgeInstallment StructType
 * @subpackage Structs
 */
class Donation_PledgeInstallment extends DistributableEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreditCardToken
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditCardToken;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDate;
    /**
     * The ExecutionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionDate;
    /**
     * The Expired
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Expired;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The FundName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FundName;
    /**
     * The InstallmentPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentPaymentMethodId;
    /**
     * The InstallmentPaymentMethodType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentPaymentMethodType;
    /**
     * The InstallmentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentStatus;
    /**
     * The InstallmentsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsType;
    /**
     * The IsAnonymous
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAnonymous;
    /**
     * The LastStatusChangeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastStatusChangeDate;
    /**
     * The MandateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateId;
    /**
     * The MandateTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateTypeId;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Number;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The NumberString
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberString;
    /**
     * The Paid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Paid;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The PledgeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PledgeId;
    /**
     * The TransactionError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionError;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Donation.PledgeInstallment
     * @uses Donation_PledgeInstallment::setAmount()
     * @uses Donation_PledgeInstallment::setClientId()
     * @uses Donation_PledgeInstallment::setCreditCardToken()
     * @uses Donation_PledgeInstallment::setDisplayName()
     * @uses Donation_PledgeInstallment::setDueDate()
     * @uses Donation_PledgeInstallment::setExecutionDate()
     * @uses Donation_PledgeInstallment::setExpired()
     * @uses Donation_PledgeInstallment::setExpiryDate()
     * @uses Donation_PledgeInstallment::setFundName()
     * @uses Donation_PledgeInstallment::setInstallmentPaymentMethodId()
     * @uses Donation_PledgeInstallment::setInstallmentPaymentMethodType()
     * @uses Donation_PledgeInstallment::setInstallmentStatus()
     * @uses Donation_PledgeInstallment::setInstallmentsType()
     * @uses Donation_PledgeInstallment::setIsAnonymous()
     * @uses Donation_PledgeInstallment::setLastStatusChangeDate()
     * @uses Donation_PledgeInstallment::setMandateId()
     * @uses Donation_PledgeInstallment::setMandateTypeId()
     * @uses Donation_PledgeInstallment::setNote()
     * @uses Donation_PledgeInstallment::setNumber()
     * @uses Donation_PledgeInstallment::setNumberOfInstallments()
     * @uses Donation_PledgeInstallment::setNumberString()
     * @uses Donation_PledgeInstallment::setPaid()
     * @uses Donation_PledgeInstallment::setPaymentStatus()
     * @uses Donation_PledgeInstallment::setPledgeId()
     * @uses Donation_PledgeInstallment::setTransactionError()
     * @uses Donation_PledgeInstallment::setTransactionGuid()
     * @uses Donation_PledgeInstallment::setTransactionNumber()
     * @param \patest\StructType\Money $amount
     * @param string $clientId
     * @param string $creditCardToken
     * @param string $displayName
     * @param string $dueDate
     * @param string $executionDate
     * @param bool $expired
     * @param string $expiryDate
     * @param \patest\StructType\GlobalString $fundName
     * @param string $installmentPaymentMethodId
     * @param string $installmentPaymentMethodType
     * @param string $installmentStatus
     * @param string $installmentsType
     * @param bool $isAnonymous
     * @param string $lastStatusChangeDate
     * @param string $mandateId
     * @param string $mandateTypeId
     * @param string $note
     * @param int $number
     * @param int $numberOfInstallments
     * @param string $numberString
     * @param bool $paid
     * @param string $paymentStatus
     * @param string $pledgeId
     * @param string $transactionError
     * @param string $transactionGuid
     * @param int $transactionNumber
     */
    public function __construct(\patest\StructType\Money $amount = null, $clientId = null, $creditCardToken = null, $displayName = null, $dueDate = null, $executionDate = null, $expired = null, $expiryDate = null, \patest\StructType\GlobalString $fundName = null, $installmentPaymentMethodId = null, $installmentPaymentMethodType = null, $installmentStatus = null, $installmentsType = null, $isAnonymous = null, $lastStatusChangeDate = null, $mandateId = null, $mandateTypeId = null, $note = null, $number = null, $numberOfInstallments = null, $numberString = null, $paid = null, $paymentStatus = null, $pledgeId = null, $transactionError = null, $transactionGuid = null, $transactionNumber = null)
    {
        $this
            ->setAmount($amount)
            ->setClientId($clientId)
            ->setCreditCardToken($creditCardToken)
            ->setDisplayName($displayName)
            ->setDueDate($dueDate)
            ->setExecutionDate($executionDate)
            ->setExpired($expired)
            ->setExpiryDate($expiryDate)
            ->setFundName($fundName)
            ->setInstallmentPaymentMethodId($installmentPaymentMethodId)
            ->setInstallmentPaymentMethodType($installmentPaymentMethodType)
            ->setInstallmentStatus($installmentStatus)
            ->setInstallmentsType($installmentsType)
            ->setIsAnonymous($isAnonymous)
            ->setLastStatusChangeDate($lastStatusChangeDate)
            ->setMandateId($mandateId)
            ->setMandateTypeId($mandateTypeId)
            ->setNote($note)
            ->setNumber($number)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setNumberString($numberString)
            ->setPaid($paid)
            ->setPaymentStatus($paymentStatus)
            ->setPledgeId($pledgeId)
            ->setTransactionError($transactionError)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreditCardToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditCardToken()
    {
        return isset($this->CreditCardToken) ? $this->CreditCardToken : null;
    }
    /**
     * Set CreditCardToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditCardToken
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setCreditCardToken($creditCardToken = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardToken) && !is_string($creditCardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardToken, true), gettype($creditCardToken)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditCardToken) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditCardToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditCardToken, true)), __LINE__);
        }
        if (is_null($creditCardToken) || (is_array($creditCardToken) && empty($creditCardToken))) {
            unset($this->CreditCardToken);
        } else {
            $this->CreditCardToken = $creditCardToken;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDate
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get ExecutionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionDate()
    {
        return isset($this->ExecutionDate) ? $this->ExecutionDate : null;
    }
    /**
     * Set ExecutionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionDate
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setExecutionDate($executionDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionDate) && !is_string($executionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDate, true), gettype($executionDate)), __LINE__);
        }
        if (is_null($executionDate) || (is_array($executionDate) && empty($executionDate))) {
            unset($this->ExecutionDate);
        } else {
            $this->ExecutionDate = $executionDate;
        }
        return $this;
    }
    /**
     * Get Expired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExpired()
    {
        return isset($this->Expired) ? $this->Expired : null;
    }
    /**
     * Set Expired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $expired
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setExpired($expired = null)
    {
        // validation for constraint: boolean
        if (!is_null($expired) && !is_bool($expired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expired, true), gettype($expired)), __LINE__);
        }
        if (is_null($expired) || (is_array($expired) && empty($expired))) {
            unset($this->Expired);
        } else {
            $this->Expired = $expired;
        }
        return $this;
    }
    /**
     * Get ExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDate()
    {
        return isset($this->ExpiryDate) ? $this->ExpiryDate : null;
    }
    /**
     * Set ExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDate
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        if (is_null($expiryDate) || (is_array($expiryDate) && empty($expiryDate))) {
            unset($this->ExpiryDate);
        } else {
            $this->ExpiryDate = $expiryDate;
        }
        return $this;
    }
    /**
     * Get FundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFundName()
    {
        return isset($this->FundName) ? $this->FundName : null;
    }
    /**
     * Set FundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $fundName
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setFundName(\patest\StructType\GlobalString $fundName = null)
    {
        if (is_null($fundName) || (is_array($fundName) && empty($fundName))) {
            unset($this->FundName);
        } else {
            $this->FundName = $fundName;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentMethodId()
    {
        return isset($this->InstallmentPaymentMethodId) ? $this->InstallmentPaymentMethodId : null;
    }
    /**
     * Set InstallmentPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentPaymentMethodId
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setInstallmentPaymentMethodId($installmentPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentPaymentMethodId) && !is_string($installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentPaymentMethodId, true), gettype($installmentPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentPaymentMethodId, true)), __LINE__);
        }
        if (is_null($installmentPaymentMethodId) || (is_array($installmentPaymentMethodId) && empty($installmentPaymentMethodId))) {
            unset($this->InstallmentPaymentMethodId);
        } else {
            $this->InstallmentPaymentMethodId = $installmentPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentMethodType()
    {
        return isset($this->InstallmentPaymentMethodType) ? $this->InstallmentPaymentMethodType : null;
    }
    /**
     * Set InstallmentPaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentPaymentMethodType
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setInstallmentPaymentMethodType($installmentPaymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($installmentPaymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($installmentPaymentMethodType) ? implode(', ', $installmentPaymentMethodType) : var_export($installmentPaymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($installmentPaymentMethodType) || (is_array($installmentPaymentMethodType) && empty($installmentPaymentMethodType))) {
            unset($this->InstallmentPaymentMethodType);
        } else {
            $this->InstallmentPaymentMethodType = $installmentPaymentMethodType;
        }
        return $this;
    }
    /**
     * Get InstallmentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentStatus()
    {
        return isset($this->InstallmentStatus) ? $this->InstallmentStatus : null;
    }
    /**
     * Set InstallmentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PledgeInstallmentStatus::valueIsValid()
     * @uses \patest\EnumType\PledgeInstallmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentStatus
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setInstallmentStatus($installmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PledgeInstallmentStatus::valueIsValid($installmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PledgeInstallmentStatus', is_array($installmentStatus) ? implode(', ', $installmentStatus) : var_export($installmentStatus, true), implode(', ', \patest\EnumType\PledgeInstallmentStatus::getValidValues())), __LINE__);
        }
        if (is_null($installmentStatus) || (is_array($installmentStatus) && empty($installmentStatus))) {
            unset($this->InstallmentStatus);
        } else {
            $this->InstallmentStatus = $installmentStatus;
        }
        return $this;
    }
    /**
     * Get InstallmentsType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsType()
    {
        return isset($this->InstallmentsType) ? $this->InstallmentsType : null;
    }
    /**
     * Set InstallmentsType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PledgeInstallmentsType::valueIsValid()
     * @uses \patest\EnumType\PledgeInstallmentsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsType
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setInstallmentsType($installmentsType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PledgeInstallmentsType::valueIsValid($installmentsType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PledgeInstallmentsType', is_array($installmentsType) ? implode(', ', $installmentsType) : var_export($installmentsType, true), implode(', ', \patest\EnumType\PledgeInstallmentsType::getValidValues())), __LINE__);
        }
        if (is_null($installmentsType) || (is_array($installmentsType) && empty($installmentsType))) {
            unset($this->InstallmentsType);
        } else {
            $this->InstallmentsType = $installmentsType;
        }
        return $this;
    }
    /**
     * Get IsAnonymous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAnonymous()
    {
        return isset($this->IsAnonymous) ? $this->IsAnonymous : null;
    }
    /**
     * Set IsAnonymous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAnonymous
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setIsAnonymous($isAnonymous = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAnonymous) && !is_bool($isAnonymous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAnonymous, true), gettype($isAnonymous)), __LINE__);
        }
        if (is_null($isAnonymous) || (is_array($isAnonymous) && empty($isAnonymous))) {
            unset($this->IsAnonymous);
        } else {
            $this->IsAnonymous = $isAnonymous;
        }
        return $this;
    }
    /**
     * Get LastStatusChangeDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastStatusChangeDate()
    {
        return isset($this->LastStatusChangeDate) ? $this->LastStatusChangeDate : null;
    }
    /**
     * Set LastStatusChangeDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastStatusChangeDate
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setLastStatusChangeDate($lastStatusChangeDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastStatusChangeDate) && !is_string($lastStatusChangeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastStatusChangeDate, true), gettype($lastStatusChangeDate)), __LINE__);
        }
        if (is_null($lastStatusChangeDate) || (is_array($lastStatusChangeDate) && empty($lastStatusChangeDate))) {
            unset($this->LastStatusChangeDate);
        } else {
            $this->LastStatusChangeDate = $lastStatusChangeDate;
        }
        return $this;
    }
    /**
     * Get MandateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateId()
    {
        return isset($this->MandateId) ? $this->MandateId : null;
    }
    /**
     * Set MandateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateId
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setMandateId($mandateId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateId) && !is_string($mandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateId, true), gettype($mandateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateId, true)), __LINE__);
        }
        if (is_null($mandateId) || (is_array($mandateId) && empty($mandateId))) {
            unset($this->MandateId);
        } else {
            $this->MandateId = $mandateId;
        }
        return $this;
    }
    /**
     * Get MandateTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateTypeId()
    {
        return isset($this->MandateTypeId) ? $this->MandateTypeId : null;
    }
    /**
     * Set MandateTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateTypeId
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setMandateTypeId($mandateTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeId) && !is_string($mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeId, true), gettype($mandateTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateTypeId, true)), __LINE__);
        }
        if (is_null($mandateTypeId) || (is_array($mandateTypeId) && empty($mandateTypeId))) {
            unset($this->MandateTypeId);
        } else {
            $this->MandateTypeId = $mandateTypeId;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $number
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return isset($this->NumberOfInstallments) ? $this->NumberOfInstallments : null;
    }
    /**
     * Set NumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfInstallments
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        if (is_null($numberOfInstallments) || (is_array($numberOfInstallments) && empty($numberOfInstallments))) {
            unset($this->NumberOfInstallments);
        } else {
            $this->NumberOfInstallments = $numberOfInstallments;
        }
        return $this;
    }
    /**
     * Get NumberString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberString()
    {
        return isset($this->NumberString) ? $this->NumberString : null;
    }
    /**
     * Set NumberString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberString
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setNumberString($numberString = null)
    {
        // validation for constraint: string
        if (!is_null($numberString) && !is_string($numberString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberString, true), gettype($numberString)), __LINE__);
        }
        if (is_null($numberString) || (is_array($numberString) && empty($numberString))) {
            unset($this->NumberString);
        } else {
            $this->NumberString = $numberString;
        }
        return $this;
    }
    /**
     * Get Paid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPaid()
    {
        return isset($this->Paid) ? $this->Paid : null;
    }
    /**
     * Set Paid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $paid
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setPaid($paid = null)
    {
        // validation for constraint: boolean
        if (!is_null($paid) && !is_bool($paid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paid, true), gettype($paid)), __LINE__);
        }
        if (is_null($paid) || (is_array($paid) && empty($paid))) {
            unset($this->Paid);
        } else {
            $this->Paid = $paid;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get PledgeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPledgeId()
    {
        return isset($this->PledgeId) ? $this->PledgeId : null;
    }
    /**
     * Set PledgeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pledgeId
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setPledgeId($pledgeId = null)
    {
        // validation for constraint: string
        if (!is_null($pledgeId) && !is_string($pledgeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pledgeId, true), gettype($pledgeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($pledgeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $pledgeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($pledgeId, true)), __LINE__);
        }
        if (is_null($pledgeId) || (is_array($pledgeId) && empty($pledgeId))) {
            unset($this->PledgeId);
        } else {
            $this->PledgeId = $pledgeId;
        }
        return $this;
    }
    /**
     * Get TransactionError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionError()
    {
        return isset($this->TransactionError) ? $this->TransactionError : null;
    }
    /**
     * Set TransactionError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionError
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setTransactionError($transactionError = null)
    {
        // validation for constraint: string
        if (!is_null($transactionError) && !is_string($transactionError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionError, true), gettype($transactionError)), __LINE__);
        }
        if (is_null($transactionError) || (is_array($transactionError) && empty($transactionError))) {
            unset($this->TransactionError);
        } else {
            $this->TransactionError = $transactionError;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Donation_PledgeInstallment
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
