<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.MatchingGiftRelationPair StructType
 * @subpackage Structs
 */
class Donation_MatchingGiftRelationPair extends AnyEntity
{
    /**
     * The MatcherRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MatcherRoleId;
    /**
     * The RecipientRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RecipientRoleId;
    /**
     * The RelationshipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipId;
    /**
     * Constructor method for Donation.MatchingGiftRelationPair
     * @uses Donation_MatchingGiftRelationPair::setMatcherRoleId()
     * @uses Donation_MatchingGiftRelationPair::setRecipientRoleId()
     * @uses Donation_MatchingGiftRelationPair::setRelationshipId()
     * @param string $matcherRoleId
     * @param string $recipientRoleId
     * @param string $relationshipId
     */
    public function __construct($matcherRoleId = null, $recipientRoleId = null, $relationshipId = null)
    {
        $this
            ->setMatcherRoleId($matcherRoleId)
            ->setRecipientRoleId($recipientRoleId)
            ->setRelationshipId($relationshipId);
    }
    /**
     * Get MatcherRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatcherRoleId()
    {
        return isset($this->MatcherRoleId) ? $this->MatcherRoleId : null;
    }
    /**
     * Set MatcherRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matcherRoleId
     * @return \patest\StructType\Donation_MatchingGiftRelationPair
     */
    public function setMatcherRoleId($matcherRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($matcherRoleId) && !is_string($matcherRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matcherRoleId, true), gettype($matcherRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($matcherRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $matcherRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($matcherRoleId, true)), __LINE__);
        }
        if (is_null($matcherRoleId) || (is_array($matcherRoleId) && empty($matcherRoleId))) {
            unset($this->MatcherRoleId);
        } else {
            $this->MatcherRoleId = $matcherRoleId;
        }
        return $this;
    }
    /**
     * Get RecipientRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecipientRoleId()
    {
        return isset($this->RecipientRoleId) ? $this->RecipientRoleId : null;
    }
    /**
     * Set RecipientRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recipientRoleId
     * @return \patest\StructType\Donation_MatchingGiftRelationPair
     */
    public function setRecipientRoleId($recipientRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($recipientRoleId) && !is_string($recipientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientRoleId, true), gettype($recipientRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($recipientRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $recipientRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($recipientRoleId, true)), __LINE__);
        }
        if (is_null($recipientRoleId) || (is_array($recipientRoleId) && empty($recipientRoleId))) {
            unset($this->RecipientRoleId);
        } else {
            $this->RecipientRoleId = $recipientRoleId;
        }
        return $this;
    }
    /**
     * Get RelationshipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipId()
    {
        return isset($this->RelationshipId) ? $this->RelationshipId : null;
    }
    /**
     * Set RelationshipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipId
     * @return \patest\StructType\Donation_MatchingGiftRelationPair
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        if (is_null($relationshipId) || (is_array($relationshipId) && empty($relationshipId))) {
            unset($this->RelationshipId);
        } else {
            $this->RelationshipId = $relationshipId;
        }
        return $this;
    }
}
