<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.MatchingGiftBatch StructType
 * @subpackage Structs
 */
class Donation_MatchingGiftBatch extends Donation_Base
{
    /**
     * The BilledState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BilledState;
    /**
     * The DonationTotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DonationTotalAmount;
    /**
     * The ExecutionState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionState;
    /**
     * The From
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $From;
    /**
     * The MatchAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MatchAmount;
    /**
     * The NumberOfDonations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfDonations;
    /**
     * The NumberOfMatchingClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfMatchingClients;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PaidAmount;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $To;
    /**
     * The Units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfDonation_MatchingGiftBatchUnit
     */
    public $Units;
    /**
     * Constructor method for Donation.MatchingGiftBatch
     * @uses Donation_MatchingGiftBatch::setBilledState()
     * @uses Donation_MatchingGiftBatch::setDonationTotalAmount()
     * @uses Donation_MatchingGiftBatch::setExecutionState()
     * @uses Donation_MatchingGiftBatch::setFrom()
     * @uses Donation_MatchingGiftBatch::setMatchAmount()
     * @uses Donation_MatchingGiftBatch::setNumberOfDonations()
     * @uses Donation_MatchingGiftBatch::setNumberOfMatchingClients()
     * @uses Donation_MatchingGiftBatch::setPaidAmount()
     * @uses Donation_MatchingGiftBatch::setTo()
     * @uses Donation_MatchingGiftBatch::setUnits()
     * @param string $billedState
     * @param float $donationTotalAmount
     * @param string $executionState
     * @param string $from
     * @param float $matchAmount
     * @param int $numberOfDonations
     * @param int $numberOfMatchingClients
     * @param float $paidAmount
     * @param string $to
     * @param \patest\StructType\RecordSetOfDonation_MatchingGiftBatchUnit $units
     */
    public function __construct($billedState = null, $donationTotalAmount = null, $executionState = null, $from = null, $matchAmount = null, $numberOfDonations = null, $numberOfMatchingClients = null, $paidAmount = null, $to = null, \patest\StructType\RecordSetOfDonation_MatchingGiftBatchUnit $units = null)
    {
        $this
            ->setBilledState($billedState)
            ->setDonationTotalAmount($donationTotalAmount)
            ->setExecutionState($executionState)
            ->setFrom($from)
            ->setMatchAmount($matchAmount)
            ->setNumberOfDonations($numberOfDonations)
            ->setNumberOfMatchingClients($numberOfMatchingClients)
            ->setPaidAmount($paidAmount)
            ->setTo($to)
            ->setUnits($units);
    }
    /**
     * Get BilledState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBilledState()
    {
        return isset($this->BilledState) ? $this->BilledState : null;
    }
    /**
     * Set BilledState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MatchingGiftBillState::valueIsValid()
     * @uses \patest\EnumType\MatchingGiftBillState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $billedState
     * @return \patest\StructType\Donation_MatchingGiftBatch
     */
    public function setBilledState($billedState = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MatchingGiftBillState::valueIsValid($billedState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MatchingGiftBillState', is_array($billedState) ? implode(', ', $billedState) : var_export($billedState, true), implode(', ', \patest\EnumType\MatchingGiftBillState::getValidValues())), __LINE__);
        }
        if (is_null($billedState) || (is_array($billedState) && empty($billedState))) {
            unset($this->BilledState);
        } else {
            $this->BilledState = $billedState;
        }
        return $this;
    }
    /**
     * Get DonationTotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDonationTotalAmount()
    {
        return isset($this->DonationTotalAmount) ? $this->DonationTotalAmount : null;
    }
    /**
     * Set DonationTotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $donationTotalAmount
     * @return \patest\StructType\Donation_MatchingGiftBatch
     */
    public function setDonationTotalAmount($donationTotalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($donationTotalAmount) && !(is_float($donationTotalAmount) || is_numeric($donationTotalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($donationTotalAmount, true), gettype($donationTotalAmount)), __LINE__);
        }
        if (is_null($donationTotalAmount) || (is_array($donationTotalAmount) && empty($donationTotalAmount))) {
            unset($this->DonationTotalAmount);
        } else {
            $this->DonationTotalAmount = $donationTotalAmount;
        }
        return $this;
    }
    /**
     * Get ExecutionState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionState()
    {
        return isset($this->ExecutionState) ? $this->ExecutionState : null;
    }
    /**
     * Set ExecutionState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchExecutionState::valueIsValid()
     * @uses \patest\EnumType\BatchExecutionState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $executionState
     * @return \patest\StructType\Donation_MatchingGiftBatch
     */
    public function setExecutionState($executionState = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchExecutionState::valueIsValid($executionState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchExecutionState', is_array($executionState) ? implode(', ', $executionState) : var_export($executionState, true), implode(', ', \patest\EnumType\BatchExecutionState::getValidValues())), __LINE__);
        }
        if (is_null($executionState) || (is_array($executionState) && empty($executionState))) {
            unset($this->ExecutionState);
        } else {
            $this->ExecutionState = $executionState;
        }
        return $this;
    }
    /**
     * Get From value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrom()
    {
        return isset($this->From) ? $this->From : null;
    }
    /**
     * Set From value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $from
     * @return \patest\StructType\Donation_MatchingGiftBatch
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        if (is_null($from) || (is_array($from) && empty($from))) {
            unset($this->From);
        } else {
            $this->From = $from;
        }
        return $this;
    }
    /**
     * Get MatchAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMatchAmount()
    {
        return isset($this->MatchAmount) ? $this->MatchAmount : null;
    }
    /**
     * Set MatchAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $matchAmount
     * @return \patest\StructType\Donation_MatchingGiftBatch
     */
    public function setMatchAmount($matchAmount = null)
    {
        // validation for constraint: float
        if (!is_null($matchAmount) && !(is_float($matchAmount) || is_numeric($matchAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($matchAmount, true), gettype($matchAmount)), __LINE__);
        }
        if (is_null($matchAmount) || (is_array($matchAmount) && empty($matchAmount))) {
            unset($this->MatchAmount);
        } else {
            $this->MatchAmount = $matchAmount;
        }
        return $this;
    }
    /**
     * Get NumberOfDonations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfDonations()
    {
        return isset($this->NumberOfDonations) ? $this->NumberOfDonations : null;
    }
    /**
     * Set NumberOfDonations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfDonations
     * @return \patest\StructType\Donation_MatchingGiftBatch
     */
    public function setNumberOfDonations($numberOfDonations = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDonations) && !(is_int($numberOfDonations) || ctype_digit($numberOfDonations))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDonations, true), gettype($numberOfDonations)), __LINE__);
        }
        if (is_null($numberOfDonations) || (is_array($numberOfDonations) && empty($numberOfDonations))) {
            unset($this->NumberOfDonations);
        } else {
            $this->NumberOfDonations = $numberOfDonations;
        }
        return $this;
    }
    /**
     * Get NumberOfMatchingClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfMatchingClients()
    {
        return isset($this->NumberOfMatchingClients) ? $this->NumberOfMatchingClients : null;
    }
    /**
     * Set NumberOfMatchingClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfMatchingClients
     * @return \patest\StructType\Donation_MatchingGiftBatch
     */
    public function setNumberOfMatchingClients($numberOfMatchingClients = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfMatchingClients) && !(is_int($numberOfMatchingClients) || ctype_digit($numberOfMatchingClients))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfMatchingClients, true), gettype($numberOfMatchingClients)), __LINE__);
        }
        if (is_null($numberOfMatchingClients) || (is_array($numberOfMatchingClients) && empty($numberOfMatchingClients))) {
            unset($this->NumberOfMatchingClients);
        } else {
            $this->NumberOfMatchingClients = $numberOfMatchingClients;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $paidAmount
     * @return \patest\StructType\Donation_MatchingGiftBatch
     */
    public function setPaidAmount($paidAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paidAmount) && !(is_float($paidAmount) || is_numeric($paidAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paidAmount, true), gettype($paidAmount)), __LINE__);
        }
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get To value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTo()
    {
        return isset($this->To) ? $this->To : null;
    }
    /**
     * Set To value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $to
     * @return \patest\StructType\Donation_MatchingGiftBatch
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        if (is_null($to) || (is_array($to) && empty($to))) {
            unset($this->To);
        } else {
            $this->To = $to;
        }
        return $this;
    }
    /**
     * Get Units value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfDonation_MatchingGiftBatchUnit|null
     */
    public function getUnits()
    {
        return isset($this->Units) ? $this->Units : null;
    }
    /**
     * Set Units value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfDonation_MatchingGiftBatchUnit $units
     * @return \patest\StructType\Donation_MatchingGiftBatch
     */
    public function setUnits(\patest\StructType\RecordSetOfDonation_MatchingGiftBatchUnit $units = null)
    {
        if (is_null($units) || (is_array($units) && empty($units))) {
            unset($this->Units);
        } else {
            $this->Units = $units;
        }
        return $this;
    }
}
