<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.DonationSearchItem StructType
 * @subpackage Structs
 */
class Donation_DonationSearchItem extends Donation_DonationProductItem
{
    /**
     * The DonationName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DonationName;
    /**
     * The FundName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FundName;
    /**
     * Constructor method for Donation.DonationSearchItem
     * @uses Donation_DonationSearchItem::setDonationName()
     * @uses Donation_DonationSearchItem::setFundName()
     * @param \patest\StructType\GlobalString $donationName
     * @param \patest\StructType\GlobalString $fundName
     */
    public function __construct(\patest\StructType\GlobalString $donationName = null, \patest\StructType\GlobalString $fundName = null)
    {
        $this
            ->setDonationName($donationName)
            ->setFundName($fundName);
    }
    /**
     * Get DonationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDonationName()
    {
        return isset($this->DonationName) ? $this->DonationName : null;
    }
    /**
     * Set DonationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $donationName
     * @return \patest\StructType\Donation_DonationSearchItem
     */
    public function setDonationName(\patest\StructType\GlobalString $donationName = null)
    {
        if (is_null($donationName) || (is_array($donationName) && empty($donationName))) {
            unset($this->DonationName);
        } else {
            $this->DonationName = $donationName;
        }
        return $this;
    }
    /**
     * Get FundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFundName()
    {
        return isset($this->FundName) ? $this->FundName : null;
    }
    /**
     * Set FundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $fundName
     * @return \patest\StructType\Donation_DonationSearchItem
     */
    public function setFundName(\patest\StructType\GlobalString $fundName = null)
    {
        if (is_null($fundName) || (is_array($fundName) && empty($fundName))) {
            unset($this->FundName);
        } else {
            $this->FundName = $fundName;
        }
        return $this;
    }
}
