<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Donation.AddDonationToBasketRequest StructType
 * @subpackage Structs
 */
class Donation_AddDonationToBasketRequest extends AnyEntity
{
    /**
     * The AmountType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AmountType;
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The ChannelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChannelId;
    /**
     * The DonationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationDate;
    /**
     * The DonationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DonationId;
    /**
     * The FundId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FundId;
    /**
     * The GenerateTaxLetter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateTaxLetter;
    /**
     * The GenerateThankYouLetter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateThankYouLetter;
    /**
     * The GiftDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftDescription;
    /**
     * The GiftType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftType;
    /**
     * The IsAnonymous
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAnonymous;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The NameOnDonation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameOnDonation;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notification;
    /**
     * The PersonToTribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonToTribute;
    /**
     * The ThankYouLetterSpecialMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThankYouLetterSpecialMessage;
    /**
     * The TributeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeType;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * Constructor method for Donation.AddDonationToBasketRequest
     * @uses Donation_AddDonationToBasketRequest::setAmountType()
     * @uses Donation_AddDonationToBasketRequest::setAppealId()
     * @uses Donation_AddDonationToBasketRequest::setCampaignId()
     * @uses Donation_AddDonationToBasketRequest::setChannelId()
     * @uses Donation_AddDonationToBasketRequest::setDonationDate()
     * @uses Donation_AddDonationToBasketRequest::setDonationId()
     * @uses Donation_AddDonationToBasketRequest::setFundId()
     * @uses Donation_AddDonationToBasketRequest::setGenerateTaxLetter()
     * @uses Donation_AddDonationToBasketRequest::setGenerateThankYouLetter()
     * @uses Donation_AddDonationToBasketRequest::setGiftDescription()
     * @uses Donation_AddDonationToBasketRequest::setGiftType()
     * @uses Donation_AddDonationToBasketRequest::setIsAnonymous()
     * @uses Donation_AddDonationToBasketRequest::setMessage()
     * @uses Donation_AddDonationToBasketRequest::setNameOnDonation()
     * @uses Donation_AddDonationToBasketRequest::setNotification()
     * @uses Donation_AddDonationToBasketRequest::setPersonToTribute()
     * @uses Donation_AddDonationToBasketRequest::setThankYouLetterSpecialMessage()
     * @uses Donation_AddDonationToBasketRequest::setTributeType()
     * @uses Donation_AddDonationToBasketRequest::setValue()
     * @param string $amountType
     * @param string $appealId
     * @param string $campaignId
     * @param string $channelId
     * @param string $donationDate
     * @param string $donationId
     * @param string $fundId
     * @param bool $generateTaxLetter
     * @param bool $generateThankYouLetter
     * @param string $giftDescription
     * @param string $giftType
     * @param bool $isAnonymous
     * @param string $message
     * @param string $nameOnDonation
     * @param string $notification
     * @param string $personToTribute
     * @param string $thankYouLetterSpecialMessage
     * @param string $tributeType
     * @param float $value
     */
    public function __construct($amountType = null, $appealId = null, $campaignId = null, $channelId = null, $donationDate = null, $donationId = null, $fundId = null, $generateTaxLetter = null, $generateThankYouLetter = null, $giftDescription = null, $giftType = null, $isAnonymous = null, $message = null, $nameOnDonation = null, $notification = null, $personToTribute = null, $thankYouLetterSpecialMessage = null, $tributeType = null, $value = null)
    {
        $this
            ->setAmountType($amountType)
            ->setAppealId($appealId)
            ->setCampaignId($campaignId)
            ->setChannelId($channelId)
            ->setDonationDate($donationDate)
            ->setDonationId($donationId)
            ->setFundId($fundId)
            ->setGenerateTaxLetter($generateTaxLetter)
            ->setGenerateThankYouLetter($generateThankYouLetter)
            ->setGiftDescription($giftDescription)
            ->setGiftType($giftType)
            ->setIsAnonymous($isAnonymous)
            ->setMessage($message)
            ->setNameOnDonation($nameOnDonation)
            ->setNotification($notification)
            ->setPersonToTribute($personToTribute)
            ->setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage)
            ->setTributeType($tributeType)
            ->setValue($value);
    }
    /**
     * Get AmountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountType()
    {
        return isset($this->AmountType) ? $this->AmountType : null;
    }
    /**
     * Set AmountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AmountType::valueIsValid()
     * @uses \patest\EnumType\AmountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amountType
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setAmountType($amountType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AmountType::valueIsValid($amountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AmountType', is_array($amountType) ? implode(', ', $amountType) : var_export($amountType, true), implode(', ', \patest\EnumType\AmountType::getValidValues())), __LINE__);
        }
        if (is_null($amountType) || (is_array($amountType) && empty($amountType))) {
            unset($this->AmountType);
        } else {
            $this->AmountType = $amountType;
        }
        return $this;
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get ChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannelId()
    {
        return isset($this->ChannelId) ? $this->ChannelId : null;
    }
    /**
     * Set ChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channelId
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelId, true), gettype($channelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($channelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($channelId, true)), __LINE__);
        }
        if (is_null($channelId) || (is_array($channelId) && empty($channelId))) {
            unset($this->ChannelId);
        } else {
            $this->ChannelId = $channelId;
        }
        return $this;
    }
    /**
     * Get DonationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationDate()
    {
        return isset($this->DonationDate) ? $this->DonationDate : null;
    }
    /**
     * Set DonationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationDate
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setDonationDate($donationDate = null)
    {
        // validation for constraint: string
        if (!is_null($donationDate) && !is_string($donationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationDate, true), gettype($donationDate)), __LINE__);
        }
        if (is_null($donationDate) || (is_array($donationDate) && empty($donationDate))) {
            unset($this->DonationDate);
        } else {
            $this->DonationDate = $donationDate;
        }
        return $this;
    }
    /**
     * Get DonationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationId()
    {
        return isset($this->DonationId) ? $this->DonationId : null;
    }
    /**
     * Set DonationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationId
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setDonationId($donationId = null)
    {
        // validation for constraint: string
        if (!is_null($donationId) && !is_string($donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationId, true), gettype($donationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($donationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($donationId, true)), __LINE__);
        }
        if (is_null($donationId) || (is_array($donationId) && empty($donationId))) {
            unset($this->DonationId);
        } else {
            $this->DonationId = $donationId;
        }
        return $this;
    }
    /**
     * Get FundId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFundId()
    {
        return isset($this->FundId) ? $this->FundId : null;
    }
    /**
     * Set FundId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fundId
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setFundId($fundId = null)
    {
        // validation for constraint: string
        if (!is_null($fundId) && !is_string($fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundId, true), gettype($fundId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fundId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fundId, true)), __LINE__);
        }
        if (is_null($fundId) || (is_array($fundId) && empty($fundId))) {
            unset($this->FundId);
        } else {
            $this->FundId = $fundId;
        }
        return $this;
    }
    /**
     * Get GenerateTaxLetter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateTaxLetter()
    {
        return isset($this->GenerateTaxLetter) ? $this->GenerateTaxLetter : null;
    }
    /**
     * Set GenerateTaxLetter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateTaxLetter
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setGenerateTaxLetter($generateTaxLetter = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateTaxLetter) && !is_bool($generateTaxLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateTaxLetter, true), gettype($generateTaxLetter)), __LINE__);
        }
        if (is_null($generateTaxLetter) || (is_array($generateTaxLetter) && empty($generateTaxLetter))) {
            unset($this->GenerateTaxLetter);
        } else {
            $this->GenerateTaxLetter = $generateTaxLetter;
        }
        return $this;
    }
    /**
     * Get GenerateThankYouLetter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateThankYouLetter()
    {
        return isset($this->GenerateThankYouLetter) ? $this->GenerateThankYouLetter : null;
    }
    /**
     * Set GenerateThankYouLetter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateThankYouLetter
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setGenerateThankYouLetter($generateThankYouLetter = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateThankYouLetter) && !is_bool($generateThankYouLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateThankYouLetter, true), gettype($generateThankYouLetter)), __LINE__);
        }
        if (is_null($generateThankYouLetter) || (is_array($generateThankYouLetter) && empty($generateThankYouLetter))) {
            unset($this->GenerateThankYouLetter);
        } else {
            $this->GenerateThankYouLetter = $generateThankYouLetter;
        }
        return $this;
    }
    /**
     * Get GiftDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftDescription()
    {
        return isset($this->GiftDescription) ? $this->GiftDescription : null;
    }
    /**
     * Set GiftDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftDescription
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setGiftDescription($giftDescription = null)
    {
        // validation for constraint: string
        if (!is_null($giftDescription) && !is_string($giftDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftDescription, true), gettype($giftDescription)), __LINE__);
        }
        if (is_null($giftDescription) || (is_array($giftDescription) && empty($giftDescription))) {
            unset($this->GiftDescription);
        } else {
            $this->GiftDescription = $giftDescription;
        }
        return $this;
    }
    /**
     * Get GiftType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftType()
    {
        return isset($this->GiftType) ? $this->GiftType : null;
    }
    /**
     * Set GiftType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GiftType::valueIsValid()
     * @uses \patest\EnumType\GiftType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $giftType
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setGiftType($giftType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftType::valueIsValid($giftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftType', is_array($giftType) ? implode(', ', $giftType) : var_export($giftType, true), implode(', ', \patest\EnumType\GiftType::getValidValues())), __LINE__);
        }
        if (is_null($giftType) || (is_array($giftType) && empty($giftType))) {
            unset($this->GiftType);
        } else {
            $this->GiftType = $giftType;
        }
        return $this;
    }
    /**
     * Get IsAnonymous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAnonymous()
    {
        return isset($this->IsAnonymous) ? $this->IsAnonymous : null;
    }
    /**
     * Set IsAnonymous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAnonymous
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setIsAnonymous($isAnonymous = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAnonymous) && !is_bool($isAnonymous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAnonymous, true), gettype($isAnonymous)), __LINE__);
        }
        if (is_null($isAnonymous) || (is_array($isAnonymous) && empty($isAnonymous))) {
            unset($this->IsAnonymous);
        } else {
            $this->IsAnonymous = $isAnonymous;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get NameOnDonation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameOnDonation()
    {
        return isset($this->NameOnDonation) ? $this->NameOnDonation : null;
    }
    /**
     * Set NameOnDonation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameOnDonation
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setNameOnDonation($nameOnDonation = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnDonation) && !is_string($nameOnDonation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOnDonation, true), gettype($nameOnDonation)), __LINE__);
        }
        if (is_null($nameOnDonation) || (is_array($nameOnDonation) && empty($nameOnDonation))) {
            unset($this->NameOnDonation);
        } else {
            $this->NameOnDonation = $nameOnDonation;
        }
        return $this;
    }
    /**
     * Get Notification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotification()
    {
        return isset($this->Notification) ? $this->Notification : null;
    }
    /**
     * Set Notification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notification
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setNotification($notification = null)
    {
        // validation for constraint: string
        if (!is_null($notification) && !is_string($notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notification, true), gettype($notification)), __LINE__);
        }
        if (is_null($notification) || (is_array($notification) && empty($notification))) {
            unset($this->Notification);
        } else {
            $this->Notification = $notification;
        }
        return $this;
    }
    /**
     * Get PersonToTribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonToTribute()
    {
        return isset($this->PersonToTribute) ? $this->PersonToTribute : null;
    }
    /**
     * Set PersonToTribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personToTribute
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setPersonToTribute($personToTribute = null)
    {
        // validation for constraint: string
        if (!is_null($personToTribute) && !is_string($personToTribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personToTribute, true), gettype($personToTribute)), __LINE__);
        }
        if (is_null($personToTribute) || (is_array($personToTribute) && empty($personToTribute))) {
            unset($this->PersonToTribute);
        } else {
            $this->PersonToTribute = $personToTribute;
        }
        return $this;
    }
    /**
     * Get ThankYouLetterSpecialMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThankYouLetterSpecialMessage()
    {
        return isset($this->ThankYouLetterSpecialMessage) ? $this->ThankYouLetterSpecialMessage : null;
    }
    /**
     * Set ThankYouLetterSpecialMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thankYouLetterSpecialMessage
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage = null)
    {
        // validation for constraint: string
        if (!is_null($thankYouLetterSpecialMessage) && !is_string($thankYouLetterSpecialMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thankYouLetterSpecialMessage, true), gettype($thankYouLetterSpecialMessage)), __LINE__);
        }
        if (is_null($thankYouLetterSpecialMessage) || (is_array($thankYouLetterSpecialMessage) && empty($thankYouLetterSpecialMessage))) {
            unset($this->ThankYouLetterSpecialMessage);
        } else {
            $this->ThankYouLetterSpecialMessage = $thankYouLetterSpecialMessage;
        }
        return $this;
    }
    /**
     * Get TributeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeType()
    {
        return isset($this->TributeType) ? $this->TributeType : null;
    }
    /**
     * Set TributeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TributeType::valueIsValid()
     * @uses \patest\EnumType\TributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tributeType
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setTributeType($tributeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TributeType::valueIsValid($tributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TributeType', is_array($tributeType) ? implode(', ', $tributeType) : var_export($tributeType, true), implode(', ', \patest\EnumType\TributeType::getValidValues())), __LINE__);
        }
        if (is_null($tributeType) || (is_array($tributeType) && empty($tributeType))) {
            unset($this->TributeType);
        } else {
            $this->TributeType = $tributeType;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $value
     * @return \patest\StructType\Donation_AddDonationToBasketRequest
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
