<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DonationSaleItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DonationSaleItem
 * @subpackage Structs
 */
class DonationSaleItem extends AbstractStructBase
{
    /**
     * The DonationProductItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DonationProductItemId;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InsertionMode;
    /**
     * Constructor method for DonationSaleItem
     * @uses DonationSaleItem::setDonationProductItemId()
     * @uses DonationSaleItem::setInsertionMode()
     * @param string $donationProductItemId
     * @param string $insertionMode
     */
    public function __construct($donationProductItemId = null, $insertionMode = null)
    {
        $this
            ->setDonationProductItemId($donationProductItemId)
            ->setInsertionMode($insertionMode);
    }
    /**
     * Get DonationProductItemId value
     * @return string|null
     */
    public function getDonationProductItemId()
    {
        return $this->DonationProductItemId;
    }
    /**
     * Set DonationProductItemId value
     * @param string $donationProductItemId
     * @return \patest\StructType\DonationSaleItem
     */
    public function setDonationProductItemId($donationProductItemId = null)
    {
        // validation for constraint: string
        if (!is_null($donationProductItemId) && !is_string($donationProductItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationProductItemId, true), gettype($donationProductItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($donationProductItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $donationProductItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($donationProductItemId, true)), __LINE__);
        }
        $this->DonationProductItemId = $donationProductItemId;
        return $this;
    }
    /**
     * Get InsertionMode value
     * @return string|null
     */
    public function getInsertionMode()
    {
        return $this->InsertionMode;
    }
    /**
     * Set InsertionMode value
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\DonationSaleItem
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        $this->InsertionMode = $insertionMode;
        return $this;
    }
}
