<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DonationData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DonationData
 * @subpackage Structs
 */
class DonationData extends SearchResultDataChunk
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The DonationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationName;
    /**
     * The FundName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FundName;
    /**
     * The Printed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Printed;
    /**
     * The TransactionGuids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TransactionGuids;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * Constructor method for DonationData
     * @uses DonationData::setActive()
     * @uses DonationData::setDonationName()
     * @uses DonationData::setFundName()
     * @uses DonationData::setPrinted()
     * @uses DonationData::setTransactionGuids()
     * @uses DonationData::setValue()
     * @param bool $active
     * @param string $donationName
     * @param string $fundName
     * @param bool $printed
     * @param \patest\ArrayType\ArrayOfguid $transactionGuids
     * @param float $value
     */
    public function __construct($active = null, $donationName = null, $fundName = null, $printed = null, \patest\ArrayType\ArrayOfguid $transactionGuids = null, $value = null)
    {
        $this
            ->setActive($active)
            ->setDonationName($donationName)
            ->setFundName($fundName)
            ->setPrinted($printed)
            ->setTransactionGuids($transactionGuids)
            ->setValue($value);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \patest\StructType\DonationData
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get DonationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationName()
    {
        return isset($this->DonationName) ? $this->DonationName : null;
    }
    /**
     * Set DonationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationName
     * @return \patest\StructType\DonationData
     */
    public function setDonationName($donationName = null)
    {
        // validation for constraint: string
        if (!is_null($donationName) && !is_string($donationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationName, true), gettype($donationName)), __LINE__);
        }
        if (is_null($donationName) || (is_array($donationName) && empty($donationName))) {
            unset($this->DonationName);
        } else {
            $this->DonationName = $donationName;
        }
        return $this;
    }
    /**
     * Get FundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFundName()
    {
        return isset($this->FundName) ? $this->FundName : null;
    }
    /**
     * Set FundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fundName
     * @return \patest\StructType\DonationData
     */
    public function setFundName($fundName = null)
    {
        // validation for constraint: string
        if (!is_null($fundName) && !is_string($fundName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundName, true), gettype($fundName)), __LINE__);
        }
        if (is_null($fundName) || (is_array($fundName) && empty($fundName))) {
            unset($this->FundName);
        } else {
            $this->FundName = $fundName;
        }
        return $this;
    }
    /**
     * Get Printed value
     * @return bool|null
     */
    public function getPrinted()
    {
        return $this->Printed;
    }
    /**
     * Set Printed value
     * @param bool $printed
     * @return \patest\StructType\DonationData
     */
    public function setPrinted($printed = null)
    {
        // validation for constraint: boolean
        if (!is_null($printed) && !is_bool($printed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printed, true), gettype($printed)), __LINE__);
        }
        $this->Printed = $printed;
        return $this;
    }
    /**
     * Get TransactionGuids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTransactionGuids()
    {
        return isset($this->TransactionGuids) ? $this->TransactionGuids : null;
    }
    /**
     * Set TransactionGuids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $transactionGuids
     * @return \patest\StructType\DonationData
     */
    public function setTransactionGuids(\patest\ArrayType\ArrayOfguid $transactionGuids = null)
    {
        if (is_null($transactionGuids) || (is_array($transactionGuids) && empty($transactionGuids))) {
            unset($this->TransactionGuids);
        } else {
            $this->TransactionGuids = $transactionGuids;
        }
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \patest\StructType\DonationData
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
