<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectDebitRecord StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DirectDebitRecord
 * @subpackage Structs
 */
class DirectDebitRecord extends AbstractStructBase
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The ApproximateSendDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ApproximateSendDate;
    /**
     * The BankAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankAddress;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankCode;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The GiroAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiroAccountNumber;
    /**
     * The IsCollectingRecord
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCollectingRecord;
    /**
     * The MandateTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateTypeId;
    /**
     * The RecordId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The BIC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BIC;
    /**
     * The CountPaymentsInRecord
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CountPaymentsInRecord;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IBAN;
    /**
     * The IsFirstRecordForMandate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFirstRecordForMandate;
    /**
     * The MandateAuthorizationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MandateAuthorizationDate;
    /**
     * The MandateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateId;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MandateNumber;
    /**
     * Constructor method for DirectDebitRecord
     * @uses DirectDebitRecord::setAccountName()
     * @uses DirectDebitRecord::setAccountNumber()
     * @uses DirectDebitRecord::setAmount()
     * @uses DirectDebitRecord::setApproximateSendDate()
     * @uses DirectDebitRecord::setBankAddress()
     * @uses DirectDebitRecord::setBankCode()
     * @uses DirectDebitRecord::setBankName()
     * @uses DirectDebitRecord::setGiroAccountNumber()
     * @uses DirectDebitRecord::setIsCollectingRecord()
     * @uses DirectDebitRecord::setMandateTypeId()
     * @uses DirectDebitRecord::setRecordId()
     * @uses DirectDebitRecord::setStatus()
     * @uses DirectDebitRecord::setBIC()
     * @uses DirectDebitRecord::setCountPaymentsInRecord()
     * @uses DirectDebitRecord::setIBAN()
     * @uses DirectDebitRecord::setIsFirstRecordForMandate()
     * @uses DirectDebitRecord::setMandateAuthorizationDate()
     * @uses DirectDebitRecord::setMandateId()
     * @uses DirectDebitRecord::setMandateNumber()
     * @param string $accountName
     * @param string $accountNumber
     * @param \patest\StructType\Money $amount
     * @param string $approximateSendDate
     * @param string $bankAddress
     * @param string $bankCode
     * @param string $bankName
     * @param string $giroAccountNumber
     * @param bool $isCollectingRecord
     * @param string $mandateTypeId
     * @param string $recordId
     * @param string $status
     * @param string $bIC
     * @param int $countPaymentsInRecord
     * @param string $iBAN
     * @param bool $isFirstRecordForMandate
     * @param string $mandateAuthorizationDate
     * @param string $mandateId
     * @param int $mandateNumber
     */
    public function __construct($accountName = null, $accountNumber = null, \patest\StructType\Money $amount = null, $approximateSendDate = null, $bankAddress = null, $bankCode = null, $bankName = null, $giroAccountNumber = null, $isCollectingRecord = null, $mandateTypeId = null, $recordId = null, $status = null, $bIC = null, $countPaymentsInRecord = null, $iBAN = null, $isFirstRecordForMandate = null, $mandateAuthorizationDate = null, $mandateId = null, $mandateNumber = null)
    {
        $this
            ->setAccountName($accountName)
            ->setAccountNumber($accountNumber)
            ->setAmount($amount)
            ->setApproximateSendDate($approximateSendDate)
            ->setBankAddress($bankAddress)
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setGiroAccountNumber($giroAccountNumber)
            ->setIsCollectingRecord($isCollectingRecord)
            ->setMandateTypeId($mandateTypeId)
            ->setRecordId($recordId)
            ->setStatus($status)
            ->setBIC($bIC)
            ->setCountPaymentsInRecord($countPaymentsInRecord)
            ->setIBAN($iBAN)
            ->setIsFirstRecordForMandate($isFirstRecordForMandate)
            ->setMandateAuthorizationDate($mandateAuthorizationDate)
            ->setMandateId($mandateId)
            ->setMandateNumber($mandateNumber);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ApproximateSendDate value
     * @return string|null
     */
    public function getApproximateSendDate()
    {
        return $this->ApproximateSendDate;
    }
    /**
     * Set ApproximateSendDate value
     * @param string $approximateSendDate
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setApproximateSendDate($approximateSendDate = null)
    {
        // validation for constraint: string
        if (!is_null($approximateSendDate) && !is_string($approximateSendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approximateSendDate, true), gettype($approximateSendDate)), __LINE__);
        }
        $this->ApproximateSendDate = $approximateSendDate;
        return $this;
    }
    /**
     * Get BankAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankAddress()
    {
        return isset($this->BankAddress) ? $this->BankAddress : null;
    }
    /**
     * Set BankAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankAddress
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setBankAddress($bankAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bankAddress) && !is_string($bankAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAddress, true), gettype($bankAddress)), __LINE__);
        }
        if (is_null($bankAddress) || (is_array($bankAddress) && empty($bankAddress))) {
            unset($this->BankAddress);
        } else {
            $this->BankAddress = $bankAddress;
        }
        return $this;
    }
    /**
     * Get BankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankCode()
    {
        return isset($this->BankCode) ? $this->BankCode : null;
    }
    /**
     * Set BankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankCode
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        if (is_null($bankCode) || (is_array($bankCode) && empty($bankCode))) {
            unset($this->BankCode);
        } else {
            $this->BankCode = $bankCode;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get GiroAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiroAccountNumber()
    {
        return isset($this->GiroAccountNumber) ? $this->GiroAccountNumber : null;
    }
    /**
     * Set GiroAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giroAccountNumber
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setGiroAccountNumber($giroAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giroAccountNumber) && !is_string($giroAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giroAccountNumber, true), gettype($giroAccountNumber)), __LINE__);
        }
        if (is_null($giroAccountNumber) || (is_array($giroAccountNumber) && empty($giroAccountNumber))) {
            unset($this->GiroAccountNumber);
        } else {
            $this->GiroAccountNumber = $giroAccountNumber;
        }
        return $this;
    }
    /**
     * Get IsCollectingRecord value
     * @return bool|null
     */
    public function getIsCollectingRecord()
    {
        return $this->IsCollectingRecord;
    }
    /**
     * Set IsCollectingRecord value
     * @param bool $isCollectingRecord
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setIsCollectingRecord($isCollectingRecord = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCollectingRecord) && !is_bool($isCollectingRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCollectingRecord, true), gettype($isCollectingRecord)), __LINE__);
        }
        $this->IsCollectingRecord = $isCollectingRecord;
        return $this;
    }
    /**
     * Get MandateTypeId value
     * @return string|null
     */
    public function getMandateTypeId()
    {
        return $this->MandateTypeId;
    }
    /**
     * Set MandateTypeId value
     * @param string $mandateTypeId
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setMandateTypeId($mandateTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeId) && !is_string($mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeId, true), gettype($mandateTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateTypeId, true)), __LINE__);
        }
        $this->MandateTypeId = $mandateTypeId;
        return $this;
    }
    /**
     * Get RecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordId()
    {
        return isset($this->RecordId) ? $this->RecordId : null;
    }
    /**
     * Set RecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordId
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setRecordId($recordId = null)
    {
        // validation for constraint: string
        if (!is_null($recordId) && !is_string($recordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordId, true), gettype($recordId)), __LINE__);
        }
        if (is_null($recordId) || (is_array($recordId) && empty($recordId))) {
            unset($this->RecordId);
        } else {
            $this->RecordId = $recordId;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\DirectDebitRecordStatus::valueIsValid()
     * @uses \patest\EnumType\DirectDebitRecordStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DirectDebitRecordStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DirectDebitRecordStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\DirectDebitRecordStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get BIC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBIC()
    {
        return isset($this->BIC) ? $this->BIC : null;
    }
    /**
     * Set BIC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bIC
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIC, true), gettype($bIC)), __LINE__);
        }
        if (is_null($bIC) || (is_array($bIC) && empty($bIC))) {
            unset($this->BIC);
        } else {
            $this->BIC = $bIC;
        }
        return $this;
    }
    /**
     * Get CountPaymentsInRecord value
     * @return int|null
     */
    public function getCountPaymentsInRecord()
    {
        return $this->CountPaymentsInRecord;
    }
    /**
     * Set CountPaymentsInRecord value
     * @param int $countPaymentsInRecord
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setCountPaymentsInRecord($countPaymentsInRecord = null)
    {
        // validation for constraint: int
        if (!is_null($countPaymentsInRecord) && !(is_int($countPaymentsInRecord) || ctype_digit($countPaymentsInRecord))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countPaymentsInRecord, true), gettype($countPaymentsInRecord)), __LINE__);
        }
        $this->CountPaymentsInRecord = $countPaymentsInRecord;
        return $this;
    }
    /**
     * Get IBAN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIBAN()
    {
        return isset($this->IBAN) ? $this->IBAN : null;
    }
    /**
     * Set IBAN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iBAN
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        if (is_null($iBAN) || (is_array($iBAN) && empty($iBAN))) {
            unset($this->IBAN);
        } else {
            $this->IBAN = $iBAN;
        }
        return $this;
    }
    /**
     * Get IsFirstRecordForMandate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFirstRecordForMandate()
    {
        return isset($this->IsFirstRecordForMandate) ? $this->IsFirstRecordForMandate : null;
    }
    /**
     * Set IsFirstRecordForMandate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFirstRecordForMandate
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setIsFirstRecordForMandate($isFirstRecordForMandate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstRecordForMandate) && !is_bool($isFirstRecordForMandate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFirstRecordForMandate, true), gettype($isFirstRecordForMandate)), __LINE__);
        }
        if (is_null($isFirstRecordForMandate) || (is_array($isFirstRecordForMandate) && empty($isFirstRecordForMandate))) {
            unset($this->IsFirstRecordForMandate);
        } else {
            $this->IsFirstRecordForMandate = $isFirstRecordForMandate;
        }
        return $this;
    }
    /**
     * Get MandateAuthorizationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateAuthorizationDate()
    {
        return isset($this->MandateAuthorizationDate) ? $this->MandateAuthorizationDate : null;
    }
    /**
     * Set MandateAuthorizationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateAuthorizationDate
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setMandateAuthorizationDate($mandateAuthorizationDate = null)
    {
        // validation for constraint: string
        if (!is_null($mandateAuthorizationDate) && !is_string($mandateAuthorizationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateAuthorizationDate, true), gettype($mandateAuthorizationDate)), __LINE__);
        }
        if (is_null($mandateAuthorizationDate) || (is_array($mandateAuthorizationDate) && empty($mandateAuthorizationDate))) {
            unset($this->MandateAuthorizationDate);
        } else {
            $this->MandateAuthorizationDate = $mandateAuthorizationDate;
        }
        return $this;
    }
    /**
     * Get MandateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateId()
    {
        return isset($this->MandateId) ? $this->MandateId : null;
    }
    /**
     * Set MandateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateId
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setMandateId($mandateId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateId) && !is_string($mandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateId, true), gettype($mandateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateId, true)), __LINE__);
        }
        if (is_null($mandateId) || (is_array($mandateId) && empty($mandateId))) {
            unset($this->MandateId);
        } else {
            $this->MandateId = $mandateId;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * @return int|null
     */
    public function getMandateNumber()
    {
        return $this->MandateNumber;
    }
    /**
     * Set MandateNumber value
     * @param int $mandateNumber
     * @return \patest\StructType\DirectDebitRecord
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mandateNumber) && !(is_int($mandateNumber) || ctype_digit($mandateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        $this->MandateNumber = $mandateNumber;
        return $this;
    }
}
