<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectDebitPaymentItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DirectDebitPaymentItem
 * @subpackage Structs
 */
class DirectDebitPaymentItem extends AbstractPaymentItem
{
    /**
     * The CollectPaymentOnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CollectPaymentOnDate;
    /**
     * The DirectDebitMandate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_DirectDebitMandate
     */
    public $DirectDebitMandate;
    /**
     * The FirstPaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $FirstPaymentAmount;
    /**
     * The MandateOnlyForThisTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MandateOnlyForThisTransaction;
    /**
     * The NextPaymentAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $NextPaymentAmount;
    /**
     * Constructor method for DirectDebitPaymentItem
     * @uses DirectDebitPaymentItem::setCollectPaymentOnDate()
     * @uses DirectDebitPaymentItem::setDirectDebitMandate()
     * @uses DirectDebitPaymentItem::setFirstPaymentAmount()
     * @uses DirectDebitPaymentItem::setMandateOnlyForThisTransaction()
     * @uses DirectDebitPaymentItem::setNextPaymentAmount()
     * @param string $collectPaymentOnDate
     * @param \patest\StructType\Payment_DirectDebitMandate $directDebitMandate
     * @param \patest\StructType\Money $firstPaymentAmount
     * @param bool $mandateOnlyForThisTransaction
     * @param \patest\StructType\Money $nextPaymentAmount
     */
    public function __construct($collectPaymentOnDate = null, \patest\StructType\Payment_DirectDebitMandate $directDebitMandate = null, \patest\StructType\Money $firstPaymentAmount = null, $mandateOnlyForThisTransaction = null, \patest\StructType\Money $nextPaymentAmount = null)
    {
        $this
            ->setCollectPaymentOnDate($collectPaymentOnDate)
            ->setDirectDebitMandate($directDebitMandate)
            ->setFirstPaymentAmount($firstPaymentAmount)
            ->setMandateOnlyForThisTransaction($mandateOnlyForThisTransaction)
            ->setNextPaymentAmount($nextPaymentAmount);
    }
    /**
     * Get CollectPaymentOnDate value
     * @return string|null
     */
    public function getCollectPaymentOnDate()
    {
        return $this->CollectPaymentOnDate;
    }
    /**
     * Set CollectPaymentOnDate value
     * @param string $collectPaymentOnDate
     * @return \patest\StructType\DirectDebitPaymentItem
     */
    public function setCollectPaymentOnDate($collectPaymentOnDate = null)
    {
        // validation for constraint: string
        if (!is_null($collectPaymentOnDate) && !is_string($collectPaymentOnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectPaymentOnDate, true), gettype($collectPaymentOnDate)), __LINE__);
        }
        $this->CollectPaymentOnDate = $collectPaymentOnDate;
        return $this;
    }
    /**
     * Get DirectDebitMandate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_DirectDebitMandate|null
     */
    public function getDirectDebitMandate()
    {
        return isset($this->DirectDebitMandate) ? $this->DirectDebitMandate : null;
    }
    /**
     * Set DirectDebitMandate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_DirectDebitMandate $directDebitMandate
     * @return \patest\StructType\DirectDebitPaymentItem
     */
    public function setDirectDebitMandate(\patest\StructType\Payment_DirectDebitMandate $directDebitMandate = null)
    {
        if (is_null($directDebitMandate) || (is_array($directDebitMandate) && empty($directDebitMandate))) {
            unset($this->DirectDebitMandate);
        } else {
            $this->DirectDebitMandate = $directDebitMandate;
        }
        return $this;
    }
    /**
     * Get FirstPaymentAmount value
     * @return \patest\StructType\Money|null
     */
    public function getFirstPaymentAmount()
    {
        return $this->FirstPaymentAmount;
    }
    /**
     * Set FirstPaymentAmount value
     * @param \patest\StructType\Money $firstPaymentAmount
     * @return \patest\StructType\DirectDebitPaymentItem
     */
    public function setFirstPaymentAmount(\patest\StructType\Money $firstPaymentAmount = null)
    {
        $this->FirstPaymentAmount = $firstPaymentAmount;
        return $this;
    }
    /**
     * Get MandateOnlyForThisTransaction value
     * @return bool|null
     */
    public function getMandateOnlyForThisTransaction()
    {
        return $this->MandateOnlyForThisTransaction;
    }
    /**
     * Set MandateOnlyForThisTransaction value
     * @param bool $mandateOnlyForThisTransaction
     * @return \patest\StructType\DirectDebitPaymentItem
     */
    public function setMandateOnlyForThisTransaction($mandateOnlyForThisTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandateOnlyForThisTransaction) && !is_bool($mandateOnlyForThisTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandateOnlyForThisTransaction, true), gettype($mandateOnlyForThisTransaction)), __LINE__);
        }
        $this->MandateOnlyForThisTransaction = $mandateOnlyForThisTransaction;
        return $this;
    }
    /**
     * Get NextPaymentAmount value
     * @return \patest\StructType\Money|null
     */
    public function getNextPaymentAmount()
    {
        return $this->NextPaymentAmount;
    }
    /**
     * Set NextPaymentAmount value
     * @param \patest\StructType\Money $nextPaymentAmount
     * @return \patest\StructType\DirectDebitPaymentItem
     */
    public function setNextPaymentAmount(\patest\StructType\Money $nextPaymentAmount = null)
    {
        $this->NextPaymentAmount = $nextPaymentAmount;
        return $this;
    }
}
