<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryPricingDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryPricingDescription
 * @subpackage Structs
 */
class DeliveryPricingDescription extends AbstractStructBase
{
    /**
     * The DeliveryMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryMethodId;
    /**
     * The PriceModifiersDescriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidstring
     */
    public $PriceModifiersDescriptions;
    /**
     * The PricingEntry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\InventoryPricingEntry
     */
    public $PricingEntry;
    /**
     * The PriceModifierDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea
     */
    public $PriceModifierDetails;
    /**
     * Constructor method for DeliveryPricingDescription
     * @uses DeliveryPricingDescription::setDeliveryMethodId()
     * @uses DeliveryPricingDescription::setPriceModifiersDescriptions()
     * @uses DeliveryPricingDescription::setPricingEntry()
     * @uses DeliveryPricingDescription::setPriceModifierDetails()
     * @param string $deliveryMethodId
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidstring $priceModifiersDescriptions
     * @param \patest\StructType\InventoryPricingEntry $pricingEntry
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea $priceModifierDetails
     */
    public function __construct($deliveryMethodId = null, \patest\ArrayType\ArrayOfKeyValueOfguidstring $priceModifiersDescriptions = null, \patest\StructType\InventoryPricingEntry $pricingEntry = null, \patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea $priceModifierDetails = null)
    {
        $this
            ->setDeliveryMethodId($deliveryMethodId)
            ->setPriceModifiersDescriptions($priceModifiersDescriptions)
            ->setPricingEntry($pricingEntry)
            ->setPriceModifierDetails($priceModifierDetails);
    }
    /**
     * Get DeliveryMethodId value
     * @return string|null
     */
    public function getDeliveryMethodId()
    {
        return $this->DeliveryMethodId;
    }
    /**
     * Set DeliveryMethodId value
     * @param string $deliveryMethodId
     * @return \patest\StructType\DeliveryPricingDescription
     */
    public function setDeliveryMethodId($deliveryMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMethodId) && !is_string($deliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryMethodId, true), gettype($deliveryMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryMethodId, true)), __LINE__);
        }
        $this->DeliveryMethodId = $deliveryMethodId;
        return $this;
    }
    /**
     * Get PriceModifiersDescriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidstring|null
     */
    public function getPriceModifiersDescriptions()
    {
        return isset($this->PriceModifiersDescriptions) ? $this->PriceModifiersDescriptions : null;
    }
    /**
     * Set PriceModifiersDescriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidstring $priceModifiersDescriptions
     * @return \patest\StructType\DeliveryPricingDescription
     */
    public function setPriceModifiersDescriptions(\patest\ArrayType\ArrayOfKeyValueOfguidstring $priceModifiersDescriptions = null)
    {
        if (is_null($priceModifiersDescriptions) || (is_array($priceModifiersDescriptions) && empty($priceModifiersDescriptions))) {
            unset($this->PriceModifiersDescriptions);
        } else {
            $this->PriceModifiersDescriptions = $priceModifiersDescriptions;
        }
        return $this;
    }
    /**
     * Get PricingEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\InventoryPricingEntry|null
     */
    public function getPricingEntry()
    {
        return isset($this->PricingEntry) ? $this->PricingEntry : null;
    }
    /**
     * Set PricingEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\InventoryPricingEntry $pricingEntry
     * @return \patest\StructType\DeliveryPricingDescription
     */
    public function setPricingEntry(\patest\StructType\InventoryPricingEntry $pricingEntry = null)
    {
        if (is_null($pricingEntry) || (is_array($pricingEntry) && empty($pricingEntry))) {
            unset($this->PricingEntry);
        } else {
            $this->PricingEntry = $pricingEntry;
        }
        return $this;
    }
    /**
     * Get PriceModifierDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea|null
     */
    public function getPriceModifierDetails()
    {
        return isset($this->PriceModifierDetails) ? $this->PriceModifierDetails : null;
    }
    /**
     * Set PriceModifierDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea $priceModifierDetails
     * @return \patest\StructType\DeliveryPricingDescription
     */
    public function setPriceModifierDetails(\patest\ArrayType\ArrayOfKeyValueOfguidInventoryPriceModifierDetailshpjoQDea $priceModifierDetails = null)
    {
        if (is_null($priceModifierDetails) || (is_array($priceModifierDetails) && empty($priceModifierDetails))) {
            unset($this->PriceModifierDetails);
        } else {
            $this->PriceModifierDetails = $priceModifierDetails;
        }
        return $this;
    }
}
