<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteBallotApplication-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeleteBallotApplication-Request
 * @subpackage Structs
 */
class DeleteBallotApplication_Request extends AbstractStructBase
{
    /**
     * The BallotClientApplicationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotClientApplicationId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * Constructor method for DeleteBallotApplication-Request
     * @uses DeleteBallotApplication_Request::setBallotClientApplicationId()
     * @uses DeleteBallotApplication_Request::setClientId()
     * @param string $ballotClientApplicationId
     * @param string $clientId
     */
    public function __construct($ballotClientApplicationId = null, $clientId = null)
    {
        $this
            ->setBallotClientApplicationId($ballotClientApplicationId)
            ->setClientId($clientId);
    }
    /**
     * Get BallotClientApplicationId value
     * @return string|null
     */
    public function getBallotClientApplicationId()
    {
        return $this->BallotClientApplicationId;
    }
    /**
     * Set BallotClientApplicationId value
     * @param string $ballotClientApplicationId
     * @return \patest\StructType\DeleteBallotApplication_Request
     */
    public function setBallotClientApplicationId($ballotClientApplicationId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotClientApplicationId) && !is_string($ballotClientApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotClientApplicationId, true), gettype($ballotClientApplicationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotClientApplicationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotClientApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotClientApplicationId, true)), __LINE__);
        }
        $this->BallotClientApplicationId = $ballotClientApplicationId;
        return $this;
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\DeleteBallotApplication_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
}
