<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DebtDetails
 * @subpackage Structs
 */
class DebtDetails extends AbstractStructBase
{
    /**
     * The FinancialJournalTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FinancialJournalTargetId;
    /**
     * The FinancialJournalTargetKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FinancialJournalTargetKind;
    /**
     * The ItemDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_AbstractItemDetails
     */
    public $ItemDetails;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemType;
    /**
     * The PaymentItemGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentItemGuid;
    /**
     * The FinancialJournalSubTargetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FinancialJournalSubTargetId;
    /**
     * Constructor method for DebtDetails
     * @uses DebtDetails::setFinancialJournalTargetId()
     * @uses DebtDetails::setFinancialJournalTargetKind()
     * @uses DebtDetails::setItemDetails()
     * @uses DebtDetails::setItemType()
     * @uses DebtDetails::setPaymentItemGuid()
     * @uses DebtDetails::setFinancialJournalSubTargetId()
     * @param string $financialJournalTargetId
     * @param string $financialJournalTargetKind
     * @param \patest\StructType\Sales_AbstractItemDetails $itemDetails
     * @param int $itemType
     * @param string $paymentItemGuid
     * @param string $financialJournalSubTargetId
     */
    public function __construct($financialJournalTargetId = null, $financialJournalTargetKind = null, \patest\StructType\Sales_AbstractItemDetails $itemDetails = null, $itemType = null, $paymentItemGuid = null, $financialJournalSubTargetId = null)
    {
        $this
            ->setFinancialJournalTargetId($financialJournalTargetId)
            ->setFinancialJournalTargetKind($financialJournalTargetKind)
            ->setItemDetails($itemDetails)
            ->setItemType($itemType)
            ->setPaymentItemGuid($paymentItemGuid)
            ->setFinancialJournalSubTargetId($financialJournalSubTargetId);
    }
    /**
     * Get FinancialJournalTargetId value
     * @return string|null
     */
    public function getFinancialJournalTargetId()
    {
        return $this->FinancialJournalTargetId;
    }
    /**
     * Set FinancialJournalTargetId value
     * @param string $financialJournalTargetId
     * @return \patest\StructType\DebtDetails
     */
    public function setFinancialJournalTargetId($financialJournalTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($financialJournalTargetId) && !is_string($financialJournalTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financialJournalTargetId, true), gettype($financialJournalTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($financialJournalTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $financialJournalTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($financialJournalTargetId, true)), __LINE__);
        }
        $this->FinancialJournalTargetId = $financialJournalTargetId;
        return $this;
    }
    /**
     * Get FinancialJournalTargetKind value
     * @return string|null
     */
    public function getFinancialJournalTargetKind()
    {
        return $this->FinancialJournalTargetKind;
    }
    /**
     * Set FinancialJournalTargetKind value
     * @uses \patest\EnumType\FinancialJournalTargetKind::valueIsValid()
     * @uses \patest\EnumType\FinancialJournalTargetKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $financialJournalTargetKind
     * @return \patest\StructType\DebtDetails
     */
    public function setFinancialJournalTargetKind($financialJournalTargetKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FinancialJournalTargetKind::valueIsValid($financialJournalTargetKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FinancialJournalTargetKind', is_array($financialJournalTargetKind) ? implode(', ', $financialJournalTargetKind) : var_export($financialJournalTargetKind, true), implode(', ', \patest\EnumType\FinancialJournalTargetKind::getValidValues())), __LINE__);
        }
        $this->FinancialJournalTargetKind = $financialJournalTargetKind;
        return $this;
    }
    /**
     * Get ItemDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_AbstractItemDetails|null
     */
    public function getItemDetails()
    {
        return isset($this->ItemDetails) ? $this->ItemDetails : null;
    }
    /**
     * Set ItemDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_AbstractItemDetails $itemDetails
     * @return \patest\StructType\DebtDetails
     */
    public function setItemDetails(\patest\StructType\Sales_AbstractItemDetails $itemDetails = null)
    {
        if (is_null($itemDetails) || (is_array($itemDetails) && empty($itemDetails))) {
            unset($this->ItemDetails);
        } else {
            $this->ItemDetails = $itemDetails;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * @return int|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @param int $itemType
     * @return \patest\StructType\DebtDetails
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get PaymentItemGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentItemGuid()
    {
        return isset($this->PaymentItemGuid) ? $this->PaymentItemGuid : null;
    }
    /**
     * Set PaymentItemGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentItemGuid
     * @return \patest\StructType\DebtDetails
     */
    public function setPaymentItemGuid($paymentItemGuid = null)
    {
        // validation for constraint: string
        if (!is_null($paymentItemGuid) && !is_string($paymentItemGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentItemGuid, true), gettype($paymentItemGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentItemGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentItemGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentItemGuid, true)), __LINE__);
        }
        if (is_null($paymentItemGuid) || (is_array($paymentItemGuid) && empty($paymentItemGuid))) {
            unset($this->PaymentItemGuid);
        } else {
            $this->PaymentItemGuid = $paymentItemGuid;
        }
        return $this;
    }
    /**
     * Get FinancialJournalSubTargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFinancialJournalSubTargetId()
    {
        return isset($this->FinancialJournalSubTargetId) ? $this->FinancialJournalSubTargetId : null;
    }
    /**
     * Set FinancialJournalSubTargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $financialJournalSubTargetId
     * @return \patest\StructType\DebtDetails
     */
    public function setFinancialJournalSubTargetId($financialJournalSubTargetId = null)
    {
        // validation for constraint: string
        if (!is_null($financialJournalSubTargetId) && !is_string($financialJournalSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financialJournalSubTargetId, true), gettype($financialJournalSubTargetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($financialJournalSubTargetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $financialJournalSubTargetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($financialJournalSubTargetId, true)), __LINE__);
        }
        if (is_null($financialJournalSubTargetId) || (is_array($financialJournalSubTargetId) && empty($financialJournalSubTargetId))) {
            unset($this->FinancialJournalSubTargetId);
        } else {
            $this->FinancialJournalSubTargetId = $financialJournalSubTargetId;
        }
        return $this;
    }
}
