<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeactivateAccessCode-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeactivateAccessCode-Request
 * @subpackage Structs
 */
class DeactivateAccessCode_Request extends ExtensibleDataContract
{
    /**
     * The CodeTexts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $CodeTexts;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * Constructor method for DeactivateAccessCode-Request
     * @uses DeactivateAccessCode_Request::setCodeTexts()
     * @uses DeactivateAccessCode_Request::setPresaleId()
     * @param \patest\ArrayType\ArrayOfstring $codeTexts
     * @param string $presaleId
     */
    public function __construct(\patest\ArrayType\ArrayOfstring $codeTexts = null, $presaleId = null)
    {
        $this
            ->setCodeTexts($codeTexts)
            ->setPresaleId($presaleId);
    }
    /**
     * Get CodeTexts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getCodeTexts()
    {
        return isset($this->CodeTexts) ? $this->CodeTexts : null;
    }
    /**
     * Set CodeTexts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $codeTexts
     * @return \patest\StructType\DeactivateAccessCode_Request
     */
    public function setCodeTexts(\patest\ArrayType\ArrayOfstring $codeTexts = null)
    {
        if (is_null($codeTexts) || (is_array($codeTexts) && empty($codeTexts))) {
            unset($this->CodeTexts);
        } else {
            $this->CodeTexts = $codeTexts;
        }
        return $this;
    }
    /**
     * Get PresaleId value
     * @return string|null
     */
    public function getPresaleId()
    {
        return $this->PresaleId;
    }
    /**
     * Set PresaleId value
     * @param string $presaleId
     * @return \patest\StructType\DeactivateAccessCode_Request
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        $this->PresaleId = $presaleId;
        return $this;
    }
}
