<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataBatchPart StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DataBatchPart
 * @subpackage Structs
 */
class DataBatchPart extends AbstractStructBase
{
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The Records
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAnyEntity
     */
    public $Records;
    /**
     * The TransmittedProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfDataBatchPartEntityPropertiesList
     */
    public $TransmittedProperties;
    /**
     * Constructor method for DataBatchPart
     * @uses DataBatchPart::setEntityName()
     * @uses DataBatchPart::setRecords()
     * @uses DataBatchPart::setTransmittedProperties()
     * @param string $entityName
     * @param \patest\StructType\RecordSetOfAnyEntity $records
     * @param \patest\ArrayType\ArrayOfDataBatchPartEntityPropertiesList $transmittedProperties
     */
    public function __construct($entityName = null, \patest\StructType\RecordSetOfAnyEntity $records = null, \patest\ArrayType\ArrayOfDataBatchPartEntityPropertiesList $transmittedProperties = null)
    {
        $this
            ->setEntityName($entityName)
            ->setRecords($records)
            ->setTransmittedProperties($transmittedProperties);
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\DataBatchPart
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get Records value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAnyEntity|null
     */
    public function getRecords()
    {
        return isset($this->Records) ? $this->Records : null;
    }
    /**
     * Set Records value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAnyEntity $records
     * @return \patest\StructType\DataBatchPart
     */
    public function setRecords(\patest\StructType\RecordSetOfAnyEntity $records = null)
    {
        if (is_null($records) || (is_array($records) && empty($records))) {
            unset($this->Records);
        } else {
            $this->Records = $records;
        }
        return $this;
    }
    /**
     * Get TransmittedProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfDataBatchPartEntityPropertiesList|null
     */
    public function getTransmittedProperties()
    {
        return isset($this->TransmittedProperties) ? $this->TransmittedProperties : null;
    }
    /**
     * Set TransmittedProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfDataBatchPartEntityPropertiesList $transmittedProperties
     * @return \patest\StructType\DataBatchPart
     */
    public function setTransmittedProperties(\patest\ArrayType\ArrayOfDataBatchPartEntityPropertiesList $transmittedProperties = null)
    {
        if (is_null($transmittedProperties) || (is_array($transmittedProperties) && empty($transmittedProperties))) {
            unset($this->TransmittedProperties);
        } else {
            $this->TransmittedProperties = $transmittedProperties;
        }
        return $this;
    }
}
