<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerCreditCategory StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerCreditCategory
 * @subpackage Structs
 */
class CustomerCreditCategory extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DateTimeOffset
     */
    public $ExpirationDate;
    /**
     * The ExpirationDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExpirationDays;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocalId;
    /**
     * Constructor method for CustomerCreditCategory
     * @uses CustomerCreditCategory::setDescription()
     * @uses CustomerCreditCategory::setExpirationDate()
     * @uses CustomerCreditCategory::setExpirationDays()
     * @uses CustomerCreditCategory::setId()
     * @uses CustomerCreditCategory::setLocalId()
     * @param string $description
     * @param \patest\StructType\DateTimeOffset $expirationDate
     * @param int $expirationDays
     * @param string $id
     * @param int $localId
     */
    public function __construct($description = null, \patest\StructType\DateTimeOffset $expirationDate = null, $expirationDays = null, $id = null, $localId = null)
    {
        $this
            ->setDescription($description)
            ->setExpirationDate($expirationDate)
            ->setExpirationDays($expirationDays)
            ->setId($id)
            ->setLocalId($localId);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\CustomerCreditCategory
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DateTimeOffset|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DateTimeOffset $expirationDate
     * @return \patest\StructType\CustomerCreditCategory
     */
    public function setExpirationDate(\patest\StructType\DateTimeOffset $expirationDate = null)
    {
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get ExpirationDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExpirationDays()
    {
        return isset($this->ExpirationDays) ? $this->ExpirationDays : null;
    }
    /**
     * Set ExpirationDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $expirationDays
     * @return \patest\StructType\CustomerCreditCategory
     */
    public function setExpirationDays($expirationDays = null)
    {
        // validation for constraint: int
        if (!is_null($expirationDays) && !(is_int($expirationDays) || ctype_digit($expirationDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($expirationDays, true), gettype($expirationDays)), __LINE__);
        }
        if (is_null($expirationDays) || (is_array($expirationDays) && empty($expirationDays))) {
            unset($this->ExpirationDays);
        } else {
            $this->ExpirationDays = $expirationDays;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\CustomerCreditCategory
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get LocalId value
     * @return int|null
     */
    public function getLocalId()
    {
        return $this->LocalId;
    }
    /**
     * Set LocalId value
     * @param int $localId
     * @return \patest\StructType\CustomerCreditCategory
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        $this->LocalId = $localId;
        return $this;
    }
}
