<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomSeatPricesResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomSeatPricesResponse
 * @subpackage Structs
 */
class CustomSeatPricesResponse extends ExtensibleDataContract
{
    /**
     * The HasHitMaxExecutionTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasHitMaxExecutionTime;
    /**
     * The UnprocessedCustomSeatPricesByArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea
     */
    public $UnprocessedCustomSeatPricesByArea;
    /**
     * Constructor method for CustomSeatPricesResponse
     * @uses CustomSeatPricesResponse::setHasHitMaxExecutionTime()
     * @uses CustomSeatPricesResponse::setUnprocessedCustomSeatPricesByArea()
     * @param bool $hasHitMaxExecutionTime
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea $unprocessedCustomSeatPricesByArea
     */
    public function __construct($hasHitMaxExecutionTime = null, \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea $unprocessedCustomSeatPricesByArea = null)
    {
        $this
            ->setHasHitMaxExecutionTime($hasHitMaxExecutionTime)
            ->setUnprocessedCustomSeatPricesByArea($unprocessedCustomSeatPricesByArea);
    }
    /**
     * Get HasHitMaxExecutionTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasHitMaxExecutionTime()
    {
        return isset($this->HasHitMaxExecutionTime) ? $this->HasHitMaxExecutionTime : null;
    }
    /**
     * Set HasHitMaxExecutionTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasHitMaxExecutionTime
     * @return \patest\StructType\CustomSeatPricesResponse
     */
    public function setHasHitMaxExecutionTime($hasHitMaxExecutionTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasHitMaxExecutionTime) && !is_bool($hasHitMaxExecutionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasHitMaxExecutionTime, true), gettype($hasHitMaxExecutionTime)), __LINE__);
        }
        if (is_null($hasHitMaxExecutionTime) || (is_array($hasHitMaxExecutionTime) && empty($hasHitMaxExecutionTime))) {
            unset($this->HasHitMaxExecutionTime);
        } else {
            $this->HasHitMaxExecutionTime = $hasHitMaxExecutionTime;
        }
        return $this;
    }
    /**
     * Get UnprocessedCustomSeatPricesByArea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea|null
     */
    public function getUnprocessedCustomSeatPricesByArea()
    {
        return isset($this->UnprocessedCustomSeatPricesByArea) ? $this->UnprocessedCustomSeatPricesByArea : null;
    }
    /**
     * Set UnprocessedCustomSeatPricesByArea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea $unprocessedCustomSeatPricesByArea
     * @return \patest\StructType\CustomSeatPricesResponse
     */
    public function setUnprocessedCustomSeatPricesByArea(\patest\ArrayType\ArrayOfKeyValueOfguidArrayOfCustomSeatPricehpjoQDea $unprocessedCustomSeatPricesByArea = null)
    {
        if (is_null($unprocessedCustomSeatPricesByArea) || (is_array($unprocessedCustomSeatPricesByArea) && empty($unprocessedCustomSeatPricesByArea))) {
            unset($this->UnprocessedCustomSeatPricesByArea);
        } else {
            $this->UnprocessedCustomSeatPricesByArea = $unprocessedCustomSeatPricesByArea;
        }
        return $this;
    }
}
