<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomSeatPricesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomSeatPricesRequest
 * @subpackage Structs
 */
class CustomSeatPricesRequest extends ExtensibleDataContract
{
    /**
     * The MaxExecutionTimeInMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxExecutionTimeInMs;
    /**
     * Constructor method for CustomSeatPricesRequest
     * @uses CustomSeatPricesRequest::setMaxExecutionTimeInMs()
     * @param int $maxExecutionTimeInMs
     */
    public function __construct($maxExecutionTimeInMs = null)
    {
        $this
            ->setMaxExecutionTimeInMs($maxExecutionTimeInMs);
    }
    /**
     * Get MaxExecutionTimeInMs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxExecutionTimeInMs()
    {
        return isset($this->MaxExecutionTimeInMs) ? $this->MaxExecutionTimeInMs : null;
    }
    /**
     * Set MaxExecutionTimeInMs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxExecutionTimeInMs
     * @return \patest\StructType\CustomSeatPricesRequest
     */
    public function setMaxExecutionTimeInMs($maxExecutionTimeInMs = null)
    {
        // validation for constraint: int
        if (!is_null($maxExecutionTimeInMs) && !(is_int($maxExecutionTimeInMs) || ctype_digit($maxExecutionTimeInMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxExecutionTimeInMs, true), gettype($maxExecutionTimeInMs)), __LINE__);
        }
        if (is_null($maxExecutionTimeInMs) || (is_array($maxExecutionTimeInMs) && empty($maxExecutionTimeInMs))) {
            unset($this->MaxExecutionTimeInMs);
        } else {
            $this->MaxExecutionTimeInMs = $maxExecutionTimeInMs;
        }
        return $this;
    }
}
