<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrossServiceSearchFacade-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CrossServiceSearchFacade-Request
 * @subpackage Structs
 */
class CrossServiceSearchFacade_Request extends AbstractStructBase
{
    /**
     * The CriteriaVector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CriteriaVector
     */
    public $CriteriaVector;
    /**
     * The ExpectedOutputTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $ExpectedOutputTypes;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $Options;
    /**
     * Constructor method for CrossServiceSearchFacade-Request
     * @uses CrossServiceSearchFacade_Request::setCriteriaVector()
     * @uses CrossServiceSearchFacade_Request::setExpectedOutputTypes()
     * @uses CrossServiceSearchFacade_Request::setOptions()
     * @param \patest\StructType\CriteriaVector $criteriaVector
     * @param string[] $expectedOutputTypes
     * @param string[] $options
     */
    public function __construct(\patest\StructType\CriteriaVector $criteriaVector = null, array $expectedOutputTypes = array(), array $options = array())
    {
        $this
            ->setCriteriaVector($criteriaVector)
            ->setExpectedOutputTypes($expectedOutputTypes)
            ->setOptions($options);
    }
    /**
     * Get CriteriaVector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CriteriaVector|null
     */
    public function getCriteriaVector()
    {
        return isset($this->CriteriaVector) ? $this->CriteriaVector : null;
    }
    /**
     * Set CriteriaVector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CriteriaVector $criteriaVector
     * @return \patest\StructType\CrossServiceSearchFacade_Request
     */
    public function setCriteriaVector(\patest\StructType\CriteriaVector $criteriaVector = null)
    {
        if (is_null($criteriaVector) || (is_array($criteriaVector) && empty($criteriaVector))) {
            unset($this->CriteriaVector);
        } else {
            $this->CriteriaVector = $criteriaVector;
        }
        return $this;
    }
    /**
     * Get ExpectedOutputTypes value
     * @return string[]|null
     */
    public function getExpectedOutputTypes()
    {
        return $this->ExpectedOutputTypes;
    }
    /**
     * This method is responsible for validating the values passed to the setExpectedOutputTypes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpectedOutputTypes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpectedOutputTypesForArrayConstraintsFromSetExpectedOutputTypes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crossServiceSearchFacade_RequestExpectedOutputTypesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\SearchOutputDataTypes::valueIsValid($crossServiceSearchFacade_RequestExpectedOutputTypesItem)) {
                $invalidValues[] = is_object($crossServiceSearchFacade_RequestExpectedOutputTypesItem) ? get_class($crossServiceSearchFacade_RequestExpectedOutputTypesItem) : sprintf('%s(%s)', gettype($crossServiceSearchFacade_RequestExpectedOutputTypesItem), var_export($crossServiceSearchFacade_RequestExpectedOutputTypesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SearchOutputDataTypes', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\SearchOutputDataTypes::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExpectedOutputTypes value
     * @uses \patest\EnumType\SearchOutputDataTypes::valueIsValid()
     * @uses \patest\EnumType\SearchOutputDataTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $expectedOutputTypes
     * @return \patest\StructType\CrossServiceSearchFacade_Request
     */
    public function setExpectedOutputTypes(array $expectedOutputTypes = array())
    {
        // validation for constraint: list
        if ('' !== ($expectedOutputTypesArrayErrorMessage = self::validateExpectedOutputTypesForArrayConstraintsFromSetExpectedOutputTypes($expectedOutputTypes))) {
            throw new \InvalidArgumentException($expectedOutputTypesArrayErrorMessage, __LINE__);
        }
        $this->ExpectedOutputTypes = is_array($expectedOutputTypes) ? implode(' ', $expectedOutputTypes) : null;
        return $this;
    }
    /**
     * Get Options value
     * @return string[]|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * This method is responsible for validating the values passed to the setOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionsForArrayConstraintsFromSetOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crossServiceSearchFacade_RequestOptionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrossServiceSearchOprtions::valueIsValid($crossServiceSearchFacade_RequestOptionsItem)) {
                $invalidValues[] = is_object($crossServiceSearchFacade_RequestOptionsItem) ? get_class($crossServiceSearchFacade_RequestOptionsItem) : sprintf('%s(%s)', gettype($crossServiceSearchFacade_RequestOptionsItem), var_export($crossServiceSearchFacade_RequestOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrossServiceSearchOprtions', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrossServiceSearchOprtions::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Options value
     * @uses \patest\EnumType\CrossServiceSearchOprtions::valueIsValid()
     * @uses \patest\EnumType\CrossServiceSearchOprtions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $options
     * @return \patest\StructType\CrossServiceSearchFacade_Request
     */
    public function setOptions(array $options = array())
    {
        // validation for constraint: list
        if ('' !== ($optionsArrayErrorMessage = self::validateOptionsForArrayConstraintsFromSetOptions($options))) {
            throw new \InvalidArgumentException($optionsArrayErrorMessage, __LINE__);
        }
        $this->Options = is_array($options) ? implode(' ', $options) : null;
        return $this;
    }
}
