<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.TicketSchemeClientEnrollmentFilter StructType
 * @subpackage Structs
 */
class Crm_TicketSchemeClientEnrollmentFilter extends FilterEntity
{
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DayOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DayOfWeek;
    /**
     * The EnrollmentDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnrollmentDateFrom;
    /**
     * The EnrollmentDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnrollmentDateTo;
    /**
     * The EnrollmentSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrollmentSchemeId;
    /**
     * The EventDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateFrom;
    /**
     * The EventDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateTo;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The PaymentDetailsCredit
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentDetailsCredit;
    /**
     * The PaymentDetailsDirectDebit
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentDetailsDirectDebit;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethods;
    /**
     * The PaymentTokenStateSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentTokenStateSelection;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelIds
     */
    public $PriceLevelIds;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The ShowIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowIds
     */
    public $ShowIds;
    /**
     * The StandIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\StandIds
     */
    public $StandIds;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * Constructor method for Crm.TicketSchemeClientEnrollmentFilter
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setAreaIds()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setClientId()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setDayOfWeek()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setEnrollmentDateFrom()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setEnrollmentDateTo()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setEnrollmentSchemeId()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setEventDateFrom()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setEventDateTo()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setIsActive()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setPaymentDetailsCredit()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setPaymentDetailsDirectDebit()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setPaymentMethodId()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setPaymentMethods()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setPaymentTokenStateSelection()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setPriceLevelIds()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setRowName()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setSeasonId()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setSeatName()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setSectorName()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setSeriesId()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setShowIds()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setStandIds()
     * @uses Crm_TicketSchemeClientEnrollmentFilter::setSubscriptionNumber()
     * @param \patest\StructType\AreaIds $areaIds
     * @param string $clientId
     * @param string $dayOfWeek
     * @param string $enrollmentDateFrom
     * @param string $enrollmentDateTo
     * @param string $enrollmentSchemeId
     * @param string $eventDateFrom
     * @param string $eventDateTo
     * @param bool $isActive
     * @param string $paymentDetailsCredit
     * @param string $paymentDetailsDirectDebit
     * @param string $paymentMethodId
     * @param string $paymentMethods
     * @param string $paymentTokenStateSelection
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @param string $rowName
     * @param string $seasonId
     * @param string $seatName
     * @param string $sectorName
     * @param string $seriesId
     * @param \patest\StructType\ShowIds $showIds
     * @param \patest\StructType\StandIds $standIds
     * @param string $subscriptionNumber
     */
    public function __construct(\patest\StructType\AreaIds $areaIds = null, $clientId = null, $dayOfWeek = null, $enrollmentDateFrom = null, $enrollmentDateTo = null, $enrollmentSchemeId = null, $eventDateFrom = null, $eventDateTo = null, $isActive = null, $paymentDetailsCredit = null, $paymentDetailsDirectDebit = null, $paymentMethodId = null, $paymentMethods = null, $paymentTokenStateSelection = null, \patest\StructType\PriceLevelIds $priceLevelIds = null, $rowName = null, $seasonId = null, $seatName = null, $sectorName = null, $seriesId = null, \patest\StructType\ShowIds $showIds = null, \patest\StructType\StandIds $standIds = null, $subscriptionNumber = null)
    {
        $this
            ->setAreaIds($areaIds)
            ->setClientId($clientId)
            ->setDayOfWeek($dayOfWeek)
            ->setEnrollmentDateFrom($enrollmentDateFrom)
            ->setEnrollmentDateTo($enrollmentDateTo)
            ->setEnrollmentSchemeId($enrollmentSchemeId)
            ->setEventDateFrom($eventDateFrom)
            ->setEventDateTo($eventDateTo)
            ->setIsActive($isActive)
            ->setPaymentDetailsCredit($paymentDetailsCredit)
            ->setPaymentDetailsDirectDebit($paymentDetailsDirectDebit)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethods($paymentMethods)
            ->setPaymentTokenStateSelection($paymentTokenStateSelection)
            ->setPriceLevelIds($priceLevelIds)
            ->setRowName($rowName)
            ->setSeasonId($seasonId)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setSeriesId($seriesId)
            ->setShowIds($showIds)
            ->setStandIds($standIds)
            ->setSubscriptionNumber($subscriptionNumber);
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DayOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDayOfWeek()
    {
        return isset($this->DayOfWeek) ? $this->DayOfWeek : null;
    }
    /**
     * Set DayOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dayOfWeek
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($dayOfWeek) && !is_string($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dayOfWeek, true), gettype($dayOfWeek)), __LINE__);
        }
        if (is_null($dayOfWeek) || (is_array($dayOfWeek) && empty($dayOfWeek))) {
            unset($this->DayOfWeek);
        } else {
            $this->DayOfWeek = $dayOfWeek;
        }
        return $this;
    }
    /**
     * Get EnrollmentDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrollmentDateFrom()
    {
        return isset($this->EnrollmentDateFrom) ? $this->EnrollmentDateFrom : null;
    }
    /**
     * Set EnrollmentDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrollmentDateFrom
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setEnrollmentDateFrom($enrollmentDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentDateFrom) && !is_string($enrollmentDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrollmentDateFrom, true), gettype($enrollmentDateFrom)), __LINE__);
        }
        if (is_null($enrollmentDateFrom) || (is_array($enrollmentDateFrom) && empty($enrollmentDateFrom))) {
            unset($this->EnrollmentDateFrom);
        } else {
            $this->EnrollmentDateFrom = $enrollmentDateFrom;
        }
        return $this;
    }
    /**
     * Get EnrollmentDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrollmentDateTo()
    {
        return isset($this->EnrollmentDateTo) ? $this->EnrollmentDateTo : null;
    }
    /**
     * Set EnrollmentDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrollmentDateTo
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setEnrollmentDateTo($enrollmentDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentDateTo) && !is_string($enrollmentDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrollmentDateTo, true), gettype($enrollmentDateTo)), __LINE__);
        }
        if (is_null($enrollmentDateTo) || (is_array($enrollmentDateTo) && empty($enrollmentDateTo))) {
            unset($this->EnrollmentDateTo);
        } else {
            $this->EnrollmentDateTo = $enrollmentDateTo;
        }
        return $this;
    }
    /**
     * Get EnrollmentSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrollmentSchemeId()
    {
        return isset($this->EnrollmentSchemeId) ? $this->EnrollmentSchemeId : null;
    }
    /**
     * Set EnrollmentSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrollmentSchemeId
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setEnrollmentSchemeId($enrollmentSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentSchemeId) && !is_string($enrollmentSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrollmentSchemeId, true), gettype($enrollmentSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($enrollmentSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrollmentSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($enrollmentSchemeId, true)), __LINE__);
        }
        if (is_null($enrollmentSchemeId) || (is_array($enrollmentSchemeId) && empty($enrollmentSchemeId))) {
            unset($this->EnrollmentSchemeId);
        } else {
            $this->EnrollmentSchemeId = $enrollmentSchemeId;
        }
        return $this;
    }
    /**
     * Get EventDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateFrom()
    {
        return isset($this->EventDateFrom) ? $this->EventDateFrom : null;
    }
    /**
     * Set EventDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateFrom
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setEventDateFrom($eventDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateFrom) && !is_string($eventDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateFrom, true), gettype($eventDateFrom)), __LINE__);
        }
        if (is_null($eventDateFrom) || (is_array($eventDateFrom) && empty($eventDateFrom))) {
            unset($this->EventDateFrom);
        } else {
            $this->EventDateFrom = $eventDateFrom;
        }
        return $this;
    }
    /**
     * Get EventDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateTo()
    {
        return isset($this->EventDateTo) ? $this->EventDateTo : null;
    }
    /**
     * Set EventDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateTo
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setEventDateTo($eventDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateTo) && !is_string($eventDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateTo, true), gettype($eventDateTo)), __LINE__);
        }
        if (is_null($eventDateTo) || (is_array($eventDateTo) && empty($eventDateTo))) {
            unset($this->EventDateTo);
        } else {
            $this->EventDateTo = $eventDateTo;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get PaymentDetailsCredit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDetailsCredit()
    {
        return isset($this->PaymentDetailsCredit) ? $this->PaymentDetailsCredit : null;
    }
    /**
     * Set PaymentDetailsCredit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDetailsCredit
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setPaymentDetailsCredit($paymentDetailsCredit = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetailsCredit) && !is_string($paymentDetailsCredit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetailsCredit, true), gettype($paymentDetailsCredit)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentDetailsCredit) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentDetailsCredit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentDetailsCredit, true)), __LINE__);
        }
        if (is_null($paymentDetailsCredit) || (is_array($paymentDetailsCredit) && empty($paymentDetailsCredit))) {
            unset($this->PaymentDetailsCredit);
        } else {
            $this->PaymentDetailsCredit = $paymentDetailsCredit;
        }
        return $this;
    }
    /**
     * Get PaymentDetailsDirectDebit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDetailsDirectDebit()
    {
        return isset($this->PaymentDetailsDirectDebit) ? $this->PaymentDetailsDirectDebit : null;
    }
    /**
     * Set PaymentDetailsDirectDebit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDetailsDirectDebit
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setPaymentDetailsDirectDebit($paymentDetailsDirectDebit = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetailsDirectDebit) && !is_string($paymentDetailsDirectDebit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetailsDirectDebit, true), gettype($paymentDetailsDirectDebit)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentDetailsDirectDebit) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentDetailsDirectDebit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentDetailsDirectDebit, true)), __LINE__);
        }
        if (is_null($paymentDetailsDirectDebit) || (is_array($paymentDetailsDirectDebit) && empty($paymentDetailsDirectDebit))) {
            unset($this->PaymentDetailsDirectDebit);
        } else {
            $this->PaymentDetailsDirectDebit = $paymentDetailsDirectDebit;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethods()
    {
        return isset($this->PaymentMethods) ? $this->PaymentMethods : null;
    }
    /**
     * Set PaymentMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketSchemePaymentMethods::valueIsValid()
     * @uses \patest\EnumType\TicketSchemePaymentMethods::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethods
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setPaymentMethods($paymentMethods = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketSchemePaymentMethods::valueIsValid($paymentMethods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketSchemePaymentMethods', is_array($paymentMethods) ? implode(', ', $paymentMethods) : var_export($paymentMethods, true), implode(', ', \patest\EnumType\TicketSchemePaymentMethods::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethods) || (is_array($paymentMethods) && empty($paymentMethods))) {
            unset($this->PaymentMethods);
        } else {
            $this->PaymentMethods = $paymentMethods;
        }
        return $this;
    }
    /**
     * Get PaymentTokenStateSelection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenStateSelection()
    {
        return isset($this->PaymentTokenStateSelection) ? $this->PaymentTokenStateSelection : null;
    }
    /**
     * Set PaymentTokenStateSelection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentTokenStateSelection::valueIsValid()
     * @uses \patest\EnumType\PaymentTokenStateSelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentTokenStateSelection
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setPaymentTokenStateSelection($paymentTokenStateSelection = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentTokenStateSelection::valueIsValid($paymentTokenStateSelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentTokenStateSelection', is_array($paymentTokenStateSelection) ? implode(', ', $paymentTokenStateSelection) : var_export($paymentTokenStateSelection, true), implode(', ', \patest\EnumType\PaymentTokenStateSelection::getValidValues())), __LINE__);
        }
        if (is_null($paymentTokenStateSelection) || (is_array($paymentTokenStateSelection) && empty($paymentTokenStateSelection))) {
            unset($this->PaymentTokenStateSelection);
        } else {
            $this->PaymentTokenStateSelection = $paymentTokenStateSelection;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelIds|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setPriceLevelIds(\patest\StructType\PriceLevelIds $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get ShowIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowIds|null
     */
    public function getShowIds()
    {
        return isset($this->ShowIds) ? $this->ShowIds : null;
    }
    /**
     * Set ShowIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ShowIds $showIds
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setShowIds(\patest\StructType\ShowIds $showIds = null)
    {
        if (is_null($showIds) || (is_array($showIds) && empty($showIds))) {
            unset($this->ShowIds);
        } else {
            $this->ShowIds = $showIds;
        }
        return $this;
    }
    /**
     * Get StandIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\StandIds|null
     */
    public function getStandIds()
    {
        return isset($this->StandIds) ? $this->StandIds : null;
    }
    /**
     * Set StandIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\StandIds $standIds
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setStandIds(\patest\StructType\StandIds $standIds = null)
    {
        if (is_null($standIds) || (is_array($standIds) && empty($standIds))) {
            unset($this->StandIds);
        } else {
            $this->StandIds = $standIds;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Crm_TicketSchemeClientEnrollmentFilter
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
}
