<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.SimplifiedCustomer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Crm.SimplifiedCustomer
 * @subpackage Structs
 */
class Crm_SimplifiedCustomer extends Crm_SimplifiedClient
{
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Age;
    /**
     * The Birthday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Birthday;
    /**
     * The BlackListItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_CustomerBlackListItem
     */
    public $BlackListItems;
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardId;
    /**
     * The DateOfDeath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfDeath;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The GeoDemographicCodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GeoDemographicCodeId;
    /**
     * The IsDeceased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeceased;
    /**
     * The JobTitleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $JobTitleId;
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_LoginDetail
     */
    public $Login;
    /**
     * The LoyaltyPointsBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LoyaltyPointsBalance;
    /**
     * The MaritalStatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MaritalStatusId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_PersonName
     */
    public $Name;
    /**
     * The TitleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TitleId;
    /**
     * The WorkPlace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkPlace;
    /**
     * Constructor method for Crm.SimplifiedCustomer
     * @uses Crm_SimplifiedCustomer::setAge()
     * @uses Crm_SimplifiedCustomer::setBirthday()
     * @uses Crm_SimplifiedCustomer::setBlackListItems()
     * @uses Crm_SimplifiedCustomer::setCardId()
     * @uses Crm_SimplifiedCustomer::setDateOfDeath()
     * @uses Crm_SimplifiedCustomer::setGender()
     * @uses Crm_SimplifiedCustomer::setGeoDemographicCodeId()
     * @uses Crm_SimplifiedCustomer::setIsDeceased()
     * @uses Crm_SimplifiedCustomer::setJobTitleId()
     * @uses Crm_SimplifiedCustomer::setLogin()
     * @uses Crm_SimplifiedCustomer::setLoyaltyPointsBalance()
     * @uses Crm_SimplifiedCustomer::setMaritalStatusId()
     * @uses Crm_SimplifiedCustomer::setName()
     * @uses Crm_SimplifiedCustomer::setTitleId()
     * @uses Crm_SimplifiedCustomer::setWorkPlace()
     * @param int $age
     * @param string $birthday
     * @param \patest\StructType\RecordSetOfCrm_CustomerBlackListItem $blackListItems
     * @param string $cardId
     * @param string $dateOfDeath
     * @param string $gender
     * @param string $geoDemographicCodeId
     * @param bool $isDeceased
     * @param string $jobTitleId
     * @param \patest\StructType\Crm_LoginDetail $login
     * @param float $loyaltyPointsBalance
     * @param string $maritalStatusId
     * @param \patest\StructType\Crm_PersonName $name
     * @param string $titleId
     * @param string $workPlace
     */
    public function __construct($age = null, $birthday = null, \patest\StructType\RecordSetOfCrm_CustomerBlackListItem $blackListItems = null, $cardId = null, $dateOfDeath = null, $gender = null, $geoDemographicCodeId = null, $isDeceased = null, $jobTitleId = null, \patest\StructType\Crm_LoginDetail $login = null, $loyaltyPointsBalance = null, $maritalStatusId = null, \patest\StructType\Crm_PersonName $name = null, $titleId = null, $workPlace = null)
    {
        $this
            ->setAge($age)
            ->setBirthday($birthday)
            ->setBlackListItems($blackListItems)
            ->setCardId($cardId)
            ->setDateOfDeath($dateOfDeath)
            ->setGender($gender)
            ->setGeoDemographicCodeId($geoDemographicCodeId)
            ->setIsDeceased($isDeceased)
            ->setJobTitleId($jobTitleId)
            ->setLogin($login)
            ->setLoyaltyPointsBalance($loyaltyPointsBalance)
            ->setMaritalStatusId($maritalStatusId)
            ->setName($name)
            ->setTitleId($titleId)
            ->setWorkPlace($workPlace);
    }
    /**
     * Get Age value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAge()
    {
        return isset($this->Age) ? $this->Age : null;
    }
    /**
     * Set Age value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $age
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        if (is_null($age) || (is_array($age) && empty($age))) {
            unset($this->Age);
        } else {
            $this->Age = $age;
        }
        return $this;
    }
    /**
     * Get Birthday value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthday()
    {
        return isset($this->Birthday) ? $this->Birthday : null;
    }
    /**
     * Set Birthday value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthday
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthday, true), gettype($birthday)), __LINE__);
        }
        if (is_null($birthday) || (is_array($birthday) && empty($birthday))) {
            unset($this->Birthday);
        } else {
            $this->Birthday = $birthday;
        }
        return $this;
    }
    /**
     * Get BlackListItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_CustomerBlackListItem|null
     */
    public function getBlackListItems()
    {
        return isset($this->BlackListItems) ? $this->BlackListItems : null;
    }
    /**
     * Set BlackListItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_CustomerBlackListItem $blackListItems
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setBlackListItems(\patest\StructType\RecordSetOfCrm_CustomerBlackListItem $blackListItems = null)
    {
        if (is_null($blackListItems) || (is_array($blackListItems) && empty($blackListItems))) {
            unset($this->BlackListItems);
        } else {
            $this->BlackListItems = $blackListItems;
        }
        return $this;
    }
    /**
     * Get CardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardId()
    {
        return isset($this->CardId) ? $this->CardId : null;
    }
    /**
     * Set CardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardId
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        if (is_null($cardId) || (is_array($cardId) && empty($cardId))) {
            unset($this->CardId);
        } else {
            $this->CardId = $cardId;
        }
        return $this;
    }
    /**
     * Get DateOfDeath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfDeath()
    {
        return isset($this->DateOfDeath) ? $this->DateOfDeath : null;
    }
    /**
     * Set DateOfDeath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfDeath
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setDateOfDeath($dateOfDeath = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfDeath) && !is_string($dateOfDeath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfDeath, true), gettype($dateOfDeath)), __LINE__);
        }
        if (is_null($dateOfDeath) || (is_array($dateOfDeath) && empty($dateOfDeath))) {
            unset($this->DateOfDeath);
        } else {
            $this->DateOfDeath = $dateOfDeath;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GenderKind::valueIsValid()
     * @uses \patest\EnumType\GenderKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GenderKind::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GenderKind', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \patest\EnumType\GenderKind::getValidValues())), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get GeoDemographicCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeoDemographicCodeId()
    {
        return isset($this->GeoDemographicCodeId) ? $this->GeoDemographicCodeId : null;
    }
    /**
     * Set GeoDemographicCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geoDemographicCodeId
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setGeoDemographicCodeId($geoDemographicCodeId = null)
    {
        // validation for constraint: string
        if (!is_null($geoDemographicCodeId) && !is_string($geoDemographicCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geoDemographicCodeId, true), gettype($geoDemographicCodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($geoDemographicCodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $geoDemographicCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($geoDemographicCodeId, true)), __LINE__);
        }
        if (is_null($geoDemographicCodeId) || (is_array($geoDemographicCodeId) && empty($geoDemographicCodeId))) {
            unset($this->GeoDemographicCodeId);
        } else {
            $this->GeoDemographicCodeId = $geoDemographicCodeId;
        }
        return $this;
    }
    /**
     * Get IsDeceased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeceased()
    {
        return isset($this->IsDeceased) ? $this->IsDeceased : null;
    }
    /**
     * Set IsDeceased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeceased
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setIsDeceased($isDeceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeceased) && !is_bool($isDeceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeceased, true), gettype($isDeceased)), __LINE__);
        }
        if (is_null($isDeceased) || (is_array($isDeceased) && empty($isDeceased))) {
            unset($this->IsDeceased);
        } else {
            $this->IsDeceased = $isDeceased;
        }
        return $this;
    }
    /**
     * Get JobTitleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobTitleId()
    {
        return isset($this->JobTitleId) ? $this->JobTitleId : null;
    }
    /**
     * Set JobTitleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jobTitleId
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setJobTitleId($jobTitleId = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitleId) && !is_string($jobTitleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobTitleId, true), gettype($jobTitleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($jobTitleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $jobTitleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($jobTitleId, true)), __LINE__);
        }
        if (is_null($jobTitleId) || (is_array($jobTitleId) && empty($jobTitleId))) {
            unset($this->JobTitleId);
        } else {
            $this->JobTitleId = $jobTitleId;
        }
        return $this;
    }
    /**
     * Get Login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_LoginDetail|null
     */
    public function getLogin()
    {
        return isset($this->Login) ? $this->Login : null;
    }
    /**
     * Set Login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_LoginDetail $login
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setLogin(\patest\StructType\Crm_LoginDetail $login = null)
    {
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->Login);
        } else {
            $this->Login = $login;
        }
        return $this;
    }
    /**
     * Get LoyaltyPointsBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLoyaltyPointsBalance()
    {
        return isset($this->LoyaltyPointsBalance) ? $this->LoyaltyPointsBalance : null;
    }
    /**
     * Set LoyaltyPointsBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $loyaltyPointsBalance
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setLoyaltyPointsBalance($loyaltyPointsBalance = null)
    {
        // validation for constraint: float
        if (!is_null($loyaltyPointsBalance) && !(is_float($loyaltyPointsBalance) || is_numeric($loyaltyPointsBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loyaltyPointsBalance, true), gettype($loyaltyPointsBalance)), __LINE__);
        }
        if (is_null($loyaltyPointsBalance) || (is_array($loyaltyPointsBalance) && empty($loyaltyPointsBalance))) {
            unset($this->LoyaltyPointsBalance);
        } else {
            $this->LoyaltyPointsBalance = $loyaltyPointsBalance;
        }
        return $this;
    }
    /**
     * Get MaritalStatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaritalStatusId()
    {
        return isset($this->MaritalStatusId) ? $this->MaritalStatusId : null;
    }
    /**
     * Set MaritalStatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maritalStatusId
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setMaritalStatusId($maritalStatusId = null)
    {
        // validation for constraint: string
        if (!is_null($maritalStatusId) && !is_string($maritalStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maritalStatusId, true), gettype($maritalStatusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($maritalStatusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $maritalStatusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($maritalStatusId, true)), __LINE__);
        }
        if (is_null($maritalStatusId) || (is_array($maritalStatusId) && empty($maritalStatusId))) {
            unset($this->MaritalStatusId);
        } else {
            $this->MaritalStatusId = $maritalStatusId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_PersonName|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_PersonName $name
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setName(\patest\StructType\Crm_PersonName $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get TitleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitleId()
    {
        return isset($this->TitleId) ? $this->TitleId : null;
    }
    /**
     * Set TitleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titleId
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setTitleId($titleId = null)
    {
        // validation for constraint: string
        if (!is_null($titleId) && !is_string($titleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titleId, true), gettype($titleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($titleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $titleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($titleId, true)), __LINE__);
        }
        if (is_null($titleId) || (is_array($titleId) && empty($titleId))) {
            unset($this->TitleId);
        } else {
            $this->TitleId = $titleId;
        }
        return $this;
    }
    /**
     * Get WorkPlace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkPlace()
    {
        return isset($this->WorkPlace) ? $this->WorkPlace : null;
    }
    /**
     * Set WorkPlace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workPlace
     * @return \patest\StructType\Crm_SimplifiedCustomer
     */
    public function setWorkPlace($workPlace = null)
    {
        // validation for constraint: string
        if (!is_null($workPlace) && !is_string($workPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPlace, true), gettype($workPlace)), __LINE__);
        }
        if (is_null($workPlace) || (is_array($workPlace) && empty($workPlace))) {
            unset($this->WorkPlace);
        } else {
            $this->WorkPlace = $workPlace;
        }
        return $this;
    }
}
