<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm-ResetPassword-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Crm-ResetPassword-Request
 * @subpackage Structs
 */
class Crm_ResetPassword_Request extends AbstractStructBase
{
    /**
     * The ForceResetPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ForceResetPassword;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginName;
    /**
     * Constructor method for Crm-ResetPassword-Request
     * @uses Crm_ResetPassword_Request::setForceResetPassword()
     * @uses Crm_ResetPassword_Request::setLoginName()
     * @param bool $forceResetPassword
     * @param string $loginName
     */
    public function __construct($forceResetPassword = null, $loginName = null)
    {
        $this
            ->setForceResetPassword($forceResetPassword)
            ->setLoginName($loginName);
    }
    /**
     * Get ForceResetPassword value
     * @return bool|null
     */
    public function getForceResetPassword()
    {
        return $this->ForceResetPassword;
    }
    /**
     * Set ForceResetPassword value
     * @param bool $forceResetPassword
     * @return \patest\StructType\Crm_ResetPassword_Request
     */
    public function setForceResetPassword($forceResetPassword = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceResetPassword) && !is_bool($forceResetPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceResetPassword, true), gettype($forceResetPassword)), __LINE__);
        }
        $this->ForceResetPassword = $forceResetPassword;
        return $this;
    }
    /**
     * Get LoginName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginName()
    {
        return isset($this->LoginName) ? $this->LoginName : null;
    }
    /**
     * Set LoginName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginName
     * @return \patest\StructType\Crm_ResetPassword_Request
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        if (is_null($loginName) || (is_array($loginName) && empty($loginName))) {
            unset($this->LoginName);
        } else {
            $this->LoginName = $loginName;
        }
        return $this;
    }
}
