<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.PostalAddress StructType
 * @subpackage Structs
 */
class Crm_PostalAddress extends AnyEntity
{
    /**
     * The AddressDetailTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddressDetailTypeId;
    /**
     * The AddressLine1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine2;
    /**
     * The AddressLine3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine3;
    /**
     * The AddressLine4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine4;
    /**
     * The AddressLine5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine5;
    /**
     * The CityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CityId;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CityName;
    /**
     * The CityNameOrId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityNameOrId;
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CountryId;
    /**
     * The CountryIsoCode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryIsoCode;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CountryName;
    /**
     * The CountryNameOrId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryNameOrId;
    /**
     * The FormattedForDisplay
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedForDisplay;
    /**
     * The FormattedForDisplayForActivity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedForDisplayForActivity;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The NonSpacesZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NonSpacesZipCode;
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RegionId;
    /**
     * The RegionName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $RegionName;
    /**
     * The StateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StateId;
    /**
     * The StateIsoCode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateIsoCode;
    /**
     * The StateName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $StateName;
    /**
     * The StateNameOrId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateNameOrId;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * The ZipCodeSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCodeSource;
    /**
     * Constructor method for Crm.PostalAddress
     * @uses Crm_PostalAddress::setAddressDetailTypeId()
     * @uses Crm_PostalAddress::setAddressLine1()
     * @uses Crm_PostalAddress::setAddressLine2()
     * @uses Crm_PostalAddress::setAddressLine3()
     * @uses Crm_PostalAddress::setAddressLine4()
     * @uses Crm_PostalAddress::setAddressLine5()
     * @uses Crm_PostalAddress::setCityId()
     * @uses Crm_PostalAddress::setCityName()
     * @uses Crm_PostalAddress::setCityNameOrId()
     * @uses Crm_PostalAddress::setCountryId()
     * @uses Crm_PostalAddress::setCountryIsoCode()
     * @uses Crm_PostalAddress::setCountryName()
     * @uses Crm_PostalAddress::setCountryNameOrId()
     * @uses Crm_PostalAddress::setFormattedForDisplay()
     * @uses Crm_PostalAddress::setFormattedForDisplayForActivity()
     * @uses Crm_PostalAddress::setId()
     * @uses Crm_PostalAddress::setNonSpacesZipCode()
     * @uses Crm_PostalAddress::setRegionId()
     * @uses Crm_PostalAddress::setRegionName()
     * @uses Crm_PostalAddress::setStateId()
     * @uses Crm_PostalAddress::setStateIsoCode()
     * @uses Crm_PostalAddress::setStateName()
     * @uses Crm_PostalAddress::setStateNameOrId()
     * @uses Crm_PostalAddress::setZipCode()
     * @uses Crm_PostalAddress::setZipCodeSource()
     * @param string $addressDetailTypeId
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $addressLine4
     * @param string $addressLine5
     * @param string $cityId
     * @param \patest\StructType\GlobalString $cityName
     * @param string $cityNameOrId
     * @param string $countryId
     * @param string $countryIsoCode
     * @param \patest\StructType\GlobalString $countryName
     * @param string $countryNameOrId
     * @param string $formattedForDisplay
     * @param string $formattedForDisplayForActivity
     * @param string $id
     * @param string $nonSpacesZipCode
     * @param string $regionId
     * @param \patest\StructType\GlobalString $regionName
     * @param string $stateId
     * @param string $stateIsoCode
     * @param \patest\StructType\GlobalString $stateName
     * @param string $stateNameOrId
     * @param string $zipCode
     * @param string $zipCodeSource
     */
    public function __construct($addressDetailTypeId = null, $addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $addressLine4 = null, $addressLine5 = null, $cityId = null, \patest\StructType\GlobalString $cityName = null, $cityNameOrId = null, $countryId = null, $countryIsoCode = null, \patest\StructType\GlobalString $countryName = null, $countryNameOrId = null, $formattedForDisplay = null, $formattedForDisplayForActivity = null, $id = null, $nonSpacesZipCode = null, $regionId = null, \patest\StructType\GlobalString $regionName = null, $stateId = null, $stateIsoCode = null, \patest\StructType\GlobalString $stateName = null, $stateNameOrId = null, $zipCode = null, $zipCodeSource = null)
    {
        $this
            ->setAddressDetailTypeId($addressDetailTypeId)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setAddressLine4($addressLine4)
            ->setAddressLine5($addressLine5)
            ->setCityId($cityId)
            ->setCityName($cityName)
            ->setCityNameOrId($cityNameOrId)
            ->setCountryId($countryId)
            ->setCountryIsoCode($countryIsoCode)
            ->setCountryName($countryName)
            ->setCountryNameOrId($countryNameOrId)
            ->setFormattedForDisplay($formattedForDisplay)
            ->setFormattedForDisplayForActivity($formattedForDisplayForActivity)
            ->setId($id)
            ->setNonSpacesZipCode($nonSpacesZipCode)
            ->setRegionId($regionId)
            ->setRegionName($regionName)
            ->setStateId($stateId)
            ->setStateIsoCode($stateIsoCode)
            ->setStateName($stateName)
            ->setStateNameOrId($stateNameOrId)
            ->setZipCode($zipCode)
            ->setZipCodeSource($zipCodeSource);
    }
    /**
     * Get AddressDetailTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressDetailTypeId()
    {
        return isset($this->AddressDetailTypeId) ? $this->AddressDetailTypeId : null;
    }
    /**
     * Set AddressDetailTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressDetailTypeId
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setAddressDetailTypeId($addressDetailTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($addressDetailTypeId) && !is_string($addressDetailTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressDetailTypeId, true), gettype($addressDetailTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($addressDetailTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addressDetailTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($addressDetailTypeId, true)), __LINE__);
        }
        if (is_null($addressDetailTypeId) || (is_array($addressDetailTypeId) && empty($addressDetailTypeId))) {
            unset($this->AddressDetailTypeId);
        } else {
            $this->AddressDetailTypeId = $addressDetailTypeId;
        }
        return $this;
    }
    /**
     * Get AddressLine1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine1()
    {
        return isset($this->AddressLine1) ? $this->AddressLine1 : null;
    }
    /**
     * Set AddressLine1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine1
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        if (is_null($addressLine1) || (is_array($addressLine1) && empty($addressLine1))) {
            unset($this->AddressLine1);
        } else {
            $this->AddressLine1 = $addressLine1;
        }
        return $this;
    }
    /**
     * Get AddressLine2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine2()
    {
        return isset($this->AddressLine2) ? $this->AddressLine2 : null;
    }
    /**
     * Set AddressLine2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine2
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        if (is_null($addressLine2) || (is_array($addressLine2) && empty($addressLine2))) {
            unset($this->AddressLine2);
        } else {
            $this->AddressLine2 = $addressLine2;
        }
        return $this;
    }
    /**
     * Get AddressLine3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine3()
    {
        return isset($this->AddressLine3) ? $this->AddressLine3 : null;
    }
    /**
     * Set AddressLine3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine3
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine3, true), gettype($addressLine3)), __LINE__);
        }
        if (is_null($addressLine3) || (is_array($addressLine3) && empty($addressLine3))) {
            unset($this->AddressLine3);
        } else {
            $this->AddressLine3 = $addressLine3;
        }
        return $this;
    }
    /**
     * Get AddressLine4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine4()
    {
        return isset($this->AddressLine4) ? $this->AddressLine4 : null;
    }
    /**
     * Set AddressLine4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine4
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setAddressLine4($addressLine4 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine4) && !is_string($addressLine4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine4, true), gettype($addressLine4)), __LINE__);
        }
        if (is_null($addressLine4) || (is_array($addressLine4) && empty($addressLine4))) {
            unset($this->AddressLine4);
        } else {
            $this->AddressLine4 = $addressLine4;
        }
        return $this;
    }
    /**
     * Get AddressLine5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine5()
    {
        return isset($this->AddressLine5) ? $this->AddressLine5 : null;
    }
    /**
     * Set AddressLine5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine5
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setAddressLine5($addressLine5 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine5) && !is_string($addressLine5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine5, true), gettype($addressLine5)), __LINE__);
        }
        if (is_null($addressLine5) || (is_array($addressLine5) && empty($addressLine5))) {
            unset($this->AddressLine5);
        } else {
            $this->AddressLine5 = $addressLine5;
        }
        return $this;
    }
    /**
     * Get CityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityId()
    {
        return isset($this->CityId) ? $this->CityId : null;
    }
    /**
     * Set CityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityId
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: string
        if (!is_null($cityId) && !is_string($cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityId, true), gettype($cityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cityId, true)), __LINE__);
        }
        if (is_null($cityId) || (is_array($cityId) && empty($cityId))) {
            unset($this->CityId);
        } else {
            $this->CityId = $cityId;
        }
        return $this;
    }
    /**
     * Get CityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCityName()
    {
        return isset($this->CityName) ? $this->CityName : null;
    }
    /**
     * Set CityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $cityName
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setCityName(\patest\StructType\GlobalString $cityName = null)
    {
        if (is_null($cityName) || (is_array($cityName) && empty($cityName))) {
            unset($this->CityName);
        } else {
            $this->CityName = $cityName;
        }
        return $this;
    }
    /**
     * Get CityNameOrId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityNameOrId()
    {
        return isset($this->CityNameOrId) ? $this->CityNameOrId : null;
    }
    /**
     * Set CityNameOrId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityNameOrId
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setCityNameOrId($cityNameOrId = null)
    {
        // validation for constraint: string
        if (!is_null($cityNameOrId) && !is_string($cityNameOrId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityNameOrId, true), gettype($cityNameOrId)), __LINE__);
        }
        if (is_null($cityNameOrId) || (is_array($cityNameOrId) && empty($cityNameOrId))) {
            unset($this->CityNameOrId);
        } else {
            $this->CityNameOrId = $cityNameOrId;
        }
        return $this;
    }
    /**
     * Get CountryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryId()
    {
        return isset($this->CountryId) ? $this->CountryId : null;
    }
    /**
     * Set CountryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryId
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: string
        if (!is_null($countryId) && !is_string($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($countryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($countryId, true)), __LINE__);
        }
        if (is_null($countryId) || (is_array($countryId) && empty($countryId))) {
            unset($this->CountryId);
        } else {
            $this->CountryId = $countryId;
        }
        return $this;
    }
    /**
     * Get CountryIsoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryIsoCode()
    {
        return isset($this->CountryIsoCode) ? $this->CountryIsoCode : null;
    }
    /**
     * Set CountryIsoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryIsoCode
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setCountryIsoCode($countryIsoCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryIsoCode) && !is_string($countryIsoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryIsoCode, true), gettype($countryIsoCode)), __LINE__);
        }
        if (is_null($countryIsoCode) || (is_array($countryIsoCode) && empty($countryIsoCode))) {
            unset($this->CountryIsoCode);
        } else {
            $this->CountryIsoCode = $countryIsoCode;
        }
        return $this;
    }
    /**
     * Get CountryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCountryName()
    {
        return isset($this->CountryName) ? $this->CountryName : null;
    }
    /**
     * Set CountryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $countryName
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setCountryName(\patest\StructType\GlobalString $countryName = null)
    {
        if (is_null($countryName) || (is_array($countryName) && empty($countryName))) {
            unset($this->CountryName);
        } else {
            $this->CountryName = $countryName;
        }
        return $this;
    }
    /**
     * Get CountryNameOrId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryNameOrId()
    {
        return isset($this->CountryNameOrId) ? $this->CountryNameOrId : null;
    }
    /**
     * Set CountryNameOrId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryNameOrId
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setCountryNameOrId($countryNameOrId = null)
    {
        // validation for constraint: string
        if (!is_null($countryNameOrId) && !is_string($countryNameOrId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryNameOrId, true), gettype($countryNameOrId)), __LINE__);
        }
        if (is_null($countryNameOrId) || (is_array($countryNameOrId) && empty($countryNameOrId))) {
            unset($this->CountryNameOrId);
        } else {
            $this->CountryNameOrId = $countryNameOrId;
        }
        return $this;
    }
    /**
     * Get FormattedForDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedForDisplay()
    {
        return isset($this->FormattedForDisplay) ? $this->FormattedForDisplay : null;
    }
    /**
     * Set FormattedForDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedForDisplay
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setFormattedForDisplay($formattedForDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($formattedForDisplay) && !is_string($formattedForDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedForDisplay, true), gettype($formattedForDisplay)), __LINE__);
        }
        if (is_null($formattedForDisplay) || (is_array($formattedForDisplay) && empty($formattedForDisplay))) {
            unset($this->FormattedForDisplay);
        } else {
            $this->FormattedForDisplay = $formattedForDisplay;
        }
        return $this;
    }
    /**
     * Get FormattedForDisplayForActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedForDisplayForActivity()
    {
        return isset($this->FormattedForDisplayForActivity) ? $this->FormattedForDisplayForActivity : null;
    }
    /**
     * Set FormattedForDisplayForActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedForDisplayForActivity
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setFormattedForDisplayForActivity($formattedForDisplayForActivity = null)
    {
        // validation for constraint: string
        if (!is_null($formattedForDisplayForActivity) && !is_string($formattedForDisplayForActivity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedForDisplayForActivity, true), gettype($formattedForDisplayForActivity)), __LINE__);
        }
        if (is_null($formattedForDisplayForActivity) || (is_array($formattedForDisplayForActivity) && empty($formattedForDisplayForActivity))) {
            unset($this->FormattedForDisplayForActivity);
        } else {
            $this->FormattedForDisplayForActivity = $formattedForDisplayForActivity;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get NonSpacesZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNonSpacesZipCode()
    {
        return isset($this->NonSpacesZipCode) ? $this->NonSpacesZipCode : null;
    }
    /**
     * Set NonSpacesZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nonSpacesZipCode
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setNonSpacesZipCode($nonSpacesZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($nonSpacesZipCode) && !is_string($nonSpacesZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonSpacesZipCode, true), gettype($nonSpacesZipCode)), __LINE__);
        }
        if (is_null($nonSpacesZipCode) || (is_array($nonSpacesZipCode) && empty($nonSpacesZipCode))) {
            unset($this->NonSpacesZipCode);
        } else {
            $this->NonSpacesZipCode = $nonSpacesZipCode;
        }
        return $this;
    }
    /**
     * Get RegionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegionId()
    {
        return isset($this->RegionId) ? $this->RegionId : null;
    }
    /**
     * Set RegionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regionId
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setRegionId($regionId = null)
    {
        // validation for constraint: string
        if (!is_null($regionId) && !is_string($regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionId, true), gettype($regionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($regionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($regionId, true)), __LINE__);
        }
        if (is_null($regionId) || (is_array($regionId) && empty($regionId))) {
            unset($this->RegionId);
        } else {
            $this->RegionId = $regionId;
        }
        return $this;
    }
    /**
     * Get RegionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getRegionName()
    {
        return isset($this->RegionName) ? $this->RegionName : null;
    }
    /**
     * Set RegionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $regionName
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setRegionName(\patest\StructType\GlobalString $regionName = null)
    {
        if (is_null($regionName) || (is_array($regionName) && empty($regionName))) {
            unset($this->RegionName);
        } else {
            $this->RegionName = $regionName;
        }
        return $this;
    }
    /**
     * Get StateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateId()
    {
        return isset($this->StateId) ? $this->StateId : null;
    }
    /**
     * Set StateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateId
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setStateId($stateId = null)
    {
        // validation for constraint: string
        if (!is_null($stateId) && !is_string($stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateId, true), gettype($stateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stateId, true)), __LINE__);
        }
        if (is_null($stateId) || (is_array($stateId) && empty($stateId))) {
            unset($this->StateId);
        } else {
            $this->StateId = $stateId;
        }
        return $this;
    }
    /**
     * Get StateIsoCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateIsoCode()
    {
        return isset($this->StateIsoCode) ? $this->StateIsoCode : null;
    }
    /**
     * Set StateIsoCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateIsoCode
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setStateIsoCode($stateIsoCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateIsoCode) && !is_string($stateIsoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateIsoCode, true), gettype($stateIsoCode)), __LINE__);
        }
        if (is_null($stateIsoCode) || (is_array($stateIsoCode) && empty($stateIsoCode))) {
            unset($this->StateIsoCode);
        } else {
            $this->StateIsoCode = $stateIsoCode;
        }
        return $this;
    }
    /**
     * Get StateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getStateName()
    {
        return isset($this->StateName) ? $this->StateName : null;
    }
    /**
     * Set StateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $stateName
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setStateName(\patest\StructType\GlobalString $stateName = null)
    {
        if (is_null($stateName) || (is_array($stateName) && empty($stateName))) {
            unset($this->StateName);
        } else {
            $this->StateName = $stateName;
        }
        return $this;
    }
    /**
     * Get StateNameOrId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateNameOrId()
    {
        return isset($this->StateNameOrId) ? $this->StateNameOrId : null;
    }
    /**
     * Set StateNameOrId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateNameOrId
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setStateNameOrId($stateNameOrId = null)
    {
        // validation for constraint: string
        if (!is_null($stateNameOrId) && !is_string($stateNameOrId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateNameOrId, true), gettype($stateNameOrId)), __LINE__);
        }
        if (is_null($stateNameOrId) || (is_array($stateNameOrId) && empty($stateNameOrId))) {
            unset($this->StateNameOrId);
        } else {
            $this->StateNameOrId = $stateNameOrId;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
    /**
     * Get ZipCodeSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCodeSource()
    {
        return isset($this->ZipCodeSource) ? $this->ZipCodeSource : null;
    }
    /**
     * Set ZipCodeSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ZipCodeSource::valueIsValid()
     * @uses \patest\EnumType\ZipCodeSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zipCodeSource
     * @return \patest\StructType\Crm_PostalAddress
     */
    public function setZipCodeSource($zipCodeSource = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ZipCodeSource::valueIsValid($zipCodeSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ZipCodeSource', is_array($zipCodeSource) ? implode(', ', $zipCodeSource) : var_export($zipCodeSource, true), implode(', ', \patest\EnumType\ZipCodeSource::getValidValues())), __LINE__);
        }
        if (is_null($zipCodeSource) || (is_array($zipCodeSource) && empty($zipCodeSource))) {
            unset($this->ZipCodeSource);
        } else {
            $this->ZipCodeSource = $zipCodeSource;
        }
        return $this;
    }
}
