<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.PersonName StructType
 * @subpackage Structs
 */
class Crm_PersonName extends AnyEntity
{
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The First
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $First;
    /**
     * The FullName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullName;
    /**
     * The FullNameDialog
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullNameDialog;
    /**
     * The Initials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Initials;
    /**
     * The JobTitleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $JobTitleId;
    /**
     * The Last
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Last;
    /**
     * The Middle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Middle;
    /**
     * The PreferedName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferedName;
    /**
     * The Prefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prefix;
    /**
     * The SearchableFirst
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchableFirst;
    /**
     * The SearchableLast
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchableLast;
    /**
     * The SearchableMiddle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchableMiddle;
    /**
     * The SpouseName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpouseName;
    /**
     * The Suffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Suffix;
    /**
     * The TitleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TitleId;
    /**
     * Constructor method for Crm.PersonName
     * @uses Crm_PersonName::setCrmId()
     * @uses Crm_PersonName::setFirst()
     * @uses Crm_PersonName::setFullName()
     * @uses Crm_PersonName::setFullNameDialog()
     * @uses Crm_PersonName::setInitials()
     * @uses Crm_PersonName::setJobTitleId()
     * @uses Crm_PersonName::setLast()
     * @uses Crm_PersonName::setMiddle()
     * @uses Crm_PersonName::setPreferedName()
     * @uses Crm_PersonName::setPrefix()
     * @uses Crm_PersonName::setSearchableFirst()
     * @uses Crm_PersonName::setSearchableLast()
     * @uses Crm_PersonName::setSearchableMiddle()
     * @uses Crm_PersonName::setSpouseName()
     * @uses Crm_PersonName::setSuffix()
     * @uses Crm_PersonName::setTitleId()
     * @param string $crmId
     * @param string $first
     * @param string $fullName
     * @param string $fullNameDialog
     * @param string $initials
     * @param string $jobTitleId
     * @param string $last
     * @param string $middle
     * @param string $preferedName
     * @param string $prefix
     * @param string $searchableFirst
     * @param string $searchableLast
     * @param string $searchableMiddle
     * @param string $spouseName
     * @param string $suffix
     * @param string $titleId
     */
    public function __construct($crmId = null, $first = null, $fullName = null, $fullNameDialog = null, $initials = null, $jobTitleId = null, $last = null, $middle = null, $preferedName = null, $prefix = null, $searchableFirst = null, $searchableLast = null, $searchableMiddle = null, $spouseName = null, $suffix = null, $titleId = null)
    {
        $this
            ->setCrmId($crmId)
            ->setFirst($first)
            ->setFullName($fullName)
            ->setFullNameDialog($fullNameDialog)
            ->setInitials($initials)
            ->setJobTitleId($jobTitleId)
            ->setLast($last)
            ->setMiddle($middle)
            ->setPreferedName($preferedName)
            ->setPrefix($prefix)
            ->setSearchableFirst($searchableFirst)
            ->setSearchableLast($searchableLast)
            ->setSearchableMiddle($searchableMiddle)
            ->setSpouseName($spouseName)
            ->setSuffix($suffix)
            ->setTitleId($titleId);
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Crm_PersonName
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get First value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirst()
    {
        return isset($this->First) ? $this->First : null;
    }
    /**
     * Set First value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $first
     * @return \patest\StructType\Crm_PersonName
     */
    public function setFirst($first = null)
    {
        // validation for constraint: string
        if (!is_null($first) && !is_string($first)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first, true), gettype($first)), __LINE__);
        }
        if (is_null($first) || (is_array($first) && empty($first))) {
            unset($this->First);
        } else {
            $this->First = $first;
        }
        return $this;
    }
    /**
     * Get FullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullName()
    {
        return isset($this->FullName) ? $this->FullName : null;
    }
    /**
     * Set FullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullName
     * @return \patest\StructType\Crm_PersonName
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        if (is_null($fullName) || (is_array($fullName) && empty($fullName))) {
            unset($this->FullName);
        } else {
            $this->FullName = $fullName;
        }
        return $this;
    }
    /**
     * Get FullNameDialog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullNameDialog()
    {
        return isset($this->FullNameDialog) ? $this->FullNameDialog : null;
    }
    /**
     * Set FullNameDialog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullNameDialog
     * @return \patest\StructType\Crm_PersonName
     */
    public function setFullNameDialog($fullNameDialog = null)
    {
        // validation for constraint: string
        if (!is_null($fullNameDialog) && !is_string($fullNameDialog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullNameDialog, true), gettype($fullNameDialog)), __LINE__);
        }
        if (is_null($fullNameDialog) || (is_array($fullNameDialog) && empty($fullNameDialog))) {
            unset($this->FullNameDialog);
        } else {
            $this->FullNameDialog = $fullNameDialog;
        }
        return $this;
    }
    /**
     * Get Initials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitials()
    {
        return isset($this->Initials) ? $this->Initials : null;
    }
    /**
     * Set Initials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initials
     * @return \patest\StructType\Crm_PersonName
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initials, true), gettype($initials)), __LINE__);
        }
        if (is_null($initials) || (is_array($initials) && empty($initials))) {
            unset($this->Initials);
        } else {
            $this->Initials = $initials;
        }
        return $this;
    }
    /**
     * Get JobTitleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJobTitleId()
    {
        return isset($this->JobTitleId) ? $this->JobTitleId : null;
    }
    /**
     * Set JobTitleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jobTitleId
     * @return \patest\StructType\Crm_PersonName
     */
    public function setJobTitleId($jobTitleId = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitleId) && !is_string($jobTitleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobTitleId, true), gettype($jobTitleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($jobTitleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $jobTitleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($jobTitleId, true)), __LINE__);
        }
        if (is_null($jobTitleId) || (is_array($jobTitleId) && empty($jobTitleId))) {
            unset($this->JobTitleId);
        } else {
            $this->JobTitleId = $jobTitleId;
        }
        return $this;
    }
    /**
     * Get Last value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLast()
    {
        return isset($this->Last) ? $this->Last : null;
    }
    /**
     * Set Last value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $last
     * @return \patest\StructType\Crm_PersonName
     */
    public function setLast($last = null)
    {
        // validation for constraint: string
        if (!is_null($last) && !is_string($last)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last, true), gettype($last)), __LINE__);
        }
        if (is_null($last) || (is_array($last) && empty($last))) {
            unset($this->Last);
        } else {
            $this->Last = $last;
        }
        return $this;
    }
    /**
     * Get Middle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddle()
    {
        return isset($this->Middle) ? $this->Middle : null;
    }
    /**
     * Set Middle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middle
     * @return \patest\StructType\Crm_PersonName
     */
    public function setMiddle($middle = null)
    {
        // validation for constraint: string
        if (!is_null($middle) && !is_string($middle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middle, true), gettype($middle)), __LINE__);
        }
        if (is_null($middle) || (is_array($middle) && empty($middle))) {
            unset($this->Middle);
        } else {
            $this->Middle = $middle;
        }
        return $this;
    }
    /**
     * Get PreferedName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferedName()
    {
        return isset($this->PreferedName) ? $this->PreferedName : null;
    }
    /**
     * Set PreferedName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferedName
     * @return \patest\StructType\Crm_PersonName
     */
    public function setPreferedName($preferedName = null)
    {
        // validation for constraint: string
        if (!is_null($preferedName) && !is_string($preferedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferedName, true), gettype($preferedName)), __LINE__);
        }
        if (is_null($preferedName) || (is_array($preferedName) && empty($preferedName))) {
            unset($this->PreferedName);
        } else {
            $this->PreferedName = $preferedName;
        }
        return $this;
    }
    /**
     * Get Prefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefix()
    {
        return isset($this->Prefix) ? $this->Prefix : null;
    }
    /**
     * Set Prefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefix
     * @return \patest\StructType\Crm_PersonName
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        if (is_null($prefix) || (is_array($prefix) && empty($prefix))) {
            unset($this->Prefix);
        } else {
            $this->Prefix = $prefix;
        }
        return $this;
    }
    /**
     * Get SearchableFirst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchableFirst()
    {
        return isset($this->SearchableFirst) ? $this->SearchableFirst : null;
    }
    /**
     * Set SearchableFirst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchableFirst
     * @return \patest\StructType\Crm_PersonName
     */
    public function setSearchableFirst($searchableFirst = null)
    {
        // validation for constraint: string
        if (!is_null($searchableFirst) && !is_string($searchableFirst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchableFirst, true), gettype($searchableFirst)), __LINE__);
        }
        if (is_null($searchableFirst) || (is_array($searchableFirst) && empty($searchableFirst))) {
            unset($this->SearchableFirst);
        } else {
            $this->SearchableFirst = $searchableFirst;
        }
        return $this;
    }
    /**
     * Get SearchableLast value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchableLast()
    {
        return isset($this->SearchableLast) ? $this->SearchableLast : null;
    }
    /**
     * Set SearchableLast value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchableLast
     * @return \patest\StructType\Crm_PersonName
     */
    public function setSearchableLast($searchableLast = null)
    {
        // validation for constraint: string
        if (!is_null($searchableLast) && !is_string($searchableLast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchableLast, true), gettype($searchableLast)), __LINE__);
        }
        if (is_null($searchableLast) || (is_array($searchableLast) && empty($searchableLast))) {
            unset($this->SearchableLast);
        } else {
            $this->SearchableLast = $searchableLast;
        }
        return $this;
    }
    /**
     * Get SearchableMiddle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchableMiddle()
    {
        return isset($this->SearchableMiddle) ? $this->SearchableMiddle : null;
    }
    /**
     * Set SearchableMiddle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchableMiddle
     * @return \patest\StructType\Crm_PersonName
     */
    public function setSearchableMiddle($searchableMiddle = null)
    {
        // validation for constraint: string
        if (!is_null($searchableMiddle) && !is_string($searchableMiddle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchableMiddle, true), gettype($searchableMiddle)), __LINE__);
        }
        if (is_null($searchableMiddle) || (is_array($searchableMiddle) && empty($searchableMiddle))) {
            unset($this->SearchableMiddle);
        } else {
            $this->SearchableMiddle = $searchableMiddle;
        }
        return $this;
    }
    /**
     * Get SpouseName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpouseName()
    {
        return isset($this->SpouseName) ? $this->SpouseName : null;
    }
    /**
     * Set SpouseName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spouseName
     * @return \patest\StructType\Crm_PersonName
     */
    public function setSpouseName($spouseName = null)
    {
        // validation for constraint: string
        if (!is_null($spouseName) && !is_string($spouseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spouseName, true), gettype($spouseName)), __LINE__);
        }
        if (is_null($spouseName) || (is_array($spouseName) && empty($spouseName))) {
            unset($this->SpouseName);
        } else {
            $this->SpouseName = $spouseName;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $suffix
     * @return \patest\StructType\Crm_PersonName
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
    /**
     * Get TitleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitleId()
    {
        return isset($this->TitleId) ? $this->TitleId : null;
    }
    /**
     * Set TitleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titleId
     * @return \patest\StructType\Crm_PersonName
     */
    public function setTitleId($titleId = null)
    {
        // validation for constraint: string
        if (!is_null($titleId) && !is_string($titleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titleId, true), gettype($titleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($titleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $titleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($titleId, true)), __LINE__);
        }
        if (is_null($titleId) || (is_array($titleId) && empty($titleId))) {
            unset($this->TitleId);
        } else {
            $this->TitleId = $titleId;
        }
        return $this;
    }
}
