<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.MergeClient StructType
 * @subpackage Structs
 */
class Crm_MergeClient extends PersistableEntity
{
    /**
     * The AccountTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountTypes;
    /**
     * The Activities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Activities;
    /**
     * The Addresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Addresses;
    /**
     * The Associations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Associations;
    /**
     * The ClientOrgUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientOrgUnits;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypes;
    /**
     * The CommunicationServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommunicationServices;
    /**
     * The ContactDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactDetails;
    /**
     * The CrmType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $CrmType;
    /**
     * The DataProtection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataProtection;
    /**
     * The LeadingClientCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadingClientCrmId;
    /**
     * The LeadingClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LeadingClientId;
    /**
     * The MergedClientCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MergedClientCrmId;
    /**
     * The MergedClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MergedClientId;
    /**
     * The MergedDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MergedDateTime;
    /**
     * The PersonalData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonalData;
    /**
     * The Preferences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Preferences;
    /**
     * The Relationships
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Relationships;
    /**
     * Constructor method for Crm.MergeClient
     * @uses Crm_MergeClient::setAccountTypes()
     * @uses Crm_MergeClient::setActivities()
     * @uses Crm_MergeClient::setAddresses()
     * @uses Crm_MergeClient::setAssociations()
     * @uses Crm_MergeClient::setClientOrgUnits()
     * @uses Crm_MergeClient::setClientTypes()
     * @uses Crm_MergeClient::setCommunicationServices()
     * @uses Crm_MergeClient::setContactDetails()
     * @uses Crm_MergeClient::setCrmType()
     * @uses Crm_MergeClient::setDataProtection()
     * @uses Crm_MergeClient::setLeadingClientCrmId()
     * @uses Crm_MergeClient::setLeadingClientId()
     * @uses Crm_MergeClient::setMergedClientCrmId()
     * @uses Crm_MergeClient::setMergedClientId()
     * @uses Crm_MergeClient::setMergedDateTime()
     * @uses Crm_MergeClient::setPersonalData()
     * @uses Crm_MergeClient::setPreferences()
     * @uses Crm_MergeClient::setRelationships()
     * @param string $accountTypes
     * @param string $activities
     * @param string $addresses
     * @param string $associations
     * @param string $clientOrgUnits
     * @param string $clientTypes
     * @param string $communicationServices
     * @param string $contactDetails
     * @param string[] $crmType
     * @param string $dataProtection
     * @param string $leadingClientCrmId
     * @param string $leadingClientId
     * @param string $mergedClientCrmId
     * @param string $mergedClientId
     * @param string $mergedDateTime
     * @param string $personalData
     * @param string $preferences
     * @param string $relationships
     */
    public function __construct($accountTypes = null, $activities = null, $addresses = null, $associations = null, $clientOrgUnits = null, $clientTypes = null, $communicationServices = null, $contactDetails = null, array $crmType = array(), $dataProtection = null, $leadingClientCrmId = null, $leadingClientId = null, $mergedClientCrmId = null, $mergedClientId = null, $mergedDateTime = null, $personalData = null, $preferences = null, $relationships = null)
    {
        $this
            ->setAccountTypes($accountTypes)
            ->setActivities($activities)
            ->setAddresses($addresses)
            ->setAssociations($associations)
            ->setClientOrgUnits($clientOrgUnits)
            ->setClientTypes($clientTypes)
            ->setCommunicationServices($communicationServices)
            ->setContactDetails($contactDetails)
            ->setCrmType($crmType)
            ->setDataProtection($dataProtection)
            ->setLeadingClientCrmId($leadingClientCrmId)
            ->setLeadingClientId($leadingClientId)
            ->setMergedClientCrmId($mergedClientCrmId)
            ->setMergedClientId($mergedClientId)
            ->setMergedDateTime($mergedDateTime)
            ->setPersonalData($personalData)
            ->setPreferences($preferences)
            ->setRelationships($relationships);
    }
    /**
     * Get AccountTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountTypes()
    {
        return isset($this->AccountTypes) ? $this->AccountTypes : null;
    }
    /**
     * Set AccountTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountTypes
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setAccountTypes($accountTypes = null)
    {
        // validation for constraint: string
        if (!is_null($accountTypes) && !is_string($accountTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountTypes, true), gettype($accountTypes)), __LINE__);
        }
        if (is_null($accountTypes) || (is_array($accountTypes) && empty($accountTypes))) {
            unset($this->AccountTypes);
        } else {
            $this->AccountTypes = $accountTypes;
        }
        return $this;
    }
    /**
     * Get Activities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivities()
    {
        return isset($this->Activities) ? $this->Activities : null;
    }
    /**
     * Set Activities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activities
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setActivities($activities = null)
    {
        // validation for constraint: string
        if (!is_null($activities) && !is_string($activities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activities, true), gettype($activities)), __LINE__);
        }
        if (is_null($activities) || (is_array($activities) && empty($activities))) {
            unset($this->Activities);
        } else {
            $this->Activities = $activities;
        }
        return $this;
    }
    /**
     * Get Addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddresses()
    {
        return isset($this->Addresses) ? $this->Addresses : null;
    }
    /**
     * Set Addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addresses
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setAddresses($addresses = null)
    {
        // validation for constraint: string
        if (!is_null($addresses) && !is_string($addresses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addresses, true), gettype($addresses)), __LINE__);
        }
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->Addresses);
        } else {
            $this->Addresses = $addresses;
        }
        return $this;
    }
    /**
     * Get Associations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociations()
    {
        return isset($this->Associations) ? $this->Associations : null;
    }
    /**
     * Set Associations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associations
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setAssociations($associations = null)
    {
        // validation for constraint: string
        if (!is_null($associations) && !is_string($associations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associations, true), gettype($associations)), __LINE__);
        }
        if (is_null($associations) || (is_array($associations) && empty($associations))) {
            unset($this->Associations);
        } else {
            $this->Associations = $associations;
        }
        return $this;
    }
    /**
     * Get ClientOrgUnits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientOrgUnits()
    {
        return isset($this->ClientOrgUnits) ? $this->ClientOrgUnits : null;
    }
    /**
     * Set ClientOrgUnits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientOrgUnits
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setClientOrgUnits($clientOrgUnits = null)
    {
        // validation for constraint: string
        if (!is_null($clientOrgUnits) && !is_string($clientOrgUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientOrgUnits, true), gettype($clientOrgUnits)), __LINE__);
        }
        if (is_null($clientOrgUnits) || (is_array($clientOrgUnits) && empty($clientOrgUnits))) {
            unset($this->ClientOrgUnits);
        } else {
            $this->ClientOrgUnits = $clientOrgUnits;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypes
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setClientTypes($clientTypes = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypes) && !is_string($clientTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypes, true), gettype($clientTypes)), __LINE__);
        }
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get CommunicationServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationServices()
    {
        return isset($this->CommunicationServices) ? $this->CommunicationServices : null;
    }
    /**
     * Set CommunicationServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationServices
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setCommunicationServices($communicationServices = null)
    {
        // validation for constraint: string
        if (!is_null($communicationServices) && !is_string($communicationServices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationServices, true), gettype($communicationServices)), __LINE__);
        }
        if (is_null($communicationServices) || (is_array($communicationServices) && empty($communicationServices))) {
            unset($this->CommunicationServices);
        } else {
            $this->CommunicationServices = $communicationServices;
        }
        return $this;
    }
    /**
     * Get ContactDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactDetails()
    {
        return isset($this->ContactDetails) ? $this->ContactDetails : null;
    }
    /**
     * Set ContactDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactDetails
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setContactDetails($contactDetails = null)
    {
        // validation for constraint: string
        if (!is_null($contactDetails) && !is_string($contactDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactDetails, true), gettype($contactDetails)), __LINE__);
        }
        if (is_null($contactDetails) || (is_array($contactDetails) && empty($contactDetails))) {
            unset($this->ContactDetails);
        } else {
            $this->ContactDetails = $contactDetails;
        }
        return $this;
    }
    /**
     * Get CrmType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCrmType()
    {
        return isset($this->CrmType) ? $this->CrmType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCrmType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCrmType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCrmTypeForArrayConstraintsFromSetCrmType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crm_MergeClientCrmTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($crm_MergeClientCrmTypeItem)) {
                $invalidValues[] = is_object($crm_MergeClientCrmTypeItem) ? get_class($crm_MergeClientCrmTypeItem) : sprintf('%s(%s)', gettype($crm_MergeClientCrmTypeItem), var_export($crm_MergeClientCrmTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CrmType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $crmType
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setCrmType(array $crmType = array())
    {
        // validation for constraint: list
        if ('' !== ($crmTypeArrayErrorMessage = self::validateCrmTypeForArrayConstraintsFromSetCrmType($crmType))) {
            throw new \InvalidArgumentException($crmTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($crmType) || (is_array($crmType) && empty($crmType))) {
            unset($this->CrmType);
        } else {
            $this->CrmType = is_array($crmType) ? implode(' ', $crmType) : null;
        }
        return $this;
    }
    /**
     * Get DataProtection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataProtection()
    {
        return isset($this->DataProtection) ? $this->DataProtection : null;
    }
    /**
     * Set DataProtection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataProtection
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setDataProtection($dataProtection = null)
    {
        // validation for constraint: string
        if (!is_null($dataProtection) && !is_string($dataProtection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataProtection, true), gettype($dataProtection)), __LINE__);
        }
        if (is_null($dataProtection) || (is_array($dataProtection) && empty($dataProtection))) {
            unset($this->DataProtection);
        } else {
            $this->DataProtection = $dataProtection;
        }
        return $this;
    }
    /**
     * Get LeadingClientCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadingClientCrmId()
    {
        return isset($this->LeadingClientCrmId) ? $this->LeadingClientCrmId : null;
    }
    /**
     * Set LeadingClientCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadingClientCrmId
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setLeadingClientCrmId($leadingClientCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($leadingClientCrmId) && !is_string($leadingClientCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadingClientCrmId, true), gettype($leadingClientCrmId)), __LINE__);
        }
        if (is_null($leadingClientCrmId) || (is_array($leadingClientCrmId) && empty($leadingClientCrmId))) {
            unset($this->LeadingClientCrmId);
        } else {
            $this->LeadingClientCrmId = $leadingClientCrmId;
        }
        return $this;
    }
    /**
     * Get LeadingClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadingClientId()
    {
        return isset($this->LeadingClientId) ? $this->LeadingClientId : null;
    }
    /**
     * Set LeadingClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadingClientId
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setLeadingClientId($leadingClientId = null)
    {
        // validation for constraint: string
        if (!is_null($leadingClientId) && !is_string($leadingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadingClientId, true), gettype($leadingClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($leadingClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $leadingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($leadingClientId, true)), __LINE__);
        }
        if (is_null($leadingClientId) || (is_array($leadingClientId) && empty($leadingClientId))) {
            unset($this->LeadingClientId);
        } else {
            $this->LeadingClientId = $leadingClientId;
        }
        return $this;
    }
    /**
     * Get MergedClientCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMergedClientCrmId()
    {
        return isset($this->MergedClientCrmId) ? $this->MergedClientCrmId : null;
    }
    /**
     * Set MergedClientCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mergedClientCrmId
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setMergedClientCrmId($mergedClientCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($mergedClientCrmId) && !is_string($mergedClientCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mergedClientCrmId, true), gettype($mergedClientCrmId)), __LINE__);
        }
        if (is_null($mergedClientCrmId) || (is_array($mergedClientCrmId) && empty($mergedClientCrmId))) {
            unset($this->MergedClientCrmId);
        } else {
            $this->MergedClientCrmId = $mergedClientCrmId;
        }
        return $this;
    }
    /**
     * Get MergedClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMergedClientId()
    {
        return isset($this->MergedClientId) ? $this->MergedClientId : null;
    }
    /**
     * Set MergedClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mergedClientId
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setMergedClientId($mergedClientId = null)
    {
        // validation for constraint: string
        if (!is_null($mergedClientId) && !is_string($mergedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mergedClientId, true), gettype($mergedClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mergedClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mergedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mergedClientId, true)), __LINE__);
        }
        if (is_null($mergedClientId) || (is_array($mergedClientId) && empty($mergedClientId))) {
            unset($this->MergedClientId);
        } else {
            $this->MergedClientId = $mergedClientId;
        }
        return $this;
    }
    /**
     * Get MergedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMergedDateTime()
    {
        return isset($this->MergedDateTime) ? $this->MergedDateTime : null;
    }
    /**
     * Set MergedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mergedDateTime
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setMergedDateTime($mergedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($mergedDateTime) && !is_string($mergedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mergedDateTime, true), gettype($mergedDateTime)), __LINE__);
        }
        if (is_null($mergedDateTime) || (is_array($mergedDateTime) && empty($mergedDateTime))) {
            unset($this->MergedDateTime);
        } else {
            $this->MergedDateTime = $mergedDateTime;
        }
        return $this;
    }
    /**
     * Get PersonalData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonalData()
    {
        return isset($this->PersonalData) ? $this->PersonalData : null;
    }
    /**
     * Set PersonalData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personalData
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setPersonalData($personalData = null)
    {
        // validation for constraint: string
        if (!is_null($personalData) && !is_string($personalData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personalData, true), gettype($personalData)), __LINE__);
        }
        if (is_null($personalData) || (is_array($personalData) && empty($personalData))) {
            unset($this->PersonalData);
        } else {
            $this->PersonalData = $personalData;
        }
        return $this;
    }
    /**
     * Get Preferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferences()
    {
        return isset($this->Preferences) ? $this->Preferences : null;
    }
    /**
     * Set Preferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferences
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setPreferences($preferences = null)
    {
        // validation for constraint: string
        if (!is_null($preferences) && !is_string($preferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferences, true), gettype($preferences)), __LINE__);
        }
        if (is_null($preferences) || (is_array($preferences) && empty($preferences))) {
            unset($this->Preferences);
        } else {
            $this->Preferences = $preferences;
        }
        return $this;
    }
    /**
     * Get Relationships value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationships()
    {
        return isset($this->Relationships) ? $this->Relationships : null;
    }
    /**
     * Set Relationships value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationships
     * @return \patest\StructType\Crm_MergeClient
     */
    public function setRelationships($relationships = null)
    {
        // validation for constraint: string
        if (!is_null($relationships) && !is_string($relationships)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationships, true), gettype($relationships)), __LINE__);
        }
        if (is_null($relationships) || (is_array($relationships) && empty($relationships))) {
            unset($this->Relationships);
        } else {
            $this->Relationships = $relationships;
        }
        return $this;
    }
}
