<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ExtendedClientReadOnlyData4Printing StructType
 * @subpackage Structs
 */
class Crm_ExtendedClientReadOnlyData4Printing extends Crm_Client
{
    /**
     * The AccountData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_AccountReadOnlyData4Printing
     */
    public $AccountData;
    /**
     * The AddressDetails4Printing
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails
     */
    public $AddressDetails4Printing;
    /**
     * The Addresses
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientAddresses
     */
    public $Addresses;
    /**
     * The ContactDetails4Printing
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail
     */
    public $ContactDetails4Printing;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientContacts
     */
    public $Contacts;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The CustomerData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_CustomerReadOnlyData
     */
    public $CustomerData;
    /**
     * The Picture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_ClientImage4Printing
     */
    public $Picture;
    /**
     * The PreferredCulture
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ScreenParts_SupportedCulture
     */
    public $PreferredCulture;
    /**
     * Constructor method for Crm.ExtendedClientReadOnlyData4Printing
     * @uses Crm_ExtendedClientReadOnlyData4Printing::setAccountData()
     * @uses Crm_ExtendedClientReadOnlyData4Printing::setAddressDetails4Printing()
     * @uses Crm_ExtendedClientReadOnlyData4Printing::setAddresses()
     * @uses Crm_ExtendedClientReadOnlyData4Printing::setContactDetails4Printing()
     * @uses Crm_ExtendedClientReadOnlyData4Printing::setContacts()
     * @uses Crm_ExtendedClientReadOnlyData4Printing::setCultureId()
     * @uses Crm_ExtendedClientReadOnlyData4Printing::setCustomerData()
     * @uses Crm_ExtendedClientReadOnlyData4Printing::setPicture()
     * @uses Crm_ExtendedClientReadOnlyData4Printing::setPreferredCulture()
     * @param \patest\StructType\Crm_AccountReadOnlyData4Printing $accountData
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails4Printing
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails4Printing
     * @param \patest\StructType\Printing_AuxDataItem_ClientContacts $contacts
     * @param int $cultureId
     * @param \patest\StructType\Crm_CustomerReadOnlyData $customerData
     * @param \patest\StructType\Crm_ClientImage4Printing $picture
     * @param \patest\StructType\ScreenParts_SupportedCulture $preferredCulture
     */
    public function __construct(\patest\StructType\Crm_AccountReadOnlyData4Printing $accountData = null, \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails4Printing = null, \patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses = null, \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails4Printing = null, \patest\StructType\Printing_AuxDataItem_ClientContacts $contacts = null, $cultureId = null, \patest\StructType\Crm_CustomerReadOnlyData $customerData = null, \patest\StructType\Crm_ClientImage4Printing $picture = null, \patest\StructType\ScreenParts_SupportedCulture $preferredCulture = null)
    {
        $this
            ->setAccountData($accountData)
            ->setAddressDetails4Printing($addressDetails4Printing)
            ->setAddresses($addresses)
            ->setContactDetails4Printing($contactDetails4Printing)
            ->setContacts($contacts)
            ->setCultureId($cultureId)
            ->setCustomerData($customerData)
            ->setPicture($picture)
            ->setPreferredCulture($preferredCulture);
    }
    /**
     * Get AccountData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_AccountReadOnlyData4Printing|null
     */
    public function getAccountData()
    {
        return isset($this->AccountData) ? $this->AccountData : null;
    }
    /**
     * Set AccountData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_AccountReadOnlyData4Printing $accountData
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData4Printing
     */
    public function setAccountData(\patest\StructType\Crm_AccountReadOnlyData4Printing $accountData = null)
    {
        if (is_null($accountData) || (is_array($accountData) && empty($accountData))) {
            unset($this->AccountData);
        } else {
            $this->AccountData = $accountData;
        }
        return $this;
    }
    /**
     * Get AddressDetails4Printing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails|null
     */
    public function getAddressDetails4Printing()
    {
        return isset($this->AddressDetails4Printing) ? $this->AddressDetails4Printing : null;
    }
    /**
     * Set AddressDetails4Printing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails4Printing
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData4Printing
     */
    public function setAddressDetails4Printing(\patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails4Printing = null)
    {
        if (is_null($addressDetails4Printing) || (is_array($addressDetails4Printing) && empty($addressDetails4Printing))) {
            unset($this->AddressDetails4Printing);
        } else {
            $this->AddressDetails4Printing = $addressDetails4Printing;
        }
        return $this;
    }
    /**
     * Get Addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddresses|null
     */
    public function getAddresses()
    {
        return isset($this->Addresses) ? $this->Addresses : null;
    }
    /**
     * Set Addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData4Printing
     */
    public function setAddresses(\patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses = null)
    {
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->Addresses);
        } else {
            $this->Addresses = $addresses;
        }
        return $this;
    }
    /**
     * Get ContactDetails4Printing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail|null
     */
    public function getContactDetails4Printing()
    {
        return isset($this->ContactDetails4Printing) ? $this->ContactDetails4Printing : null;
    }
    /**
     * Set ContactDetails4Printing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails4Printing
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData4Printing
     */
    public function setContactDetails4Printing(\patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails4Printing = null)
    {
        if (is_null($contactDetails4Printing) || (is_array($contactDetails4Printing) && empty($contactDetails4Printing))) {
            unset($this->ContactDetails4Printing);
        } else {
            $this->ContactDetails4Printing = $contactDetails4Printing;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientContacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientContacts $contacts
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData4Printing
     */
    public function setContacts(\patest\StructType\Printing_AuxDataItem_ClientContacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData4Printing
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get CustomerData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_CustomerReadOnlyData|null
     */
    public function getCustomerData()
    {
        return isset($this->CustomerData) ? $this->CustomerData : null;
    }
    /**
     * Set CustomerData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_CustomerReadOnlyData $customerData
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData4Printing
     */
    public function setCustomerData(\patest\StructType\Crm_CustomerReadOnlyData $customerData = null)
    {
        if (is_null($customerData) || (is_array($customerData) && empty($customerData))) {
            unset($this->CustomerData);
        } else {
            $this->CustomerData = $customerData;
        }
        return $this;
    }
    /**
     * Get Picture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_ClientImage4Printing|null
     */
    public function getPicture()
    {
        return isset($this->Picture) ? $this->Picture : null;
    }
    /**
     * Set Picture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_ClientImage4Printing $picture
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData4Printing
     */
    public function setPicture(\patest\StructType\Crm_ClientImage4Printing $picture = null)
    {
        if (is_null($picture) || (is_array($picture) && empty($picture))) {
            unset($this->Picture);
        } else {
            $this->Picture = $picture;
        }
        return $this;
    }
    /**
     * Get PreferredCulture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ScreenParts_SupportedCulture|null
     */
    public function getPreferredCulture()
    {
        return isset($this->PreferredCulture) ? $this->PreferredCulture : null;
    }
    /**
     * Set PreferredCulture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ScreenParts_SupportedCulture $preferredCulture
     * @return \patest\StructType\Crm_ExtendedClientReadOnlyData4Printing
     */
    public function setPreferredCulture(\patest\StructType\ScreenParts_SupportedCulture $preferredCulture = null)
    {
        if (is_null($preferredCulture) || (is_array($preferredCulture) && empty($preferredCulture))) {
            unset($this->PreferredCulture);
        } else {
            $this->PreferredCulture = $preferredCulture;
        }
        return $this;
    }
}
