<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.DuplicationCheckRuleRecord StructType
 * @subpackage Structs
 */
class Crm_DuplicationCheckRuleRecord extends DistributableEntity
{
    /**
     * The Condition
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Condition;
    /**
     * The EntityProperty
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityProperty;
    /**
     * The FieldSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FieldSystemName;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The RuleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RuleId;
    /**
     * Constructor method for Crm.DuplicationCheckRuleRecord
     * @uses Crm_DuplicationCheckRuleRecord::setCondition()
     * @uses Crm_DuplicationCheckRuleRecord::setEntityProperty()
     * @uses Crm_DuplicationCheckRuleRecord::setFieldSystemName()
     * @uses Crm_DuplicationCheckRuleRecord::setPriority()
     * @uses Crm_DuplicationCheckRuleRecord::setRuleId()
     * @param string $condition
     * @param string $entityProperty
     * @param string $fieldSystemName
     * @param int $priority
     * @param string $ruleId
     */
    public function __construct($condition = null, $entityProperty = null, $fieldSystemName = null, $priority = null, $ruleId = null)
    {
        $this
            ->setCondition($condition)
            ->setEntityProperty($entityProperty)
            ->setFieldSystemName($fieldSystemName)
            ->setPriority($priority)
            ->setRuleId($ruleId);
    }
    /**
     * Get Condition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCondition()
    {
        return isset($this->Condition) ? $this->Condition : null;
    }
    /**
     * Set Condition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $condition
     * @return \patest\StructType\Crm_DuplicationCheckRuleRecord
     */
    public function setCondition($condition = null)
    {
        // validation for constraint: string
        if (!is_null($condition) && !is_string($condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($condition, true), gettype($condition)), __LINE__);
        }
        if (is_null($condition) || (is_array($condition) && empty($condition))) {
            unset($this->Condition);
        } else {
            $this->Condition = $condition;
        }
        return $this;
    }
    /**
     * Get EntityProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityProperty()
    {
        return isset($this->EntityProperty) ? $this->EntityProperty : null;
    }
    /**
     * Set EntityProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityProperty
     * @return \patest\StructType\Crm_DuplicationCheckRuleRecord
     */
    public function setEntityProperty($entityProperty = null)
    {
        // validation for constraint: string
        if (!is_null($entityProperty) && !is_string($entityProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityProperty, true), gettype($entityProperty)), __LINE__);
        }
        if (is_null($entityProperty) || (is_array($entityProperty) && empty($entityProperty))) {
            unset($this->EntityProperty);
        } else {
            $this->EntityProperty = $entityProperty;
        }
        return $this;
    }
    /**
     * Get FieldSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFieldSystemName()
    {
        return isset($this->FieldSystemName) ? $this->FieldSystemName : null;
    }
    /**
     * Set FieldSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fieldSystemName
     * @return \patest\StructType\Crm_DuplicationCheckRuleRecord
     */
    public function setFieldSystemName($fieldSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldSystemName) && !is_string($fieldSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldSystemName, true), gettype($fieldSystemName)), __LINE__);
        }
        if (is_null($fieldSystemName) || (is_array($fieldSystemName) && empty($fieldSystemName))) {
            unset($this->FieldSystemName);
        } else {
            $this->FieldSystemName = $fieldSystemName;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Crm_DuplicationCheckRuleRecord
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get RuleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleId()
    {
        return isset($this->RuleId) ? $this->RuleId : null;
    }
    /**
     * Set RuleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleId
     * @return \patest\StructType\Crm_DuplicationCheckRuleRecord
     */
    public function setRuleId($ruleId = null)
    {
        // validation for constraint: string
        if (!is_null($ruleId) && !is_string($ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleId, true), gettype($ruleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ruleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ruleId, true)), __LINE__);
        }
        if (is_null($ruleId) || (is_array($ruleId) && empty($ruleId))) {
            unset($this->RuleId);
        } else {
            $this->RuleId = $ruleId;
        }
        return $this;
    }
}
