<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.CustomersExternalManipulationProcessHistory StructType
 * @subpackage Structs
 */
class Crm_CustomersExternalManipulationProcessHistory extends PersistableEntity
{
    /**
     * The CustomersRange
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomersRange;
    /**
     * The ExecutedByAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExecutedByAuditId;
    /**
     * The ExecutedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExecutedByUserId;
    /**
     * The FailuresRecordCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailuresRecordCount;
    /**
     * The FirstImportedCustomerCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstImportedCustomerCrmId;
    /**
     * The ImportCustomersErrorsLog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportCustomersErrorsLog;
    /**
     * The ImportCustomersFileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportCustomersFileName;
    /**
     * The ImportDuration
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportDuration;
    /**
     * The ImportEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportEndDate;
    /**
     * The ImportStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportStartDate;
    /**
     * The IsErrorsLogExist
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsErrorsLogExist;
    /**
     * The LastImportedCustomerCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastImportedCustomerCrmId;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operation;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProcessedRecordCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProcessedRecordCount;
    /**
     * The ProgressPct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProgressPct;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SuccessfulRecordCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SuccessfulRecordCount;
    /**
     * Constructor method for Crm.CustomersExternalManipulationProcessHistory
     * @uses Crm_CustomersExternalManipulationProcessHistory::setCustomersRange()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setExecutedByAuditId()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setExecutedByUserId()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setFailuresRecordCount()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setFirstImportedCustomerCrmId()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setImportCustomersErrorsLog()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setImportCustomersFileName()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setImportDuration()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setImportEndDate()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setImportStartDate()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setIsErrorsLogExist()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setLastImportedCustomerCrmId()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setNotes()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setOperation()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setOrganizationUnitId()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setProcessedRecordCount()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setProgressPct()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setStatus()
     * @uses Crm_CustomersExternalManipulationProcessHistory::setSuccessfulRecordCount()
     * @param string $customersRange
     * @param int $executedByAuditId
     * @param string $executedByUserId
     * @param int $failuresRecordCount
     * @param string $firstImportedCustomerCrmId
     * @param string $importCustomersErrorsLog
     * @param string $importCustomersFileName
     * @param string $importDuration
     * @param string $importEndDate
     * @param string $importStartDate
     * @param bool $isErrorsLogExist
     * @param string $lastImportedCustomerCrmId
     * @param string $notes
     * @param string $operation
     * @param string $organizationUnitId
     * @param int $processedRecordCount
     * @param int $progressPct
     * @param string $status
     * @param int $successfulRecordCount
     */
    public function __construct($customersRange = null, $executedByAuditId = null, $executedByUserId = null, $failuresRecordCount = null, $firstImportedCustomerCrmId = null, $importCustomersErrorsLog = null, $importCustomersFileName = null, $importDuration = null, $importEndDate = null, $importStartDate = null, $isErrorsLogExist = null, $lastImportedCustomerCrmId = null, $notes = null, $operation = null, $organizationUnitId = null, $processedRecordCount = null, $progressPct = null, $status = null, $successfulRecordCount = null)
    {
        $this
            ->setCustomersRange($customersRange)
            ->setExecutedByAuditId($executedByAuditId)
            ->setExecutedByUserId($executedByUserId)
            ->setFailuresRecordCount($failuresRecordCount)
            ->setFirstImportedCustomerCrmId($firstImportedCustomerCrmId)
            ->setImportCustomersErrorsLog($importCustomersErrorsLog)
            ->setImportCustomersFileName($importCustomersFileName)
            ->setImportDuration($importDuration)
            ->setImportEndDate($importEndDate)
            ->setImportStartDate($importStartDate)
            ->setIsErrorsLogExist($isErrorsLogExist)
            ->setLastImportedCustomerCrmId($lastImportedCustomerCrmId)
            ->setNotes($notes)
            ->setOperation($operation)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProcessedRecordCount($processedRecordCount)
            ->setProgressPct($progressPct)
            ->setStatus($status)
            ->setSuccessfulRecordCount($successfulRecordCount);
    }
    /**
     * Get CustomersRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomersRange()
    {
        return isset($this->CustomersRange) ? $this->CustomersRange : null;
    }
    /**
     * Set CustomersRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customersRange
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setCustomersRange($customersRange = null)
    {
        // validation for constraint: string
        if (!is_null($customersRange) && !is_string($customersRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customersRange, true), gettype($customersRange)), __LINE__);
        }
        if (is_null($customersRange) || (is_array($customersRange) && empty($customersRange))) {
            unset($this->CustomersRange);
        } else {
            $this->CustomersRange = $customersRange;
        }
        return $this;
    }
    /**
     * Get ExecutedByAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExecutedByAuditId()
    {
        return isset($this->ExecutedByAuditId) ? $this->ExecutedByAuditId : null;
    }
    /**
     * Set ExecutedByAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $executedByAuditId
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setExecutedByAuditId($executedByAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($executedByAuditId) && !(is_int($executedByAuditId) || ctype_digit($executedByAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($executedByAuditId, true), gettype($executedByAuditId)), __LINE__);
        }
        if (is_null($executedByAuditId) || (is_array($executedByAuditId) && empty($executedByAuditId))) {
            unset($this->ExecutedByAuditId);
        } else {
            $this->ExecutedByAuditId = $executedByAuditId;
        }
        return $this;
    }
    /**
     * Get ExecutedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutedByUserId()
    {
        return isset($this->ExecutedByUserId) ? $this->ExecutedByUserId : null;
    }
    /**
     * Set ExecutedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executedByUserId
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setExecutedByUserId($executedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($executedByUserId) && !is_string($executedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executedByUserId, true), gettype($executedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($executedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $executedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($executedByUserId, true)), __LINE__);
        }
        if (is_null($executedByUserId) || (is_array($executedByUserId) && empty($executedByUserId))) {
            unset($this->ExecutedByUserId);
        } else {
            $this->ExecutedByUserId = $executedByUserId;
        }
        return $this;
    }
    /**
     * Get FailuresRecordCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailuresRecordCount()
    {
        return isset($this->FailuresRecordCount) ? $this->FailuresRecordCount : null;
    }
    /**
     * Set FailuresRecordCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failuresRecordCount
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setFailuresRecordCount($failuresRecordCount = null)
    {
        // validation for constraint: int
        if (!is_null($failuresRecordCount) && !(is_int($failuresRecordCount) || ctype_digit($failuresRecordCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failuresRecordCount, true), gettype($failuresRecordCount)), __LINE__);
        }
        if (is_null($failuresRecordCount) || (is_array($failuresRecordCount) && empty($failuresRecordCount))) {
            unset($this->FailuresRecordCount);
        } else {
            $this->FailuresRecordCount = $failuresRecordCount;
        }
        return $this;
    }
    /**
     * Get FirstImportedCustomerCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstImportedCustomerCrmId()
    {
        return isset($this->FirstImportedCustomerCrmId) ? $this->FirstImportedCustomerCrmId : null;
    }
    /**
     * Set FirstImportedCustomerCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstImportedCustomerCrmId
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setFirstImportedCustomerCrmId($firstImportedCustomerCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($firstImportedCustomerCrmId) && !is_string($firstImportedCustomerCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstImportedCustomerCrmId, true), gettype($firstImportedCustomerCrmId)), __LINE__);
        }
        if (is_null($firstImportedCustomerCrmId) || (is_array($firstImportedCustomerCrmId) && empty($firstImportedCustomerCrmId))) {
            unset($this->FirstImportedCustomerCrmId);
        } else {
            $this->FirstImportedCustomerCrmId = $firstImportedCustomerCrmId;
        }
        return $this;
    }
    /**
     * Get ImportCustomersErrorsLog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportCustomersErrorsLog()
    {
        return isset($this->ImportCustomersErrorsLog) ? $this->ImportCustomersErrorsLog : null;
    }
    /**
     * Set ImportCustomersErrorsLog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importCustomersErrorsLog
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setImportCustomersErrorsLog($importCustomersErrorsLog = null)
    {
        // validation for constraint: string
        if (!is_null($importCustomersErrorsLog) && !is_string($importCustomersErrorsLog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importCustomersErrorsLog, true), gettype($importCustomersErrorsLog)), __LINE__);
        }
        if (is_null($importCustomersErrorsLog) || (is_array($importCustomersErrorsLog) && empty($importCustomersErrorsLog))) {
            unset($this->ImportCustomersErrorsLog);
        } else {
            $this->ImportCustomersErrorsLog = $importCustomersErrorsLog;
        }
        return $this;
    }
    /**
     * Get ImportCustomersFileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportCustomersFileName()
    {
        return isset($this->ImportCustomersFileName) ? $this->ImportCustomersFileName : null;
    }
    /**
     * Set ImportCustomersFileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importCustomersFileName
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setImportCustomersFileName($importCustomersFileName = null)
    {
        // validation for constraint: string
        if (!is_null($importCustomersFileName) && !is_string($importCustomersFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importCustomersFileName, true), gettype($importCustomersFileName)), __LINE__);
        }
        if (is_null($importCustomersFileName) || (is_array($importCustomersFileName) && empty($importCustomersFileName))) {
            unset($this->ImportCustomersFileName);
        } else {
            $this->ImportCustomersFileName = $importCustomersFileName;
        }
        return $this;
    }
    /**
     * Get ImportDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportDuration()
    {
        return isset($this->ImportDuration) ? $this->ImportDuration : null;
    }
    /**
     * Set ImportDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importDuration
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setImportDuration($importDuration = null)
    {
        // validation for constraint: string
        if (!is_null($importDuration) && !is_string($importDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importDuration, true), gettype($importDuration)), __LINE__);
        }
        if (is_null($importDuration) || (is_array($importDuration) && empty($importDuration))) {
            unset($this->ImportDuration);
        } else {
            $this->ImportDuration = $importDuration;
        }
        return $this;
    }
    /**
     * Get ImportEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportEndDate()
    {
        return isset($this->ImportEndDate) ? $this->ImportEndDate : null;
    }
    /**
     * Set ImportEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importEndDate
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setImportEndDate($importEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($importEndDate) && !is_string($importEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importEndDate, true), gettype($importEndDate)), __LINE__);
        }
        if (is_null($importEndDate) || (is_array($importEndDate) && empty($importEndDate))) {
            unset($this->ImportEndDate);
        } else {
            $this->ImportEndDate = $importEndDate;
        }
        return $this;
    }
    /**
     * Get ImportStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportStartDate()
    {
        return isset($this->ImportStartDate) ? $this->ImportStartDate : null;
    }
    /**
     * Set ImportStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importStartDate
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setImportStartDate($importStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($importStartDate) && !is_string($importStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importStartDate, true), gettype($importStartDate)), __LINE__);
        }
        if (is_null($importStartDate) || (is_array($importStartDate) && empty($importStartDate))) {
            unset($this->ImportStartDate);
        } else {
            $this->ImportStartDate = $importStartDate;
        }
        return $this;
    }
    /**
     * Get IsErrorsLogExist value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsErrorsLogExist()
    {
        return isset($this->IsErrorsLogExist) ? $this->IsErrorsLogExist : null;
    }
    /**
     * Set IsErrorsLogExist value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isErrorsLogExist
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setIsErrorsLogExist($isErrorsLogExist = null)
    {
        // validation for constraint: boolean
        if (!is_null($isErrorsLogExist) && !is_bool($isErrorsLogExist)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isErrorsLogExist, true), gettype($isErrorsLogExist)), __LINE__);
        }
        if (is_null($isErrorsLogExist) || (is_array($isErrorsLogExist) && empty($isErrorsLogExist))) {
            unset($this->IsErrorsLogExist);
        } else {
            $this->IsErrorsLogExist = $isErrorsLogExist;
        }
        return $this;
    }
    /**
     * Get LastImportedCustomerCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastImportedCustomerCrmId()
    {
        return isset($this->LastImportedCustomerCrmId) ? $this->LastImportedCustomerCrmId : null;
    }
    /**
     * Set LastImportedCustomerCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastImportedCustomerCrmId
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setLastImportedCustomerCrmId($lastImportedCustomerCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($lastImportedCustomerCrmId) && !is_string($lastImportedCustomerCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastImportedCustomerCrmId, true), gettype($lastImportedCustomerCrmId)), __LINE__);
        }
        if (is_null($lastImportedCustomerCrmId) || (is_array($lastImportedCustomerCrmId) && empty($lastImportedCustomerCrmId))) {
            unset($this->LastImportedCustomerCrmId);
        } else {
            $this->LastImportedCustomerCrmId = $lastImportedCustomerCrmId;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CustomerExternalManipulationOperation::valueIsValid()
     * @uses \patest\EnumType\CustomerExternalManipulationOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CustomerExternalManipulationOperation::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CustomerExternalManipulationOperation', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \patest\EnumType\CustomerExternalManipulationOperation::getValidValues())), __LINE__);
        }
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProcessedRecordCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessedRecordCount()
    {
        return isset($this->ProcessedRecordCount) ? $this->ProcessedRecordCount : null;
    }
    /**
     * Set ProcessedRecordCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processedRecordCount
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setProcessedRecordCount($processedRecordCount = null)
    {
        // validation for constraint: int
        if (!is_null($processedRecordCount) && !(is_int($processedRecordCount) || ctype_digit($processedRecordCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processedRecordCount, true), gettype($processedRecordCount)), __LINE__);
        }
        if (is_null($processedRecordCount) || (is_array($processedRecordCount) && empty($processedRecordCount))) {
            unset($this->ProcessedRecordCount);
        } else {
            $this->ProcessedRecordCount = $processedRecordCount;
        }
        return $this;
    }
    /**
     * Get ProgressPct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProgressPct()
    {
        return isset($this->ProgressPct) ? $this->ProgressPct : null;
    }
    /**
     * Set ProgressPct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $progressPct
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setProgressPct($progressPct = null)
    {
        // validation for constraint: int
        if (!is_null($progressPct) && !(is_int($progressPct) || ctype_digit($progressPct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($progressPct, true), gettype($progressPct)), __LINE__);
        }
        if (is_null($progressPct) || (is_array($progressPct) && empty($progressPct))) {
            unset($this->ProgressPct);
        } else {
            $this->ProgressPct = $progressPct;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ImportCustomersStatusKind::valueIsValid()
     * @uses \patest\EnumType\ImportCustomersStatusKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ImportCustomersStatusKind::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ImportCustomersStatusKind', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ImportCustomersStatusKind::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SuccessfulRecordCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSuccessfulRecordCount()
    {
        return isset($this->SuccessfulRecordCount) ? $this->SuccessfulRecordCount : null;
    }
    /**
     * Set SuccessfulRecordCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $successfulRecordCount
     * @return \patest\StructType\Crm_CustomersExternalManipulationProcessHistory
     */
    public function setSuccessfulRecordCount($successfulRecordCount = null)
    {
        // validation for constraint: int
        if (!is_null($successfulRecordCount) && !(is_int($successfulRecordCount) || ctype_digit($successfulRecordCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($successfulRecordCount, true), gettype($successfulRecordCount)), __LINE__);
        }
        if (is_null($successfulRecordCount) || (is_array($successfulRecordCount) && empty($successfulRecordCount))) {
            unset($this->SuccessfulRecordCount);
        } else {
            $this->SuccessfulRecordCount = $successfulRecordCount;
        }
        return $this;
    }
}
