<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.CustomerFilter StructType
 * @subpackage Structs
 */
class Crm_CustomerFilter extends Crm_ClientFilter
{
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The IDCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDCardNumber;
    /**
     * The IsDeceased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeceased;
    /**
     * The IsHouseholdRepresentative
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHouseholdRepresentative;
    /**
     * The IsRemoved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRemoved;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The OtherName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtherName;
    /**
     * The TextSearchOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextSearchOption;
    /**
     * The WorkPlace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkPlace;
    /**
     * Constructor method for Crm.CustomerFilter
     * @uses Crm_CustomerFilter::setFirstName()
     * @uses Crm_CustomerFilter::setIDCardNumber()
     * @uses Crm_CustomerFilter::setIsDeceased()
     * @uses Crm_CustomerFilter::setIsHouseholdRepresentative()
     * @uses Crm_CustomerFilter::setIsRemoved()
     * @uses Crm_CustomerFilter::setLastName()
     * @uses Crm_CustomerFilter::setOtherName()
     * @uses Crm_CustomerFilter::setTextSearchOption()
     * @uses Crm_CustomerFilter::setWorkPlace()
     * @param string $firstName
     * @param string $iDCardNumber
     * @param bool $isDeceased
     * @param bool $isHouseholdRepresentative
     * @param bool $isRemoved
     * @param string $lastName
     * @param string $otherName
     * @param string $textSearchOption
     * @param string $workPlace
     */
    public function __construct($firstName = null, $iDCardNumber = null, $isDeceased = null, $isHouseholdRepresentative = null, $isRemoved = null, $lastName = null, $otherName = null, $textSearchOption = null, $workPlace = null)
    {
        $this
            ->setFirstName($firstName)
            ->setIDCardNumber($iDCardNumber)
            ->setIsDeceased($isDeceased)
            ->setIsHouseholdRepresentative($isHouseholdRepresentative)
            ->setIsRemoved($isRemoved)
            ->setLastName($lastName)
            ->setOtherName($otherName)
            ->setTextSearchOption($textSearchOption)
            ->setWorkPlace($workPlace);
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\Crm_CustomerFilter
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get IDCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDCardNumber()
    {
        return isset($this->IDCardNumber) ? $this->IDCardNumber : null;
    }
    /**
     * Set IDCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDCardNumber
     * @return \patest\StructType\Crm_CustomerFilter
     */
    public function setIDCardNumber($iDCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iDCardNumber) && !is_string($iDCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCardNumber, true), gettype($iDCardNumber)), __LINE__);
        }
        if (is_null($iDCardNumber) || (is_array($iDCardNumber) && empty($iDCardNumber))) {
            unset($this->IDCardNumber);
        } else {
            $this->IDCardNumber = $iDCardNumber;
        }
        return $this;
    }
    /**
     * Get IsDeceased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeceased()
    {
        return isset($this->IsDeceased) ? $this->IsDeceased : null;
    }
    /**
     * Set IsDeceased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeceased
     * @return \patest\StructType\Crm_CustomerFilter
     */
    public function setIsDeceased($isDeceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeceased) && !is_bool($isDeceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeceased, true), gettype($isDeceased)), __LINE__);
        }
        if (is_null($isDeceased) || (is_array($isDeceased) && empty($isDeceased))) {
            unset($this->IsDeceased);
        } else {
            $this->IsDeceased = $isDeceased;
        }
        return $this;
    }
    /**
     * Get IsHouseholdRepresentative value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHouseholdRepresentative()
    {
        return isset($this->IsHouseholdRepresentative) ? $this->IsHouseholdRepresentative : null;
    }
    /**
     * Set IsHouseholdRepresentative value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHouseholdRepresentative
     * @return \patest\StructType\Crm_CustomerFilter
     */
    public function setIsHouseholdRepresentative($isHouseholdRepresentative = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHouseholdRepresentative) && !is_bool($isHouseholdRepresentative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHouseholdRepresentative, true), gettype($isHouseholdRepresentative)), __LINE__);
        }
        if (is_null($isHouseholdRepresentative) || (is_array($isHouseholdRepresentative) && empty($isHouseholdRepresentative))) {
            unset($this->IsHouseholdRepresentative);
        } else {
            $this->IsHouseholdRepresentative = $isHouseholdRepresentative;
        }
        return $this;
    }
    /**
     * Get IsRemoved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRemoved()
    {
        return isset($this->IsRemoved) ? $this->IsRemoved : null;
    }
    /**
     * Set IsRemoved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRemoved
     * @return \patest\StructType\Crm_CustomerFilter
     */
    public function setIsRemoved($isRemoved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRemoved) && !is_bool($isRemoved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRemoved, true), gettype($isRemoved)), __LINE__);
        }
        if (is_null($isRemoved) || (is_array($isRemoved) && empty($isRemoved))) {
            unset($this->IsRemoved);
        } else {
            $this->IsRemoved = $isRemoved;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\Crm_CustomerFilter
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get OtherName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtherName()
    {
        return isset($this->OtherName) ? $this->OtherName : null;
    }
    /**
     * Set OtherName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otherName
     * @return \patest\StructType\Crm_CustomerFilter
     */
    public function setOtherName($otherName = null)
    {
        // validation for constraint: string
        if (!is_null($otherName) && !is_string($otherName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherName, true), gettype($otherName)), __LINE__);
        }
        if (is_null($otherName) || (is_array($otherName) && empty($otherName))) {
            unset($this->OtherName);
        } else {
            $this->OtherName = $otherName;
        }
        return $this;
    }
    /**
     * Get TextSearchOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextSearchOption()
    {
        return isset($this->TextSearchOption) ? $this->TextSearchOption : null;
    }
    /**
     * Set TextSearchOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LastnameFilterOperator::valueIsValid()
     * @uses \patest\EnumType\LastnameFilterOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $textSearchOption
     * @return \patest\StructType\Crm_CustomerFilter
     */
    public function setTextSearchOption($textSearchOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LastnameFilterOperator::valueIsValid($textSearchOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LastnameFilterOperator', is_array($textSearchOption) ? implode(', ', $textSearchOption) : var_export($textSearchOption, true), implode(', ', \patest\EnumType\LastnameFilterOperator::getValidValues())), __LINE__);
        }
        if (is_null($textSearchOption) || (is_array($textSearchOption) && empty($textSearchOption))) {
            unset($this->TextSearchOption);
        } else {
            $this->TextSearchOption = $textSearchOption;
        }
        return $this;
    }
    /**
     * Get WorkPlace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkPlace()
    {
        return isset($this->WorkPlace) ? $this->WorkPlace : null;
    }
    /**
     * Set WorkPlace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workPlace
     * @return \patest\StructType\Crm_CustomerFilter
     */
    public function setWorkPlace($workPlace = null)
    {
        // validation for constraint: string
        if (!is_null($workPlace) && !is_string($workPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workPlace, true), gettype($workPlace)), __LINE__);
        }
        if (is_null($workPlace) || (is_array($workPlace) && empty($workPlace))) {
            unset($this->WorkPlace);
        } else {
            $this->WorkPlace = $workPlace;
        }
        return $this;
    }
}
